/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.postag;

import java.io.File;
import java.io.IOException;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.postag.MutableTagDictionary;
import opennlp.tools.postag.POSDictionary;
import opennlp.tools.postag.POSEvaluator;
import opennlp.tools.postag.POSModel;
import opennlp.tools.postag.POSSample;
import opennlp.tools.postag.POSTaggerEvaluationMonitor;
import opennlp.tools.postag.POSTaggerFactory;
import opennlp.tools.postag.POSTaggerME;
import opennlp.tools.postag.TagDictionary;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.TrainingParameters;
import opennlp.tools.util.eval.CrossValidationPartitioner;
import opennlp.tools.util.eval.Mean;
import opennlp.tools.util.model.ModelType;
import opennlp.tools.util.model.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class POSTaggerCrossValidator {
    private final String languageCode;
    private final TrainingParameters params;
    private Integer ngramCutoff;
    private Mean wordAccuracy = new Mean();
    private POSTaggerEvaluationMonitor[] listeners;
    private String factoryClassName;
    private POSTaggerFactory factory;
    private Integer tagdicCutoff = null;
    private File tagDictionaryFile;

    public POSTaggerCrossValidator(String languageCode, TrainingParameters trainParam, File tagDictionary, Integer ngramCutoff, Integer tagdicCutoff, String factoryClass, POSTaggerEvaluationMonitor ... listeners) {
        this.languageCode = languageCode;
        this.params = trainParam;
        this.ngramCutoff = ngramCutoff;
        this.listeners = listeners;
        this.factoryClassName = factoryClass;
        this.tagdicCutoff = tagdicCutoff;
        this.tagDictionaryFile = tagDictionary;
    }

    public POSTaggerCrossValidator(String languageCode, TrainingParameters trainParam, POSTaggerFactory factory, POSTaggerEvaluationMonitor ... listeners) {
        this.languageCode = languageCode;
        this.params = trainParam;
        this.listeners = listeners;
        this.factory = factory;
        this.ngramCutoff = null;
        this.tagdicCutoff = null;
    }

    public POSTaggerCrossValidator(String languageCode, ModelType modelType, POSDictionary tagDictionary, Dictionary ngramDictionary, int cutoff, int iterations) {
        this(languageCode, POSTaggerCrossValidator.create(modelType, cutoff, iterations), POSTaggerCrossValidator.create(ngramDictionary, tagDictionary), new POSTaggerEvaluationMonitor[0]);
    }

    public POSTaggerCrossValidator(String languageCode, ModelType modelType, POSDictionary tagDictionary, Dictionary ngramDictionary) {
        this(languageCode, POSTaggerCrossValidator.create(modelType, 5, 100), POSTaggerCrossValidator.create(ngramDictionary, tagDictionary), new POSTaggerEvaluationMonitor[0]);
    }

    public POSTaggerCrossValidator(String languageCode, TrainingParameters trainParam, POSDictionary tagDictionary, POSTaggerEvaluationMonitor ... listeners) {
        this(languageCode, trainParam, POSTaggerCrossValidator.create(null, tagDictionary), listeners);
    }

    public POSTaggerCrossValidator(String languageCode, TrainingParameters trainParam, POSDictionary tagDictionary, Integer ngramCutoff, POSTaggerEvaluationMonitor ... listeners) {
        this(languageCode, trainParam, POSTaggerCrossValidator.create(null, tagDictionary), listeners);
        this.ngramCutoff = ngramCutoff;
    }

    public POSTaggerCrossValidator(String languageCode, TrainingParameters trainParam, POSDictionary tagDictionary, Dictionary ngramDictionary, POSTaggerEvaluationMonitor ... listeners) {
        this(languageCode, trainParam, POSTaggerCrossValidator.create(ngramDictionary, tagDictionary), listeners);
    }

    public void evaluate(ObjectStream<POSSample> samples, int nFolds) throws IOException {
        CrossValidationPartitioner<POSSample> partitioner = new CrossValidationPartitioner<POSSample>(samples, nFolds);
        while (partitioner.hasNext()) {
            Dictionary ngramDict;
            CrossValidationPartitioner.TrainingSampleStream<POSSample> trainingSampleStream = partitioner.next();
            if (this.factory == null) {
                this.factory = POSTaggerFactory.create(this.factoryClassName, null, null);
            }
            if ((ngramDict = this.factory.getDictionary()) == null) {
                if (this.ngramCutoff != null) {
                    System.err.print("Building ngram dictionary ... ");
                    ngramDict = POSTaggerME.buildNGramDictionary(trainingSampleStream, this.ngramCutoff);
                    trainingSampleStream.reset();
                    System.err.println("done");
                }
                this.factory.setDictionary(ngramDict);
            }
            if (this.tagDictionaryFile != null && this.factory.getTagDictionary() == null) {
                this.factory.setTagDictionary(this.factory.createTagDictionary(this.tagDictionaryFile));
            }
            if (this.tagdicCutoff != null) {
                TagDictionary dict = this.factory.getTagDictionary();
                if (dict == null) {
                    dict = this.factory.createEmptyTagDictionary();
                    this.factory.setTagDictionary(dict);
                }
                if (!(dict instanceof MutableTagDictionary)) {
                    throw new IllegalArgumentException("Can't extend a TagDictionary that does not implement MutableTagDictionary.");
                }
                POSTaggerME.populatePOSDictionary(trainingSampleStream, (MutableTagDictionary)dict, this.tagdicCutoff);
                trainingSampleStream.reset();
            }
            POSModel model = POSTaggerME.train(this.languageCode, trainingSampleStream, this.params, this.factory);
            POSEvaluator evaluator = new POSEvaluator(new POSTaggerME(model), this.listeners);
            evaluator.evaluate(trainingSampleStream.getTestSampleStream());
            this.wordAccuracy.add(evaluator.getWordAccuracy(), evaluator.getWordCount());
            if (this.tagdicCutoff == null) continue;
            this.factory.setTagDictionary(null);
        }
    }

    public double getWordAccuracy() {
        return this.wordAccuracy.mean();
    }

    public long getWordCount() {
        return this.wordAccuracy.count();
    }

    private static TrainingParameters create(ModelType type, int cutoff, int iterations) {
        TrainingParameters params = ModelUtil.createTrainingParameters(iterations, cutoff);
        params.put("Algorithm", type.toString());
        return params;
    }

    private static POSTaggerFactory create(Dictionary ngram, TagDictionary pos) {
        return new POSTaggerFactory(ngram, pos);
    }
}

