library(diffee)

graphics.off()
par(ask=F)
par(mfrow=c(1,1))


readline(prompt="Press [enter] to continue to cancer demo with 2 tasks (not v. pcr) and 26 features (26 cancer types) ")

### load cancer data (cancer)
data(cancer)

### create a list of cancer data (cancerlist)
cancerlist = list(as.matrix(cancer[[1]][which(cancer[[2]] == "not"),]),
                  as.matrix(cancer[[1]][which(cancer[[2]] == "pcr"),]))

### run the diffee
result = diffee(cancerlist[[1]], cancerlist[[2]], 40)

### obtain names for node labelling
label = colnames(cancer[[1]])

### obtain graph for creating layout
graph = returngraph(result)

### create a fixed layout on cancergraph for plotting
layout = layout_nicely(graph,dim=2)

readline(prompt="Press [enter] to view the difference graph generated by diffee")

### plot the estimated graphs by diffee
plot.diffee(result, graphlabel = label, graphlayout = layout)

readline(prompt="Press [enter] to view the difference graph zooming into node BECNI and FLJI2650")

nodeid = which(label %in% c("BECNI","FLJI2650")) ### look for id

plot.diffee(result, graphlabel = label, type = "neighbour",index = nodeid, graphlayout = layout)



