/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.probdist.ContinuousDistribution;
import umontreal.iro.lecuyer.probdist.NormalDist;

public class LognormalDist
extends ContinuousDistribution {
    private double mu;
    private double sigma;

    public LognormalDist() {
        this.setParams(0.0, 1.0);
    }

    public LognormalDist(double d, double d2) {
        this.setParams(d, d2);
    }

    public double density(double d) {
        return LognormalDist.density(this.mu, this.sigma, d);
    }

    public double cdf(double d) {
        return LognormalDist.cdf(this.mu, this.sigma, d);
    }

    public double barF(double d) {
        return LognormalDist.barF(this.mu, this.sigma, d);
    }

    public double inverseF(double d) {
        return LognormalDist.inverseF(this.mu, this.sigma, d);
    }

    public double getMean() {
        return LognormalDist.getMean(this.mu, this.sigma);
    }

    public double getVariance() {
        return LognormalDist.getVariance(this.mu, this.sigma);
    }

    public double getStandardDeviation() {
        return LognormalDist.getStandardDeviation(this.mu, this.sigma);
    }

    public static double density(double d, double d2, double d3) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("sigma <= 0");
        }
        if (d3 <= 0.0) {
            return 0.0;
        }
        double d4 = Math.log(d3) - d;
        return Math.exp(-d4 * d4 / (2.0 * d2 * d2)) / (Math.sqrt(Math.PI * 2) * d2 * d3);
    }

    public static double cdf(double d, double d2, double d3) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("sigma  <= 0");
        }
        if (d3 <= 0.0) {
            return 0.0;
        }
        return NormalDist.cdf01((Math.log(d3) - d) / d2);
    }

    public static double barF(double d, double d2, double d3) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("sigma  <= 0");
        }
        if (d3 <= 0.0) {
            return 1.0;
        }
        return NormalDist.barF01((Math.log(d3) - d) / d2);
    }

    public static double inverseF(double d, double d2, double d3) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("sigma  <= 0");
        }
        if (d3 > 1.0 || d3 < 0.0) {
            throw new IllegalArgumentException("u not in [0,1]");
        }
        if (2.220446049250313E-16 >= 1.0 - d3) {
            return Double.POSITIVE_INFINITY;
        }
        if (d3 <= 0.0) {
            return 0.0;
        }
        double d4 = NormalDist.inverseF01(d3);
        double d5 = d + d2 * d4;
        if (d4 >= 100.0 || d5 >= 709.782712893384) {
            return Double.POSITIVE_INFINITY;
        }
        if (d4 <= -100.0 || d5 <= -709.782712893384) {
            return 0.0;
        }
        return Math.exp(d5);
    }

    public static double[] getMLE(double[] dArray, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        double[] dArray2 = new double[2];
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            if (dArray[i] > 0.0) {
                d += Math.log(dArray[i]);
                continue;
            }
            d += -709.089565712824;
        }
        dArray2[0] = d / (double)n;
        d = 0.0;
        for (int i = 0; i < n; ++i) {
            double d2 = dArray[i] > 0.0 ? Math.log(dArray[i]) - dArray2[0] : -709.089565712824 - dArray2[0];
            d += d2 * d2;
        }
        dArray2[1] = Math.sqrt(d / (double)n);
        return dArray2;
    }

    public static double[] getMaximumLikelihoodEstimate(double[] dArray, int n) {
        return LognormalDist.getMLE(dArray, n);
    }

    public static LognormalDist getInstanceFromMLE(double[] dArray, int n) {
        double[] dArray2 = LognormalDist.getMaximumLikelihoodEstimate(dArray, n);
        return new LognormalDist(dArray2[0], dArray2[1]);
    }

    public static double getMean(double d, double d2) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("sigma <= 0");
        }
        return Math.exp(d + d2 * d2 / 2.0);
    }

    public static double getVariance(double d, double d2) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("sigma <= 0");
        }
        return Math.exp(2.0 * d + d2 * d2) * (Math.exp(d2 * d2) - 1.0);
    }

    public static double getStandardDeviation(double d, double d2) {
        return Math.sqrt(LognormalDist.getVariance(d, d2));
    }

    public double getMu() {
        return this.mu;
    }

    public double getSigma() {
        return this.sigma;
    }

    public void setParams(double d, double d2) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("sigma <= 0");
        }
        this.mu = d;
        this.sigma = d2;
        this.supportA = 0.0;
    }

    public double[] getParams() {
        double[] dArray = new double[]{this.mu, this.sigma};
        return dArray;
    }

    public String toString() {
        return this.getClass().getName() + " : mu = " + this.mu + ", sigma = " + this.sigma;
    }
}

