/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.amazonaws.services.glue.model.transform;

import com.simba.athena.amazonaws.SdkClientException;
import com.simba.athena.amazonaws.annotation.SdkInternalApi;
import com.simba.athena.amazonaws.protocol.MarshallLocation;
import com.simba.athena.amazonaws.protocol.MarshallingInfo;
import com.simba.athena.amazonaws.protocol.MarshallingType;
import com.simba.athena.amazonaws.protocol.ProtocolMarshaller;
import com.simba.athena.amazonaws.services.glue.model.EncryptionAtRest;

@SdkInternalApi
public class EncryptionAtRestMarshaller {
    private static final MarshallingInfo<String> CATALOGENCRYPTIONMODE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CatalogEncryptionMode").build();
    private static final MarshallingInfo<String> SSEAWSKMSKEYID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SseAwsKmsKeyId").build();
    private static final EncryptionAtRestMarshaller instance = new EncryptionAtRestMarshaller();

    public static EncryptionAtRestMarshaller getInstance() {
        return instance;
    }

    public void marshall(EncryptionAtRest encryptionAtRest, ProtocolMarshaller protocolMarshaller) {
        if (encryptionAtRest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(encryptionAtRest.getCatalogEncryptionMode(), CATALOGENCRYPTIONMODE_BINDING);
            protocolMarshaller.marshall(encryptionAtRest.getSseAwsKmsKeyId(), SSEAWSKMSKEYID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

