/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.amazonaws.regions;

import com.simba.athena.amazonaws.regions.Region;
import com.simba.athena.amazonaws.regions.RegionMetadataProvider;
import java.net.URI;

public abstract class AbstractRegionMetadataProvider
implements RegionMetadataProvider {
    @Override
    public Region getRegionByEndpoint(String endpoint) {
        String host = AbstractRegionMetadataProvider.getHost(endpoint);
        for (Region region : this.getRegions()) {
            for (String serviceEndpoint : region.getAvailableEndpoints()) {
                if (!host.equals(AbstractRegionMetadataProvider.getHost(serviceEndpoint))) continue;
                return region;
            }
        }
        throw new IllegalArgumentException("No region found with any service for endpoint " + endpoint);
    }

    private static String getHost(String endpoint) {
        String host = URI.create(endpoint).getHost();
        if (host == null) {
            host = URI.create("http://" + endpoint).getHost();
        }
        return host;
    }
}

