/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.jdbc.jdbc41;

import com.simba.athena.dsi.core.interfaces.IConnection;
import com.simba.athena.dsi.core.interfaces.IStatement;
import com.simba.athena.dsi.dataengine.interfaces.IColumn;
import com.simba.athena.dsi.dataengine.interfaces.IResultSet;
import com.simba.athena.dsi.dataengine.interfaces.IResults;
import com.simba.athena.dsi.dataengine.utilities.DataWrapper;
import com.simba.athena.dsi.dataengine.utilities.ExecutionResult;
import com.simba.athena.dsi.dataengine.utilities.ExecutionResultType;
import com.simba.athena.exceptions.ExceptionConverter;
import com.simba.athena.exceptions.JDBCMessageKey;
import com.simba.athena.jdbc.common.SCallableStatement;
import com.simba.athena.jdbc.common.SConnection;
import com.simba.athena.jdbc.common.SForwardResultSet;
import com.simba.athena.jdbc.common.SResultSetMetaData;
import com.simba.athena.jdbc.jdbc41.S41Array;
import com.simba.athena.jdbc.jdbc41.S41ForwardResultSet;
import com.simba.athena.jdbc.jdbc41.S41ParameterMetaData;
import com.simba.athena.jdbc.jdbc41.S41ResultSetMetaData;
import com.simba.athena.jdbc.jdbc41.S41UpdatableForwardResultSet;
import com.simba.athena.support.IWarningListener;
import com.simba.athena.support.LogUtilities;
import com.simba.athena.support.exceptions.ExceptionType;
import com.simba.athena.utilities.JDBCVersion;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;

public class S41CallableStatement
extends SCallableStatement {
    public S41CallableStatement(String string, IStatement iStatement, SConnection sConnection, int n) throws SQLException {
        super(string, iStatement, sConnection, n);
        this.m_jdbcVersion = JDBCVersion.JDBC41;
    }

    @Override
    protected ResultSet createResultSet(IResultSet iResultSet, boolean bl, int n) throws SQLException {
        SForwardResultSet sForwardResultSet = bl ? new S41UpdatableForwardResultSet(this, iResultSet, this.getLogger()) : new S41ForwardResultSet(this, iResultSet, this.getLogger());
        sForwardResultSet.setFetchSize(n);
        return sForwardResultSet;
    }

    @Override
    public synchronized ResultSetMetaData getMetaData() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
            this.checkIfOpen();
            if (null == this.getResultSetMetaData()) {
                IResults iResults = this.getQueryExecutor().getResults();
                Iterator<ExecutionResult> iterator = iResults.getResultItr();
                if (!iterator.hasNext()) {
                    return null;
                }
                ExecutionResult executionResult = iterator.next();
                if (iterator.hasNext()) {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_NUMBER_METADATA, (IWarningListener)this.getWarningListener(), ExceptionType.DEFAULT, new Object[0]);
                }
                if (ExecutionResultType.RESULT_SET == executionResult.getType()) {
                    IResultSet iResultSet = (IResultSet)executionResult.getResult();
                    this.setResultSetMetadata(this.createResultSetMetaData(iResultSet));
                }
            }
            return this.getResultSetMetaData();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    protected SResultSetMetaData createResultSetMetaData(IResultSet iResultSet) throws SQLException {
        try {
            ArrayList<? extends IColumn> arrayList = iResultSet.getSelectColumns();
            if (null == arrayList) {
                return null;
            }
            return new S41ResultSetMetaData(arrayList, this.getLogger(), this.getWarningListener());
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public synchronized ParameterMetaData getParameterMetaData() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
            this.checkIfOpen();
            if (null == this.getOpenParamMetaData()) {
                S41ParameterMetaData s41ParameterMetaData = null;
                s41ParameterMetaData = new S41ParameterMetaData(this.getParameterMetadataList(), this.getLogger(), this.getWarningListener());
                this.setOpenParamMetaData(s41ParameterMetaData);
            }
            return this.getOpenParamMetaData();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public synchronized <T> T getObject(int n, Class<T> clazz) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, clazz);
            this.checkIfOpen();
            if (clazz.equals(BigDecimal.class)) {
                return (T)this.getBigDecimal(n);
            }
            if (clazz.equals(Boolean.class) || clazz.equals(Boolean.TYPE)) {
                return (T)Boolean.valueOf(this.getBoolean(n));
            }
            if (clazz.equals(Byte.class) || clazz.equals(Byte.TYPE)) {
                return (T)Byte.valueOf(this.getByte(n));
            }
            if (clazz.equals(byte[].class)) {
                return (T)this.getBytes(n);
            }
            if (clazz.equals(Date.class)) {
                return (T)this.getDate(n);
            }
            if (clazz.equals(Double.class) || clazz.equals(Double.TYPE)) {
                return (T)Double.valueOf(this.getDouble(n));
            }
            if (clazz.equals(Float.class) || clazz.equals(Float.TYPE)) {
                return (T)Float.valueOf(this.getFloat(n));
            }
            if (clazz.equals(Integer.class) || clazz.equals(Integer.TYPE)) {
                return (T)Integer.valueOf(this.getInt(n));
            }
            if (clazz.equals(Long.class) || clazz.equals(Long.TYPE)) {
                return (T)Long.valueOf(this.getLong(n));
            }
            if (clazz.equals(Object.class)) {
                return (T)this.getObject(n);
            }
            if (clazz.equals(Short.class) || clazz.equals(Short.TYPE)) {
                return (T)Short.valueOf(this.getShort(n));
            }
            if (clazz.equals(String.class)) {
                return (T)this.getString(n);
            }
            if (clazz.equals(Time.class)) {
                return (T)this.getTime(n);
            }
            if (clazz.equals(Timestamp.class)) {
                return (T)this.getTimestamp(n);
            }
            if (clazz.equals(Array.class) || clazz.equals(Blob.class) || clazz.equals(Clob.class) || clazz.equals(Ref.class) || clazz.equals(URL.class) || clazz.equals(NClob.class) || clazz.equals(RowId.class) || clazz.equals(SQLXML.class)) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_PARAM_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, String.valueOf(n), clazz.getName());
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public <T> T getObject(String string, Class<T> clazz) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, clazz);
        return this.getObject(this.getParameterIndex(string), clazz);
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
            this.checkIfOpen();
            this.m_closeOnCompletion = true;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
            this.checkIfOpen();
            return this.m_closeOnCompletion;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public Array getArray(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            DataWrapper dataWrapper = this.getOutputParameterValue(n);
            IConnection iConnection = this.getParentConnection().getConnection();
            return new S41Array(dataWrapper.getArray(), iConnection, this.m_logger, this.m_warningListener);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }
}

