/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.shaded.apache.http.impl.pool;

import com.simba.athena.shaded.apache.http.HttpClientConnection;
import com.simba.athena.shaded.apache.http.HttpHost;
import com.simba.athena.shaded.apache.http.annotation.Contract;
import com.simba.athena.shaded.apache.http.annotation.ThreadingBehavior;
import com.simba.athena.shaded.apache.http.config.ConnectionConfig;
import com.simba.athena.shaded.apache.http.config.SocketConfig;
import com.simba.athena.shaded.apache.http.impl.pool.BasicConnFactory;
import com.simba.athena.shaded.apache.http.impl.pool.BasicPoolEntry;
import com.simba.athena.shaded.apache.http.params.HttpParams;
import com.simba.athena.shaded.apache.http.pool.AbstractConnPool;
import com.simba.athena.shaded.apache.http.pool.ConnFactory;
import java.util.concurrent.atomic.AtomicLong;

@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
public class BasicConnPool
extends AbstractConnPool<HttpHost, HttpClientConnection, BasicPoolEntry> {
    private static final AtomicLong COUNTER = new AtomicLong();

    public BasicConnPool(ConnFactory<HttpHost, HttpClientConnection> connFactory) {
        super(connFactory, 2, 20);
    }

    @Deprecated
    public BasicConnPool(HttpParams params) {
        super(new BasicConnFactory(params), 2, 20);
    }

    public BasicConnPool(SocketConfig sconfig, ConnectionConfig cconfig) {
        super(new BasicConnFactory(sconfig, cconfig), 2, 20);
    }

    public BasicConnPool() {
        super(new BasicConnFactory(SocketConfig.DEFAULT, ConnectionConfig.DEFAULT), 2, 20);
    }

    @Override
    protected BasicPoolEntry createEntry(HttpHost host, HttpClientConnection conn) {
        return new BasicPoolEntry(Long.toString(COUNTER.getAndIncrement()), host, conn);
    }

    @Override
    protected boolean validate(BasicPoolEntry entry) {
        return !((HttpClientConnection)entry.getConnection()).isStale();
    }
}

