/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.shaded.apache.http.protocol;

import com.simba.athena.shaded.apache.http.HttpException;
import com.simba.athena.shaded.apache.http.HttpResponse;
import com.simba.athena.shaded.apache.http.HttpResponseInterceptor;
import com.simba.athena.shaded.apache.http.annotation.Contract;
import com.simba.athena.shaded.apache.http.annotation.ThreadingBehavior;
import com.simba.athena.shaded.apache.http.protocol.HttpContext;
import com.simba.athena.shaded.apache.http.protocol.HttpDateGenerator;
import com.simba.athena.shaded.apache.http.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.SAFE)
public class ResponseDate
implements HttpResponseInterceptor {
    private static final HttpDateGenerator DATE_GENERATOR = new HttpDateGenerator();

    @Override
    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        Args.notNull(response, "HTTP response");
        int status = response.getStatusLine().getStatusCode();
        if (status >= 200 && !response.containsHeader("Date")) {
            String httpdate = DATE_GENERATOR.getCurrentDate();
            response.setHeader("Date", httpdate);
        }
    }
}

