/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.distance;

import dr.evolution.alignment.PatternList;
import dr.evolution.distance.DistanceMatrix;

public class JukesCantorDistanceMatrix
extends DistanceMatrix {
    private double const1;
    private double const2;

    public JukesCantorDistanceMatrix() {
    }

    public JukesCantorDistanceMatrix(PatternList patternList) {
        super(patternList);
    }

    @Override
    public void setPatterns(PatternList patternList) {
        super.setPatterns(patternList);
        int n = patternList.getStateCount();
        this.const1 = ((double)n - 1.0) / (double)n;
        this.const2 = (double)n / (double)(n - 1);
    }

    @Override
    protected double calculatePairwiseDistance(int n, int n2) {
        double d = super.calculatePairwiseDistance(n, n2);
        if (d == 0.0) {
            return 0.0;
        }
        if (d >= this.const1) {
            return 1000.0;
        }
        double d2 = -this.const1 * Math.log(1.0 - this.const2 * d);
        if (d2 < 1000.0) {
            return d2;
        }
        return 1000.0;
    }
}

