/*
 * Decompiled with CFR 0.152.
 */
package org.mutoss.gui.dialogs;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mutoss.config.Configuration;

public class ConfirmArchivePath
extends JDialog
implements ActionListener {
    JButton save = new JButton("Ok");
    JButton dontsave = new JButton("Do not save designs");
    JTextField path = new JTextField(40);
    JButton selectPath = new JButton("Select Path");
    private static final Log logger = LogFactory.getLog(ConfirmArchivePath.class);

    public ConfirmArchivePath(JFrame p) {
        super(p, "Confirm directory to save designs", true);
        this.setUp();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.save) {
            File f = new File(this.path.getText());
            if (!f.exists()) {
                int answer = JOptionPane.showConfirmDialog(this, this.path.getText() + " does not exist. Should it be created?", "Create directory?", 0);
                if (answer == 1) {
                    return;
                }
                f.mkdirs();
            }
            if (!f.isDirectory()) {
                JOptionPane.showMessageDialog(this, this.path.getText() + " is not a directory.", "No valid directory", 0);
                return;
            }
            Configuration.getInstance().getGeneralConfig().setSaveDir(f.getAbsolutePath());
            this.dispose();
        } else if (e.getSource() == this.dontsave) {
            this.dispose();
        } else if (e.getSource() == this.selectPath) {
            File p = new File(this.path.getText());
            JFileChooser fc = p.exists() && p.isDirectory() ? new JFileChooser(p) : new JFileChooser();
            fc.setFileSelectionMode(1);
            int returnVal = fc.showOpenDialog(this);
            if (returnVal == 0) {
                File f = fc.getSelectedFile();
                this.path.setText(f.getAbsolutePath());
            }
            return;
        }
    }

    private void setUp() {
        String cols = "5dlu, fill:pref:grow, 5dlu, pref, 5dlu, pref, 5dlu";
        String rows = "5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu";
        FormLayout layout = new FormLayout(cols, rows);
        this.getContentPane().setLayout((LayoutManager)layout);
        CellConstraints cc = new CellConstraints();
        this.save.addActionListener(this);
        this.getContentPane().add((Component)this.path, cc.xyw(2, 2, 3));
        this.path.setText(System.getProperty("user.home"));
        this.selectPath.addActionListener(this);
        this.getContentPane().add((Component)this.selectPath, cc.xy(6, 2));
        this.dontsave.addActionListener(this);
        this.getContentPane().add((Component)this.dontsave, cc.xy(4, 6));
        this.save.addActionListener(this);
        this.getContentPane().add((Component)this.save, cc.xy(6, 6));
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }
}

