/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.template.type.codec;

import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.openfast.DateValue;
import org.openfast.IntegerValue;
import org.openfast.ScalarValue;
import org.openfast.template.type.codec.TypeCodec;
import org.openfast.util.Util;

public class MillisecondsSinceMidnight
extends TypeCodec {
    private static final long serialVersionUID = 1L;

    public ScalarValue decode(InputStream in) {
        int millisecondsSinceMidnight = TypeCodec.INTEGER.decode(in).toInt();
        Calendar cal = Calendar.getInstance();
        cal.setTimeZone(TimeZone.getTimeZone("GMT"));
        int hour = millisecondsSinceMidnight / 3600000;
        cal.set(11, hour);
        int minute = (millisecondsSinceMidnight -= hour * 3600000) / 60000;
        cal.set(12, minute);
        int second = (millisecondsSinceMidnight -= minute * 60000) / 1000;
        cal.set(13, second);
        int millisecond = millisecondsSinceMidnight -= second * 1000;
        cal.set(14, millisecond);
        return new DateValue(cal.getTime());
    }

    public byte[] encodeValue(ScalarValue value) {
        Date date = ((DateValue)value).value;
        int millisecondsSinceMidnight = Util.millisecondsSinceMidnight(date);
        return TypeCodec.INTEGER.encodeValue(new IntegerValue(millisecondsSinceMidnight));
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == this.getClass();
    }
}

