/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.j48;

import weka.classifiers.trees.j48.Distribution;
import weka.classifiers.trees.j48.EntropyBasedSplitCrit;
import weka.core.Utils;

public final class GainRatioSplitCrit
extends EntropyBasedSplitCrit {
    public final double splitCritValue(Distribution distribution) {
        double d = this.oldEnt(distribution) - this.newEnt(distribution);
        if (Utils.eq(d, 0.0)) {
            return Double.MAX_VALUE;
        }
        double d2 = this.splitEnt(distribution);
        if (Utils.eq(d2, 0.0)) {
            return Double.MAX_VALUE;
        }
        return d2 / d;
    }

    public final double splitCritValue(Distribution distribution, double d, double d2) {
        double d3 = this.splitEnt(distribution, d);
        if (Utils.eq(d3, 0.0)) {
            return 0.0;
        }
        return d2 / (d3 /= d);
    }

    private final double splitEnt(Distribution distribution, double d) {
        double d2 = 0.0;
        double d3 = d - distribution.total();
        if (Utils.gr(distribution.total(), 0.0)) {
            for (int i = 0; i < distribution.numBags(); ++i) {
                d2 -= this.logFunc(distribution.perBag(i));
            }
            d2 -= this.logFunc(d3);
            d2 += this.logFunc(d);
        }
        return d2;
    }
}

