/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Instance_Generation.Basic;

import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import keel.Algorithms.Instance_Generation.Basic.Prototype;
import keel.Algorithms.Instance_Generation.Basic.PrototypeGenerator;
import keel.Algorithms.Instance_Generation.Basic.PrototypeSet;
import keel.Algorithms.Instance_Generation.utilities.KeelFile;
import keel.Algorithms.Instance_Generation.utilities.Parameters;
import keel.Dataset.Attribute;
import keel.Dataset.Attributes;
import keel.Dataset.InstanceAttributes;
import keel.Dataset.InstanceSet;
import org.core.Files;

public abstract class PrototypeGenerationAlgorithm<T extends PrototypeGenerator> {
    protected static String trainingFileName;
    protected static String testFileName;
    protected static ArrayList<String> parameters;
    protected static ArrayList<String> parametersName;
    protected static ArrayList<String> inputFilesPath;
    protected static ArrayList<String> outputFilesPath;
    protected static ArrayList<String> inputFiles;
    protected static ArrayList<String> outputFiles;
    protected static final int TRAINING = 0;
    protected static final int VALIDATION = 1;
    protected static final int TEST = 2;

    private static ArrayList<String> getFileNames(String line) {
        StringTokenizer inputLines = new StringTokenizer(line, "=");
        inputLines.nextToken();
        String files = inputLines.nextToken();
        StringTokenizer fileLine = new StringTokenizer(files, " ");
        ArrayList<String> sfiles = new ArrayList<String>();
        while (fileLine.hasMoreElements()) {
            sfiles.add(fileLine.nextToken().replace("\"", ""));
        }
        return sfiles;
    }

    public static void readParametersFile(String config) {
        String name;
        int _size;
        String[] splitted;
        inputFiles = new ArrayList();
        outputFiles = new ArrayList();
        String file = KeelFile.read(config);
        StringTokenizer fileLines = new StringTokenizer(file, "\n\r");
        fileLines.nextToken();
        String line = fileLines.nextToken();
        inputFilesPath = PrototypeGenerationAlgorithm.getFileNames(line);
        int i = 0;
        Pattern pat = Pattern.compile("[/\\\\]+");
        for (String s : inputFilesPath) {
            System.out.println("Input " + i + " : " + s);
            ++i;
            splitted = pat.split(s);
            _size = splitted.length;
            name = splitted[_size - 1];
            inputFiles.add(name);
            System.out.println("Input File Name: " + name);
        }
        line = fileLines.nextToken();
        outputFilesPath = PrototypeGenerationAlgorithm.getFileNames(line);
        for (String s : outputFilesPath) {
            splitted = pat.split(s);
            _size = splitted.length;
            name = splitted[_size - 1];
            name = name.substring(0, name.length() - 1);
            outputFiles.add(name);
            System.out.println("Output File Name: " + name);
        }
        parameters = new ArrayList();
        parametersName = new ArrayList();
        while (fileLines.hasMoreElements()) {
            String parameterLine = fileLines.nextToken();
            StringTokenizer paramToken = new StringTokenizer(parameterLine, "=");
            String p1 = paramToken.nextToken();
            parametersName.add(p1);
            String p2 = paramToken.nextToken();
            p2 = p2.replaceAll(" ", "");
            parameters.add(p2);
        }
    }

    public static void printParameters() {
        for (String s : inputFiles) {
            System.out.println(s);
        }
        for (String s : outputFiles) {
            System.out.println(s);
        }
        int _size = parameters.size();
        for (int i = 0; i < _size; ++i) {
            System.out.println(parametersName.get(i) + "=" + parameters.get(i));
        }
    }

    public static PrototypeSet readPrototypeSet(String nameOfFile) {
        Attributes.clearAll();
        InstanceSet training = new InstanceSet();
        try {
            training.readSet(nameOfFile, true);
            training.setAttributesAsNonStatic();
            InstanceAttributes att = training.getAttributeDefinitions();
            Prototype.setAttributesTypes(att);
        }
        catch (Exception e) {
            System.err.println("readPrototypeSet has failed!");
            e.printStackTrace();
        }
        return new PrototypeSet(training);
    }

    protected abstract T buildNewPrototypeGenerator(PrototypeSet var1, Parameters var2);

    public static void assertArguments(String[] args) {
        if (args.length != 1) {
            System.err.println("Error in parameters. One configuration file needed");
        }
    }

    public void execute(String[] args) {
        try {
            long tiempo = System.currentTimeMillis();
            Parameters.assertBasicArgs(args);
            PrototypeGenerationAlgorithm.readParametersFile(args[0]);
            PrototypeGenerationAlgorithm.printParameters();
            PrototypeSet training = PrototypeGenerationAlgorithm.readPrototypeSet(inputFilesPath.get(0));
            PrototypeSet test = PrototypeGenerationAlgorithm.readPrototypeSet(inputFilesPath.get(2));
            T generator = this.buildNewPrototypeGenerator(training, new Parameters(parameters));
            PrototypeSet resultingSet = ((PrototypeGenerator)generator).execute();
            int[][] trainRealClass = new int[training.size()][1];
            int[][] trainPrediction = new int[training.size()][1];
            int nClases = resultingSet.getPosibleValuesOfOutput().size();
            for (int i = 0; i < training.size(); ++i) {
                trainRealClass[i][0] = (int)((Prototype)training.get(i)).getOutput(0);
                trainPrediction[i][0] = PrototypeGenerationAlgorithm.evaluate(((Prototype)training.get(i)).getInputs(), resultingSet.prototypeSetTodouble(), nClases, resultingSet.getClases(), 1);
            }
            Attribute[] entradas = Attributes.getInputAttributes();
            Attribute salida = Attributes.getOutputAttribute(0);
            String relation = Attributes.getRelationName();
            PrototypeGenerationAlgorithm.writeOutput(outputFilesPath.get(0), trainRealClass, trainPrediction, entradas, salida, relation);
            int[][] realClass = new int[test.size()][1];
            int[][] prediction = new int[test.size()][1];
            for (int i = 0; i < realClass.length; ++i) {
                realClass[i][0] = (int)((Prototype)test.get(i)).getOutput(0);
                prediction[i][0] = PrototypeGenerationAlgorithm.evaluate(((Prototype)test.get(i)).getInputs(), resultingSet.prototypeSetTodouble(), nClases, resultingSet.getClases(), 1);
            }
            PrototypeGenerationAlgorithm.writeOutput(outputFilesPath.get(1), realClass, prediction, entradas, salida, relation);
            System.out.println("Time elapse: " + (double)(System.currentTimeMillis() - tiempo) / 1000.0 + "");
        }
        catch (Exception e) {
            System.out.println("ERROR");
            System.getProperty("user.dir");
            e.printStackTrace();
        }
    }

    public static void writeOutput(String filename, int[][] realClass, int[][] prediction, Attribute[] inputs, Attribute output, String relation) {
        int j;
        int i;
        String text = "";
        text = text + "@relation " + relation + "\n";
        for (i = 0; i < inputs.length; ++i) {
            text = text + "@attribute " + inputs[i].getName() + " ";
            if (inputs[i].getType() == 0) {
                text = text + "{";
                for (j = 0; j < inputs[i].getNominalValuesList().size(); ++j) {
                    text = text + (String)inputs[i].getNominalValuesList().elementAt(j);
                    if (j >= inputs[i].getNominalValuesList().size() - 1) continue;
                    text = text + ", ";
                }
                text = text + "}\n";
                continue;
            }
            text = inputs[i].getType() == 1 ? text + "integer" : text + "real";
            text = text + " [" + String.valueOf(inputs[i].getMinAttribute()) + ", " + String.valueOf(inputs[i].getMaxAttribute()) + "]\n";
        }
        text = text + "@attribute " + output.getName() + " ";
        if (output.getType() == 0) {
            text = text + "{";
            for (int j2 = 0; j2 < output.getNominalValuesList().size(); ++j2) {
                text = text + (String)output.getNominalValuesList().elementAt(j2);
                if (j2 >= output.getNominalValuesList().size() - 1) continue;
                text = text + ", ";
            }
            text = text + "}\n";
        } else {
            text = text + "integer [" + String.valueOf(output.getMinAttribute()) + ", " + String.valueOf(output.getMaxAttribute()) + "]\n";
        }
        text = text + "@data\n";
        Files.writeFile(filename, text);
        if (output.getType() == 1) {
            text = "";
            for (i = 0; i < realClass.length; ++i) {
                for (j = 0; j < realClass[0].length; ++j) {
                    text = text + "" + realClass[i][j] + " ";
                }
                for (j = 0; j < realClass[0].length; ++j) {
                    text = text + "" + prediction[i][j] + " ";
                }
                text = text + "\n";
                if (i % 10 != 9) continue;
                Files.addToFile(filename, text);
                text = "";
            }
            if (realClass.length % 10 != 0) {
                Files.addToFile(filename, text);
            }
        } else {
            text = "";
            for (i = 0; i < realClass.length; ++i) {
                for (j = 0; j < realClass[0].length; ++j) {
                    text = text + "" + (String)output.getNominalValuesList().elementAt(realClass[i][j]) + " ";
                }
                for (j = 0; j < realClass[0].length; ++j) {
                    text = prediction[i][j] > -1 ? text + "" + (String)output.getNominalValuesList().elementAt(prediction[i][j]) + " " : text + "Unclassified ";
                }
                text = text + "\n";
                if (i % 10 != 9) continue;
                Files.addToFile(filename, text);
                text = "";
            }
            if (realClass.length % 10 != 0) {
                Files.addToFile(filename, text);
            }
        }
    }

    protected static double distance(double[] instance1, double[] instance2) {
        double length = 0.0;
        for (int i = 0; i < instance1.length; ++i) {
            length += (instance1[i] - instance2[i]) * (instance1[i] - instance2[i]);
        }
        length = Math.sqrt(length);
        return length;
    }

    public static int evaluate(double[] example, double[][] trainData, int nClasses, int[] trainOutput, int k) {
        int i;
        int[] nearestN = new int[k];
        double[] minDist = new double[k];
        for (i = 0; i < k; ++i) {
            nearestN[i] = 0;
            minDist[i] = Double.MAX_VALUE;
        }
        for (i = 0; i < trainData.length; ++i) {
            double dist = PrototypeGenerationAlgorithm.distance(trainData[i], example);
            if (!(dist > 0.0)) continue;
            boolean stop = false;
            for (int j = 0; j < k && !stop; ++j) {
                if (!(dist < minDist[j])) continue;
                for (int l = k - 1; l >= j + 1; --l) {
                    minDist[l] = minDist[l - 1];
                    nearestN[l] = nearestN[l - 1];
                }
                minDist[j] = dist;
                nearestN[j] = i;
                stop = true;
            }
        }
        int[] selectedClasses = new int[nClasses];
        for (i = 0; i < nClasses; ++i) {
            selectedClasses[i] = 0;
        }
        for (i = 0; i < k; ++i) {
            int n = trainOutput[nearestN[i]];
            selectedClasses[n] = selectedClasses[n] + 1;
        }
        int prediction = 0;
        int predictionValue = selectedClasses[0];
        for (i = 1; i < nClasses; ++i) {
            if (predictionValue >= selectedClasses[i]) continue;
            predictionValue = selectedClasses[i];
            prediction = i;
        }
        return prediction;
    }
}

