/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Instance_Generation.LVQ;

import java.util.ArrayList;
import java.util.HashSet;
import keel.Algorithms.Instance_Generation.Basic.Prototype;
import keel.Algorithms.Instance_Generation.Basic.PrototypeGenerationAlgorithm;
import keel.Algorithms.Instance_Generation.Basic.PrototypeSet;
import keel.Algorithms.Instance_Generation.LVQ.LVQGenerator;
import keel.Algorithms.Instance_Generation.utilities.KNN.KNN;
import keel.Algorithms.Instance_Generation.utilities.Parameters;
import keel.Algorithms.Instance_Generation.utilities.RandomGenerator;

public class LVQ1
extends LVQGenerator {
    protected static double ALPHA_DEFAULT_VALUE = 0.01;
    protected double alpha_0 = ALPHA_DEFAULT_VALUE;
    protected static final int IALPHA = 3;
    protected int chosenRandomIndex = 0;
    protected ArrayList<Integer> randomIndexes = null;

    public LVQ1(PrototypeSet traDataSet, int it, int numProt, double alpha_0) {
        super(traDataSet, it, numProt);
        this.algorithmName = "LVQ1";
        this.alpha_0 = alpha_0;
        this.chosenRandomIndex = 0;
        int data_size = traDataSet.size();
        this.randomIndexes = RandomGenerator.generateDifferentRandomIntegers(0, data_size - 1);
    }

    public LVQ1(PrototypeSet InitialSet, PrototypeSet traDataSet, int it, int numProt, double alpha_0) {
        super(InitialSet, traDataSet, it, numProt);
        this.algorithmName = "LVQ1";
        this.alpha_0 = alpha_0;
        this.chosenRandomIndex = 0;
        int data_size = traDataSet.size();
        this.randomIndexes = RandomGenerator.generateDifferentRandomIntegers(0, data_size - 1);
    }

    public LVQ1(PrototypeSet traDataSet, int it, double percNumProt, double alpha_0) {
        super(traDataSet, it, percNumProt);
        this.algorithmName = "LVQ1";
        this.alpha_0 = alpha_0;
        this.chosenRandomIndex = 0;
        int data_size = traDataSet.size();
        this.randomIndexes = RandomGenerator.generateDifferentRandomIntegers(0, data_size - 1);
    }

    public LVQ1(PrototypeSet traDataSet, Parameters parameters) {
        super(traDataSet, parameters);
        this.algorithmName = "LVQ1";
        this.alpha_0 = parameters.getNextAsDouble();
        this.chosenRandomIndex = 0;
        int data_size = traDataSet.size();
        this.randomIndexes = RandomGenerator.generateDifferentRandomIntegers(0, data_size - 1);
    }

    @Override
    protected void reward(Prototype m, Prototype x) {
        m.set(m.add(x.sub(m).mul(this.alpha_0)));
    }

    @Override
    protected void penalize(Prototype m, Prototype x) {
        m.set(m.sub(x.sub(m).mul(this.alpha_0)));
    }

    @Override
    protected PrototypeSet initDataSet() {
        if (!this.initialset) {
            int i;
            int numberOfClass = this.trainingDataSet.getPosibleValuesOfOutput().size();
            PrototypeSet initial = this.selecRandomSet(this.numberOfPrototypesGenerated, true);
            PrototypeSet[] clases = new PrototypeSet[numberOfClass];
            for (i = 0; i < numberOfClass; ++i) {
                clases[i] = new PrototypeSet(this.trainingDataSet.getFromClass(i));
            }
            for (i = 0; i < initial.size(); ++i) {
                for (int j = 0; j < numberOfClass; ++j) {
                    if (initial.getFromClass(j).size() != 0 || clases[j].size() == 0) continue;
                    initial.add(clases[j].getRandom());
                }
            }
            return initial;
        }
        PrototypeSet Initial = this.initial;
        return Initial;
    }

    protected PrototypeSet initDataSetRandomMode() {
        int numberOfInstances_1 = this.trainingDataSet.size() - 1;
        PrototypeSet edited = new PrototypeSet(this.numberOfPrototypesGenerated);
        HashSet<Integer> forbidden = new HashSet<Integer>();
        for (int number = 0; number < this.numberOfPrototypesGenerated; ++number) {
            int chosenLocal;
            while (forbidden.contains(chosenLocal = RandomGenerator.Randint(0, numberOfInstances_1))) {
            }
            forbidden.add(chosenLocal);
            edited.add(this.trainingDataSet.get(chosenLocal));
        }
        return edited;
    }

    @Override
    protected Prototype extract(PrototypeSet tData) {
        int dataIndex = this.randomIndexes.get(this.chosenRandomIndex);
        Prototype res = (Prototype)tData.get(dataIndex);
        this.chosenRandomIndex = (this.chosenRandomIndex + 1) % this.randomIndexes.size();
        return res;
    }

    @Override
    protected void correct(Prototype i, PrototypeSet tData) {
        double class_nearest;
        Prototype nearest = KNN._1nn(i, tData);
        double class_i = i.label();
        if (class_i != (class_nearest = nearest.label())) {
            this.penalize(nearest, i);
        } else {
            this.reward(nearest, i);
        }
    }

    public static void main(String[] args) {
        Parameters.setUse("LVQ1", "<seed> <number of iterations> <% of prototypes> <alpha_0>");
        Parameters.assertBasicArgs(args);
        PrototypeSet training = PrototypeGenerationAlgorithm.readPrototypeSet(args[0]);
        PrototypeSet test = PrototypeGenerationAlgorithm.readPrototypeSet(args[1]);
        long seed = Parameters.assertExtendedArgAsInt(args, 2, "seed", 0.0, 9.223372036854776E18);
        int iter = Parameters.assertExtendedArgAsInt(args, 3, "number of iterations", 1.0, 2.147483647E9);
        double percNprot = Parameters.assertExtendedArgAsDouble(args, 4, "reduction size respect training size", 0.0, 100.0);
        double alpha_0 = Parameters.assertExtendedArgAsDouble(args, 5, "alpha_0", 0.0, 4.0);
        LVQ1.setSeed(seed);
        LVQ1 generator = new LVQ1(training, iter, percNprot, alpha_0);
        PrototypeSet resultingSet = generator.execute();
        int accuracy1NN = KNN.classficationAccuracy(resultingSet, test);
        generator.showResultsOfAccuracy(Parameters.getFileName(), accuracy1NN, test);
    }
}

