/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Fuzzy_Rule_Learning.Shared.Fuzzy;

import keel.Algorithms.Fuzzy_Rule_Learning.Shared.Fuzzy.FuzzyPartition;
import keel.Algorithms.Fuzzy_Rule_Learning.Shared.Fuzzy.FuzzyRule;

public class RuleBase {
    int tnr;
    int agr;
    FuzzyRule[] content;
    FuzzyPartition[] partitions;
    FuzzyPartition partition;
    static final int minimum = 0;
    public static final int product = 1;
    static final int maximum = 0;
    public static final int sum = 1;
    public static final int DEFUZCDM = 0;
    public static final int DEFUZMAX = 1;
    long[] rules;

    public RuleBase(FuzzyPartition[] pe, FuzzyPartition ps, int tn, int ag) {
        this.partitions = new FuzzyPartition[pe.length];
        for (int i = 0; i < pe.length; ++i) {
            this.partitions[i] = pe[i].clone();
        }
        this.partition = ps.clone();
        this.tnr = tn;
        this.agr = ag;
        int n = 1;
        this.content = new FuzzyRule[n];
        for (int i = 0; i < n; ++i) {
            this.content[i] = new FuzzyRule();
        }
    }

    public RuleBase(RuleBase b) {
        int i;
        this.partitions = new FuzzyPartition[b.partitions.length];
        for (i = 0; i < this.partitions.length; ++i) {
            this.partitions[i] = b.partitions[i].clone();
        }
        this.partition = b.partition.clone();
        this.tnr = b.tnr;
        this.agr = b.agr;
        this.content = new FuzzyRule[b.content.length];
        for (i = 0; i < b.content.length; ++i) {
            this.content[i] = b.content[i].clone();
        }
    }

    public void set(RuleBase b) {
        int i;
        this.partitions = new FuzzyPartition[b.partitions.length];
        for (i = 0; i < this.partitions.length; ++i) {
            this.partitions[i] = b.partitions[i].clone();
        }
        this.partition = b.partition.clone();
        this.tnr = b.tnr;
        this.agr = b.agr;
        this.content = new FuzzyRule[b.content.length];
        for (i = 0; i < b.content.length; ++i) {
            this.content[i] = b.content[i].clone();
        }
    }

    public RuleBase clone() {
        return new RuleBase(this);
    }

    public void debug() {
        this.print();
    }

    public int size() {
        return this.content.length;
    }

    public FuzzyRule getComponent(int n) {
        return this.content[n];
    }

    public void setComponent(int n, FuzzyRule b) {
        this.content[n] = b.clone();
    }

    int[] decodifyRule(long r) {
        int[] result = new int[this.partitions.length];
        for (int i = result.length - 1; i >= 0; --i) {
            result[i] = (int)(r % (long)this.partitions[i].size());
            r /= (long)this.partitions[i].size();
        }
        return result;
    }

    public String variableNames(long r) {
        int[] d = this.decodifyRule(r);
        String result = "[";
        for (int i = 0; i < d.length; ++i) {
            result = result + "V" + i + "-" + d[i];
            if (i == d.length - 1) continue;
            result = result + ",";
        }
        return result + "]";
    }

    public double tnorm(double x, double y) {
        if (this.tnr == 0) {
            if (x < y) {
                return x;
            }
            return y;
        }
        return x * y;
    }

    double add(double x, double y) {
        if (this.agr == 0) {
            if (x > y) {
                return x;
            }
            return y;
        }
        return x + y;
    }

    public double evaluateMembership(long r, double[] x) {
        int[] d = this.decodifyRule(r);
        double pertenencia = 1.0;
        for (int j = 0; j < x.length; ++j) {
            pertenencia = this.tnorm(pertenencia, this.partitions[j].getComponent(d[j]).evaluateMembership(x[j]));
        }
        return pertenencia;
    }

    public double[] output(double[] x) {
        double[] result = new double[this.partition.size()];
        for (int i = 0; i < this.content.length; ++i) {
            if (this.content[i].weight == 0.0) continue;
            double p = this.tnorm(this.evaluateMembership(i, x), this.content[i].weight);
            result[this.content[i].consequent] = this.add(result[this.content[i].consequent], p);
        }
        return result;
    }

    public void addRules(long[] rules, FuzzyRule[] rules2) {
        this.rules = new long[rules.length];
        this.content = new FuzzyRule[rules.length];
        for (int i = 0; i < rules.length; ++i) {
            this.rules[i] = rules[i];
            this.content[i] = new FuzzyRule(rules2[i]);
        }
    }

    public double[] myOutput(double[] x) {
        double[] result = new double[this.partition.size()];
        for (int i = 0; i < this.rules.length; ++i) {
            double p = this.tnorm(this.evaluateMembership(this.rules[i], x), this.content[i].weight);
            result[this.content[i].consequent] = this.add(result[this.content[i].consequent], p);
        }
        return result;
    }

    public int numConsequents() {
        return this.partition.size();
    }

    void print() {
        System.out.println("Debug RuleBase " + this.size());
        for (int r = 0; r < this.size(); ++r) {
            if (!(this.content[r].weight >= 0.0)) continue;
            System.out.println("IF " + this.variableNames(r) + " THEN " + "S" + this.content[r].consequent + " with weight " + this.content[r].weight);
        }
        System.out.println("------------");
    }

    public double defuzzify(double[] output, int IDDEFUZZIFY) {
        if (IDDEFUZZIFY == 0) {
            double centerSum = 0.0;
            double weightSum = 0.0;
            for (int i = 0; i < this.partition.size(); ++i) {
                centerSum += this.partition.getComponent(i).massCentre() * output[i];
                weightSum += output[i];
            }
            if (weightSum == 0.0) {
                return 0.0;
            }
            return centerSum / weightSum;
        }
        if (IDDEFUZZIFY == 1) {
            double val = 0.0;
            double mumax = 0.0;
            for (int i = 0; i < this.partition.size(); ++i) {
                if (!(output[i] > mumax)) continue;
                mumax = output[i];
                val = this.partition.getComponent(i).massCentre();
            }
            if (mumax == 0.0) {
                return 0.0;
            }
            return val;
        }
        return 0.0;
    }

    public long codifyAntecents(double[] example) {
        int[] antecedent = new int[example.length];
        for (int i = 0; i < example.length; ++i) {
            int j;
            double max = 0.0;
            int etq = 0;
            for (j = 0; j < this.partitions[i].size(); ++j) {
                double per = this.partitions[i].getComponent(j).evaluateMembership(example[i]);
                if (!(per > max)) continue;
                max = per;
                etq = j;
            }
            if (max == 0.0) {
                System.err.println("Error searching antecedent");
                System.err.println("\nExample:");
                for (j = 0; j < example.length; ++j) {
                    System.err.println("" + example[j] + "\t");
                }
                System.err.println("Variable -> " + i);
                System.exit(1);
            }
            antecedent[i] = etq;
        }
        long rule = 0L;
        long j = 1L;
        for (int i = antecedent.length - 1; i >= 0; --i) {
            rule += (long)antecedent[i] * j;
            j *= (long)this.partitions[i].size();
        }
        return rule;
    }
}

