/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.intarray.rec;

import net.sourceforge.jclec.IConfigure;
import net.sourceforge.jclec.intarray.IntArrayIndividual;
import net.sourceforge.jclec.intarray.IntArrayRecombinator;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.builder.EqualsBuilder;

public class UniformCrossover
extends IntArrayRecombinator
implements IConfigure {
    private static final long serialVersionUID = 3258697598016829492L;
    private double locusCrossoverProb;

    public final double getLocusCrossoverProb() {
        return this.locusCrossoverProb;
    }

    public final void setLocusCrossoverProb(double crossProb) {
        this.locusCrossoverProb = crossProb;
    }

    @Override
    public void configure(Configuration configuration) {
        double locusCrossoverProb = configuration.getDouble("[@locus-crossover-prob]", 0.5);
        this.setLocusCrossoverProb(locusCrossoverProb);
    }

    public boolean equals(Object other) {
        if (other instanceof UniformCrossover) {
            UniformCrossover cother = (UniformCrossover)other;
            EqualsBuilder eb = new EqualsBuilder();
            eb.append(this.locusCrossoverProb, cother.locusCrossoverProb);
            return eb.isEquals();
        }
        return false;
    }

    @Override
    protected void recombineNext() {
        int gl = this.species.getGenotypeLength();
        int[] p0_genome = (int[])((IntArrayIndividual)this.parentsBuffer.get(this.parentsCounter)).getGenotype();
        int[] p1_genome = (int[])((IntArrayIndividual)this.parentsBuffer.get(this.parentsCounter + 1)).getGenotype();
        int[] s0_genome = new int[gl];
        int[] s1_genome = new int[gl];
        int i = 0;
        while (i < gl) {
            if (this.randgen.coin(this.locusCrossoverProb)) {
                s0_genome[i] = p1_genome[i];
                s1_genome[i] = p0_genome[i];
            } else {
                s0_genome[i] = p0_genome[i];
                s1_genome[i] = p1_genome[i];
            }
            ++i;
        }
        this.sonsBuffer.add(this.species.createIndividual(s0_genome));
        this.sonsBuffer.add(this.species.createIndividual(s1_genome));
    }
}

