/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Shared.ClassicalOptim;

import keel.Algorithms.Shared.ClassicalOptim.ConjGradNN;
import keel.Algorithms.Shared.ClassicalOptim.OPV;
import keel.Algorithms.Shared.ClassicalOptim.SquaresErrorNN;
import org.core.Randomize;

public class GCNet {
    static final int MAX_ITER = 10000;
    static final double TOL_ERR = 1.0E-8;
    static final double MIN_DELTAGC = 1.0E-5;
    ConjGradNN Net;

    public double nntrain(int nInputs, int nOutputs, double[][] examples, double[][] outputs, int[] topology, double[] weights, Randomize r) {
        int nelem = examples.length;
        System.out.println("Numero entradas=" + nInputs);
        System.out.println("Numero salidas=" + nOutputs);
        System.out.println("Dimension topologia=" + topology.length);
        System.out.println("Dimension pesos=" + weights.length);
        System.out.println("Numero ejemplos=" + nelem);
        this.Net = new ConjGradNN(topology, examples, outputs, r);
        SquaresErrorNN Err = new SquaresErrorNN(this.Net);
        this.Net.randomWeights(1.0);
        double errf = this.Net.conjugatedGradient(Err, 1.0E-8, 1.0E-5, 10000);
        this.Net.getWeights(weights);
        System.out.println("RMS train=" + errf);
        return errf;
    }

    public double nntrainGD(int nInputs, int nOutputs, double[][] examples, double[][] outputs, int[] topology, double[] weights, Randomize r) {
        int nElements = examples.length;
        System.out.println("Numero entradas=" + nInputs);
        System.out.println("Numero salidas=" + nOutputs);
        System.out.println("Dimension topologia=" + topology.length);
        System.out.println("Dimension pesos=" + weights.length);
        System.out.println("Numero ejemplos=" + nElements);
        this.Net = new ConjGradNN(topology, examples, outputs, r);
        SquaresErrorNN Err = new SquaresErrorNN(this.Net);
        this.Net.randomWeights(1.0);
        double errf = this.Net.descentGradient(Err, 1.0E-8, 1.0E-5, 10000);
        this.Net.getWeights(weights);
        System.out.println("RMS train=" + errf);
        return errf;
    }

    public double[] nnoutput(double[] x) {
        double[] output = this.Net.nn(OPV.scale(x, this.Net.max_x, this.Net.min_x), this.Net.weights);
        return OPV.invScale(output, this.Net.max_y, this.Net.min_y);
    }

    public String printNet() {
        return this.Net.getWeightsAsString();
    }
}

