/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Instance_Generation.utilities;

public class ApproximateSqrt {
    public static float fsqrt(float x) {
        if (x == 0.0f) {
            return 0.0f;
        }
        float root = x / 2.0f;
        for (int k = 0; k < 10; ++k) {
            root = (root + x / root) / 2.0f;
        }
        return root;
    }

    public static float ffsqrt(float n) {
        if (n == 0.0f) {
            return 0.0f;
        }
        if (n == 1.0f) {
            return 1.0f;
        }
        float guess = n / 2.0f;
        float oldguess = 0.0f;
        while (guess != oldguess) {
            oldguess = guess;
            guess = (guess + n / guess) / 2.0f;
        }
        return guess;
    }

    public static float fastSqrt(float val) {
        int tmp = Float.floatToIntBits(val);
        tmp -= 0x800000;
        tmp >>= 1;
        return Float.intBitsToFloat(tmp += 0x20000000);
    }
}

