/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jclec.algorithm.memetic;

import java.util.ArrayList;
import java.util.List;
import net.sf.jclec.IEvaluator;
import net.sf.jclec.IIndividual;
import net.sf.jclec.IPopulation;
import net.sf.jclec.ISystem;
import net.sf.jclec.algorithm.memetic.IOptimizer;
import net.sf.jclec.util.random.IRandGen;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOptimizer<I extends IIndividual>
implements IOptimizer<I> {
    protected IPopulation<I> context;
    protected transient IRandGen randgen;
    protected transient IEvaluator<I> evaluator;

    @Override
    public void contextualize(ISystem<I> context) {
        if (!(context instanceof IPopulation)) {
            throw new IllegalArgumentException("This object uses a population as execution context");
        }
        this.context = (IPopulation)context;
        this.randgen = context.createRandGen();
        this.evaluator = ((IPopulation)context).getEvaluator();
    }

    @Override
    public List<I> optimize(List<I> inds) {
        ArrayList<IIndividual> optimized = new ArrayList<IIndividual>();
        for (IIndividual ind : inds) {
            optimized.add(this.optimize(ind));
        }
        return optimized;
    }

    @Override
    public abstract I optimize(I var1);
}

