/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jclec.base;

import java.util.ArrayList;
import java.util.List;
import net.sf.jclec.IIndividual;
import net.sf.jclec.IPopulation;
import net.sf.jclec.IRecombinator;
import net.sf.jclec.ISystem;
import net.sf.jclec.util.random.IRandGen;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRecombinator<I extends IIndividual>
implements IRecombinator<I> {
    protected IPopulation<I> context;
    protected IRandGen randgen;
    protected transient int ppl;
    protected transient int spl;
    protected transient List<I> parentsBuffer;
    protected transient List<I> sonsBuffer;
    protected transient int parentsCounter;

    public AbstractRecombinator() {
        this.setPpl();
        this.setSpl();
    }

    @Override
    public void contextualize(ISystem<I> context) {
        if (!(context instanceof IPopulation)) {
            throw new IllegalArgumentException("This object uses a population as execution context");
        }
        this.context = (IPopulation)context;
        if (this.randgen == null) {
            this.randgen = context.createRandGen();
        }
    }

    @Override
    public final int getPpl() {
        return this.ppl;
    }

    @Override
    public final int getSpl() {
        return this.spl;
    }

    @Override
    public List<I> recombine(List<I> parents) {
        this.parentsBuffer = parents;
        this.prepareRecombination();
        this.sonsBuffer = new ArrayList<I>();
        this.parentsCounter = 0;
        while (this.parentsCounter <= parents.size() - this.ppl) {
            this.recombineNext();
            this.parentsCounter += this.ppl;
        }
        return this.sonsBuffer;
    }

    protected abstract void setPpl();

    protected abstract void setSpl();

    protected abstract void prepareRecombination();

    protected abstract void recombineNext();
}

