/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Neural_Networks.NNEP_Common.mutators.parametric;

import keel.Algorithms.Neural_Networks.NNEP_Common.mutators.parametric.INeuronParametricMutator;
import keel.Algorithms.Neural_Networks.NNEP_Common.neuralnet.Link;
import keel.Algorithms.Neural_Networks.NNEP_Common.neuralnet.LinkedLayer;
import keel.Algorithms.Neural_Networks.NNEP_Common.neuralnet.LinkedNeuron;
import keel.Algorithms.Neural_Networks.NNEP_Common.neuralnet.SigmNeuron;
import net.sf.jclec.util.random.IRandGen;
import net.sf.jclec.util.range.Interval;

public class SigmNeuronParametricMutator
implements INeuronParametricMutator<SigmNeuron> {
    protected IRandGen randgen;
    protected double amplitude;

    public double getAmplitude() {
        return this.amplitude;
    }

    public void setAmplitude(double amplitude) {
        this.amplitude = amplitude;
    }

    public IRandGen getRandgen() {
        return this.randgen;
    }

    public void setRandgen(IRandGen randgen) {
        this.randgen = randgen;
    }

    @Override
    public void parametricMutation(SigmNeuron neuron, LinkedLayer layer, LinkedLayer nextLayer, int indexNeuron, double alphaInput, double alphaOutput, double temper) {
        int i;
        Link[] links = neuron.getLinks();
        for (i = 0; i < links.length; ++i) {
            if (links[i].isBroken()) continue;
            double weigthIncrement = this.randgen.gaussian(alphaInput * temper);
            links[i].setWeight(links[i].getWeight() + weigthIncrement);
            if (neuron.getWeightRange().contains(links[i].getWeight())) continue;
            Interval interval = neuron.getWeightRange();
            if (links[i].getWeight() > interval.getRight() * this.amplitude) {
                links[i].setWeight(interval.getRight() * this.amplitude);
            }
            if (!(links[i].getWeight() < interval.getLeft() * this.amplitude)) continue;
            links[i].setWeight(interval.getLeft() * this.amplitude);
        }
        for (i = 0; i < nextLayer.getNofneurons(); ++i) {
            LinkedNeuron linkedNeuron = nextLayer.getNeuron(i);
            links = linkedNeuron.getLinks();
            double weigthIncrement = this.randgen.gaussian(alphaOutput * temper);
            links[indexNeuron].setWeight(links[indexNeuron].getWeight() + weigthIncrement);
            if (linkedNeuron.getWeightRange().contains(links[indexNeuron].getWeight())) continue;
            Interval interval = linkedNeuron.getWeightRange();
            if (links[indexNeuron].getWeight() > interval.getRight() * this.amplitude) {
                links[indexNeuron].setWeight(interval.getRight() * this.amplitude);
            }
            if (!(links[indexNeuron].getWeight() < interval.getLeft() * this.amplitude)) continue;
            links[indexNeuron].setWeight(interval.getLeft() * this.amplitude);
        }
    }
}

