/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.ImbalancedClassification.Ensembles.SMOTE;

import java.util.StringTokenizer;
import keel.Algorithms.ImbalancedClassification.Ensembles.Basic.KNN;
import keel.Algorithms.ImbalancedClassification.Ensembles.Basic.Metodo;
import keel.Algorithms.ImbalancedClassification.Ensembles.Basic.OutputIS;
import keel.Algorithms.ImbalancedClassification.Ensembles.multi_C45;
import keel.Dataset.Attributes;
import keel.Dataset.InstanceSet;
import org.core.Fichero;
import org.core.Randomize;

public class SMOTE
extends Metodo {
    private long semilla;
    private int kSMOTE;
    private int ASMO;
    private boolean balance;
    private double smoting;

    public SMOTE(String ficheroScript) {
        super(ficheroScript);
    }

    public SMOTE(InstanceSet IS, long seed, int k, int ASMO, boolean bal, double smoting, String distance) {
        this.semilla = seed;
        this.training = IS;
        this.test = IS;
        this.kSMOTE = k;
        this.balance = bal;
        this.smoting = smoting;
        this.ASMO = ASMO;
        this.distanceEu = distance.equalsIgnoreCase("Euclidean");
        this.ficheroSalida = new String[2];
        this.ficheroSalida[0] = multi_C45.outputTr.substring(0, multi_C45.outputTr.length() - 4) + "train.tra";
        this.ficheroSalida[1] = multi_C45.outputTr.substring(0, multi_C45.outputTr.length() - 4) + "train.tst";
        try {
            this.normalizar();
        }
        catch (Exception e) {
            System.err.println(e);
            System.exit(1);
        }
        if (!this.distanceEu) {
            stdDev = new double[Attributes.getInputNumAttributes()];
            nominalDistance = new double[Attributes.getInputNumAttributes()][][];
            int nClases = Attributes.getOutputAttribute(0).getNumNominalValues();
            for (int i = 0; i < nominalDistance.length; ++i) {
                int j;
                if (Attributes.getInputAttribute(i).getType() == 0) {
                    SMOTE.nominalDistance[i] = new double[Attributes.getInputAttribute(i).getNumNominalValues()][Attributes.getInputAttribute(i).getNumNominalValues()];
                    for (j = 0; j < Attributes.getInputAttribute(i).getNumNominalValues(); ++j) {
                        SMOTE.nominalDistance[i][j][j] = 0.0;
                    }
                    for (j = 0; j < Attributes.getInputAttribute(i).getNumNominalValues(); ++j) {
                        for (int l = j + 1; l < Attributes.getInputAttribute(i).getNumNominalValues(); ++l) {
                            int m;
                            double VDM = 0.0;
                            int Nay = 0;
                            int Nax = 0;
                            for (m = 0; m < this.training.getNumInstances(); ++m) {
                                if (this.nominalTrain[m][i] == j) {
                                    ++Nax;
                                }
                                if (this.nominalTrain[m][i] != l) continue;
                                ++Nay;
                            }
                            for (m = 0; m < nClases; ++m) {
                                int Nayc = 0;
                                int Naxc = 0;
                                for (int n = 0; n < this.training.getNumInstances(); ++n) {
                                    if (this.nominalTrain[n][i] == j && this.clasesTrain[n] == m) {
                                        ++Naxc;
                                    }
                                    if (this.nominalTrain[n][i] != l || this.clasesTrain[n] != m) continue;
                                    ++Nayc;
                                }
                                VDM += ((double)Naxc / (double)Nax - (double)Nayc / (double)Nay) * ((double)Naxc / (double)Nax - (double)Nayc / (double)Nay);
                            }
                            SMOTE.nominalDistance[i][j][l] = Math.sqrt(VDM);
                            SMOTE.nominalDistance[i][l][j] = Math.sqrt(VDM);
                        }
                    }
                    continue;
                }
                double media = 0.0;
                double SD = 0.0;
                for (j = 0; j < this.training.getNumInstances(); ++j) {
                    media += this.realTrain[j][i];
                    SD += this.realTrain[j][i] * this.realTrain[j][i];
                }
                SMOTE.stdDev[i] = Math.sqrt(Math.abs(SD / (double)this.realTrain.length - (media /= (double)this.realTrain.length) * media));
            }
        }
    }

    public void ejecutar() {
        int l;
        int[] clasesGen;
        boolean[][] genM;
        int[][] genN;
        double[][] genR;
        double[][] genS;
        int negID;
        int posID;
        int tmp;
        int i;
        int nPos = 0;
        int nNeg = 0;
        long tiempo = System.currentTimeMillis();
        for (i = 0; i < this.clasesTrain.length; ++i) {
            if (this.clasesTrain[i] == 0) {
                ++nPos;
                continue;
            }
            ++nNeg;
        }
        if (nPos > nNeg) {
            tmp = nPos;
            nPos = nNeg;
            nNeg = tmp;
            posID = 1;
            negID = 0;
        } else {
            posID = 0;
            negID = 1;
        }
        int[] positives = new int[nPos];
        int j = 0;
        for (i = 0; i < this.clasesTrain.length; ++i) {
            if (this.clasesTrain[i] != posID) continue;
            positives[j] = i;
            ++j;
        }
        for (i = 0; i < positives.length; ++i) {
            tmp = positives[i];
            int pos = Randomize.Randint(0, positives.length - 1);
            positives[i] = positives[pos];
            positives[pos] = tmp;
        }
        int[][] neighbors = new int[positives.length][this.kSMOTE];
        block8: for (i = 0; i < positives.length; ++i) {
            switch (this.ASMO) {
                case 0: {
                    KNN.evaluacionKNN2(this.kSMOTE, this.datosTrain, this.realTrain, this.nominalTrain, this.nulosTrain, this.clasesTrain, this.datosTrain[positives[i]], this.realTrain[positives[i]], this.nominalTrain[positives[i]], this.nulosTrain[positives[i]], 2, this.distanceEu, neighbors[i]);
                    continue block8;
                }
                case 1: {
                    SMOTE.evaluacionKNNClass(this.kSMOTE, this.datosTrain, this.realTrain, this.nominalTrain, this.nulosTrain, this.clasesTrain, this.datosTrain[positives[i]], this.realTrain[positives[i]], this.nominalTrain[positives[i]], this.nulosTrain[positives[i]], 2, this.distanceEu, neighbors[i], posID);
                    continue block8;
                }
                case 2: {
                    SMOTE.evaluacionKNNClass(this.kSMOTE, this.datosTrain, this.realTrain, this.nominalTrain, this.nulosTrain, this.clasesTrain, this.datosTrain[positives[i]], this.realTrain[positives[i]], this.nominalTrain[positives[i]], this.nulosTrain[positives[i]], 2, this.distanceEu, neighbors[i], negID);
                }
            }
        }
        if (this.balance) {
            genS = new double[nNeg - nPos][this.datosTrain[0].length];
            genR = new double[nNeg - nPos][this.datosTrain[0].length];
            genN = new int[nNeg - nPos][this.datosTrain[0].length];
            genM = new boolean[nNeg - nPos][this.datosTrain[0].length];
            clasesGen = new int[nNeg - nPos];
        } else {
            genS = new double[(int)((double)nPos * this.smoting)][this.datosTrain[0].length];
            genR = new double[(int)((double)nPos * this.smoting)][this.datosTrain[0].length];
            genN = new int[(int)((double)nPos * this.smoting)][this.datosTrain[0].length];
            genM = new boolean[(int)((double)nPos * this.smoting)][this.datosTrain[0].length];
            clasesGen = new int[(int)((double)nPos * this.smoting)];
        }
        for (i = 0; i < genS.length; ++i) {
            clasesGen[i] = posID;
            int nn = Randomize.Randint(0, this.kSMOTE - 1);
            this.interpola(this.realTrain[positives[i % positives.length]], this.realTrain[neighbors[i % positives.length][nn]], this.nominalTrain[positives[i % positives.length]], this.nominalTrain[neighbors[i % positives.length][nn]], this.nulosTrain[positives[i % positives.length]], this.nulosTrain[neighbors[i % positives.length][nn]], genS[i], genR[i], genN[i], genM[i]);
        }
        int tamS = this.balance ? 2 * nNeg : nNeg + nPos + (int)((double)nPos * this.smoting);
        double[][] conjS = new double[tamS][this.datosTrain[0].length];
        double[][] conjR = new double[tamS][this.datosTrain[0].length];
        int[][] conjN = new int[tamS][this.datosTrain[0].length];
        boolean[][] conjM = new boolean[tamS][this.datosTrain[0].length];
        int[] clasesS = new int[tamS];
        for (j = 0; j < this.datosTrain.length; ++j) {
            for (l = 0; l < this.datosTrain[0].length; ++l) {
                conjS[j][l] = this.datosTrain[j][l];
                conjR[j][l] = this.realTrain[j][l];
                conjN[j][l] = this.nominalTrain[j][l];
                conjM[j][l] = this.nulosTrain[j][l];
            }
            clasesS[j] = this.clasesTrain[j];
        }
        int m = 0;
        while (j < tamS) {
            for (l = 0; l < this.datosTrain[0].length; ++l) {
                conjS[j][l] = genS[m][l];
                conjR[j][l] = genR[m][l];
                conjN[j][l] = genN[m][l];
                conjM[j][l] = genM[m][l];
            }
            clasesS[j] = clasesGen[m];
            ++j;
            ++m;
        }
        System.out.println("SMOTE " + this.relation + " " + (double)(System.currentTimeMillis() - tiempo) / 1000.0 + "s");
        OutputIS.escribeSalida(this.ficheroSalida[0], conjR, conjN, conjM, clasesS, this.entradas, this.salida, this.nEntradas, this.relation);
    }

    public static int evaluacionKNNClass(int nvec, double[][] conj, double[][] real, int[][] nominal, boolean[][] nulos, int[] clases, double[] ejemplo, double[] ejReal, int[] ejNominal, boolean[] ejNulos, int nClases, boolean distance, int[] vecinos, int clase) {
        int j;
        int i;
        boolean parar = false;
        if (nvec > conj.length) {
            nvec = conj.length;
        }
        int[] votos = new int[nClases];
        int[] vecinosCercanos = new int[nvec];
        double[] minDistancias = new double[nvec];
        for (i = 0; i < nvec; ++i) {
            vecinosCercanos[i] = -1;
            minDistancias[i] = Double.POSITIVE_INFINITY;
        }
        for (i = 0; i < conj.length; ++i) {
            double dist = KNN.distancia(conj[i], real[i], nominal[i], nulos[i], ejemplo, ejReal, ejNominal, ejNulos, distance);
            if (!(dist > 0.0) || clases[i] != clase) continue;
            parar = false;
            for (j = 0; j < nvec && !parar; ++j) {
                if (!(dist < minDistancias[j])) continue;
                parar = true;
                for (int l = nvec - 1; l >= j + 1; --l) {
                    minDistancias[l] = minDistancias[l - 1];
                    vecinosCercanos[l] = vecinosCercanos[l - 1];
                }
                minDistancias[j] = dist;
                vecinosCercanos[j] = i;
            }
        }
        for (j = 0; j < nClases; ++j) {
            votos[j] = 0;
        }
        for (j = 0; j < nvec; ++j) {
            if (vecinosCercanos[j] < 0) continue;
            int n = clases[vecinosCercanos[j]];
            votos[n] = votos[n] + 1;
        }
        int votada = 0;
        int votaciones = votos[0];
        for (j = 1; j < nClases; ++j) {
            if (votaciones >= votos[j]) continue;
            votaciones = votos[j];
            votada = j;
        }
        for (i = 0; i < vecinosCercanos.length; ++i) {
            vecinos[i] = vecinosCercanos[i];
        }
        return votada;
    }

    void interpola(double[] ra, double[] rb, int[] na, int[] nb, boolean[] ma, boolean[] mb, double[] resS, double[] resR, int[] resN, boolean[] resM) {
        for (int i = 0; i < ra.length; ++i) {
            double gap;
            double diff;
            if (ma[i] && mb[i]) {
                resM[i] = true;
                resS[i] = 0.0;
                continue;
            }
            if (ma[i]) {
                if (this.entradas[i].getType() == 2) {
                    resR[i] = rb[i];
                    resS[i] = (resR[i] + this.entradas[i].getMinAttribute()) / (this.entradas[i].getMaxAttribute() - this.entradas[i].getMinAttribute());
                    continue;
                }
                if (this.entradas[i].getType() == 1) {
                    resR[i] = rb[i];
                    resS[i] = (resR[i] + this.entradas[i].getMinAttribute()) / (this.entradas[i].getMaxAttribute() - this.entradas[i].getMinAttribute());
                    continue;
                }
                resN[i] = nb[i];
                resS[i] = (double)resN[i] / (double)(this.entradas[i].getNominalValuesList().size() - 1);
                continue;
            }
            if (mb[i]) {
                if (this.entradas[i].getType() == 2) {
                    resR[i] = ra[i];
                    resS[i] = (resR[i] + this.entradas[i].getMinAttribute()) / (this.entradas[i].getMaxAttribute() - this.entradas[i].getMinAttribute());
                    continue;
                }
                if (this.entradas[i].getType() == 1) {
                    resR[i] = ra[i];
                    resS[i] = (resR[i] + this.entradas[i].getMinAttribute()) / (this.entradas[i].getMaxAttribute() - this.entradas[i].getMinAttribute());
                    continue;
                }
                resN[i] = na[i];
                resS[i] = (double)resN[i] / (double)(this.entradas[i].getNominalValuesList().size() - 1);
                continue;
            }
            resM[i] = false;
            if (this.entradas[i].getType() == 2) {
                diff = rb[i] - ra[i];
                gap = Randomize.Rand();
                resR[i] = ra[i] + gap * diff;
                resS[i] = (resR[i] + this.entradas[i].getMinAttribute()) / (this.entradas[i].getMaxAttribute() - this.entradas[i].getMinAttribute());
                continue;
            }
            if (this.entradas[i].getType() == 1) {
                diff = rb[i] - ra[i];
                gap = Randomize.Rand();
                resR[i] = Math.round(ra[i] + gap * diff);
                resS[i] = (resR[i] + this.entradas[i].getMinAttribute()) / (this.entradas[i].getMaxAttribute() - this.entradas[i].getMinAttribute());
                continue;
            }
            int suerte = Randomize.Randint(0, 2);
            resN[i] = suerte == 0 ? na[i] : nb[i];
            resS[i] = (double)resN[i] / (double)(this.entradas[i].getNominalValuesList().size() - 1);
        }
    }

    @Override
    public void leerConfiguracion(String ficheroScript) {
        this.ficheroSalida = new String[2];
        String fichero = Fichero.leeFichero(ficheroScript);
        StringTokenizer lineasFichero = new StringTokenizer(fichero, "\n\r");
        lineasFichero.nextToken();
        String linea = lineasFichero.nextToken();
        StringTokenizer tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        String token = tokens.nextToken();
        byte[] line = token.getBytes();
        int i = 0;
        while (line[i] != 34) {
            ++i;
        }
        int j = ++i;
        while (line[j] != 34) {
            ++j;
        }
        this.ficheroTraining = new String(line, i, j - i);
        i = j + 1;
        while (line[i] != 34) {
            ++i;
        }
        j = ++i;
        while (line[j] != 34) {
            ++j;
        }
        this.ficheroTest = new String(line, i, j - i);
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        token = tokens.nextToken();
        line = token.getBytes();
        i = 0;
        while (line[i] != 34) {
            ++i;
        }
        j = ++i;
        while (line[j] != 34) {
            ++j;
        }
        this.ficheroSalida[0] = new String(line, i, j - i);
        i = j + 1;
        while (line[i] != 34) {
            ++i;
        }
        j = ++i;
        while (line[j] != 34) {
            ++j;
        }
        this.ficheroSalida[1] = new String(line, i, j - i);
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        this.semilla = Long.parseLong(tokens.nextToken().substring(1));
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        this.kSMOTE = Integer.parseInt(tokens.nextToken().substring(1));
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        token = tokens.nextToken();
        token = token.substring(1);
        this.ASMO = token.equalsIgnoreCase("both") ? 0 : (token.equalsIgnoreCase("minority") ? 1 : 2);
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        token = tokens.nextToken();
        token = token.substring(1);
        this.balance = token.equalsIgnoreCase("YES");
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        this.smoting = Double.parseDouble(tokens.nextToken().substring(1));
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        this.distanceEu = tokens.nextToken().substring(1).equalsIgnoreCase("Euclidean");
    }
}

