/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Statistical_Classifiers.Shared.DiscrAnalysis;

import keel.Algorithms.Statistical_Classifiers.Shared.MatrixCalcs.ErrorDimension;
import keel.Algorithms.Statistical_Classifiers.Shared.MatrixCalcs.ErrorSingular;
import keel.Algorithms.Statistical_Classifiers.Shared.MatrixCalcs.MatrixCalcs;

public class AD {
    double[][][] COVAR;
    double[][][] MEDIA;
    double[][] ejemplos;
    double[][] deseado;
    int nentradas;
    int nsalidas;
    int nelem;
    int[] nejemplos;

    public AD(double[][] vejemplos, double[][] vdeseado) {
        this.ejemplos = vejemplos;
        this.deseado = vdeseado;
        this.nentradas = this.ejemplos[0].length;
        this.nsalidas = this.deseado[0].length;
        this.nelem = this.ejemplos.length;
        this.COVAR = new double[this.nsalidas][this.nentradas][this.nentradas];
        this.MEDIA = new double[this.nsalidas][this.nentradas][1];
        this.nejemplos = new int[this.nsalidas];
        for (int i = 0; i < this.nelem; ++i) {
            for (int s = 0; s < this.nsalidas; ++s) {
                if (this.deseado[i][s] == 0.0) continue;
                int n = s;
                this.nejemplos[n] = this.nejemplos[n] + 1;
            }
        }
    }

    public void computeParameter(boolean lineal) throws ErrorDimension, ErrorSingular {
        int i;
        int s;
        for (int i2 = 0; i2 < this.nelem; ++i2) {
            for (s = 0; s < this.nsalidas; ++s) {
                if (this.deseado[i2][s] == 0.0) continue;
                this.MEDIA[s] = MatrixCalcs.matsum(this.MEDIA[s], MatrixCalcs.columna(this.ejemplos[i2]));
            }
        }
        for (int s2 = 0; s2 < this.nsalidas; ++s2) {
            this.MEDIA[s2] = MatrixCalcs.matmul(this.MEDIA[s2], 1.0f / (float)this.nejemplos[s2]);
        }
        if (lineal) {
            for (i = 0; i < this.nelem; ++i) {
                for (int s3 = 0; s3 < this.nsalidas; ++s3) {
                    if (this.deseado[i][s3] == 0.0) continue;
                    double[][] tmp = MatrixCalcs.matsum(MatrixCalcs.columna(this.ejemplos[i]), MatrixCalcs.matmul(this.MEDIA[s3], -1.0));
                    tmp = MatrixCalcs.matmul(tmp, MatrixCalcs.tr(tmp));
                    this.COVAR[0] = MatrixCalcs.matsum(this.COVAR[0], tmp);
                }
            }
            this.COVAR[0] = MatrixCalcs.matmul(this.COVAR[0], 1.0f / (float)this.nelem);
            this.COVAR[0] = MatrixCalcs.inv(this.COVAR[0]);
            for (s = 1; s < this.nsalidas; ++s) {
                for (int i3 = 0; i3 < this.COVAR[s].length; ++i3) {
                    for (int j = 0; j < this.COVAR[s][i3].length; ++j) {
                        this.COVAR[s][i3][j] = this.COVAR[0][i3][j];
                    }
                }
            }
        } else {
            for (i = 0; i < this.nelem; ++i) {
                for (int s4 = 0; s4 < this.nsalidas; ++s4) {
                    if (this.deseado[i][s4] == 0.0) continue;
                    double[][] tmp = MatrixCalcs.matsum(MatrixCalcs.columna(this.ejemplos[i]), MatrixCalcs.matmul(this.MEDIA[s4], -1.0));
                    tmp = MatrixCalcs.matmul(tmp, MatrixCalcs.tr(tmp));
                    this.COVAR[s4] = MatrixCalcs.matsum(this.COVAR[s4], tmp);
                }
            }
            for (s = 0; s < this.nsalidas; ++s) {
                this.COVAR[s] = MatrixCalcs.matmul(this.COVAR[s], 1.0f / (float)this.nejemplos[s]);
                this.COVAR[s] = MatrixCalcs.inv(this.COVAR[s]);
            }
        }
    }

    public String AString(double[] s) {
        String result = "[";
        for (int i = 0; i < s.length; ++i) {
            result = result + s[i] + " ";
        }
        return result + "]";
    }

    public String AString(double[][] s) {
        String result = "[";
        for (int i = 0; i < s.length; ++i) {
            result = result + this.AString(s[i]) + " ";
        }
        return result + "]";
    }

    public double[] distances(double[] x) throws ErrorDimension, ErrorSingular {
        double[] d = new double[this.nsalidas];
        double[][] cx = MatrixCalcs.columna(x);
        for (int s = 0; s < this.nsalidas; ++s) {
            double[][] g = MatrixCalcs.matmul(MatrixCalcs.tr(cx), MatrixCalcs.matmul(this.COVAR[s], cx));
            g = MatrixCalcs.matmul(g, -0.5);
            double[][] w = MatrixCalcs.tr(MatrixCalcs.matmul(this.COVAR[s], this.MEDIA[s]));
            g = MatrixCalcs.matsum(g, MatrixCalcs.matmul(w, cx));
            double[][] C1 = MatrixCalcs.matmul(MatrixCalcs.tr(this.MEDIA[s]), MatrixCalcs.matmul(this.COVAR[s], this.MEDIA[s]));
            C1 = MatrixCalcs.matmul(C1, -0.5);
            double C2 = 0.5 * Math.log(MatrixCalcs.determinante(this.COVAR[s]));
            double C3 = Math.log((double)this.nejemplos[s] / (double)this.nelem);
            d[s] = g[0][0] + C1[0][0] + C2 + C3;
        }
        return d;
    }

    public void AlmacenaParametros(double[] pesos) {
        int k;
        int j;
        int i;
        int p = 0;
        for (i = 0; i < this.COVAR.length; ++i) {
            for (j = 0; j < this.COVAR[i].length; ++j) {
                for (k = 0; k < this.COVAR[i][j].length; ++k) {
                    pesos[p++] = this.COVAR[i][j][k];
                }
            }
        }
        for (i = 0; i < this.MEDIA.length; ++i) {
            for (j = 0; j < this.MEDIA[i].length; ++j) {
                for (k = 0; k < this.MEDIA[i][j].length; ++k) {
                    pesos[p++] = this.MEDIA[i][j][k];
                }
            }
        }
        for (i = 0; i < this.nejemplos.length; ++i) {
            pesos[p++] = this.nejemplos[i];
        }
    }

    public void RecuperaParametros(double[] pesos) {
        int k;
        int j;
        int i;
        int p = 0;
        for (i = 0; i < this.COVAR.length; ++i) {
            for (j = 0; j < this.COVAR[i].length; ++j) {
                for (k = 0; k < this.COVAR[i][j].length; ++k) {
                    this.COVAR[i][j][k] = pesos[p++];
                }
            }
        }
        for (i = 0; i < this.MEDIA.length; ++i) {
            for (j = 0; j < this.MEDIA[i].length; ++j) {
                for (k = 0; k < this.MEDIA[i][j].length; ++k) {
                    this.MEDIA[i][j][k] = pesos[p++];
                }
            }
        }
        for (i = 0; i < this.nejemplos.length; ++i) {
            this.nejemplos[i] = (int)pesos[p++];
        }
    }

    public static int argmax(double[] x) {
        double max = x[0];
        int imax = 0;
        for (int i = 1; i < x.length; ++i) {
            if (!(x[i] > max)) continue;
            max = x[i];
            imax = i;
        }
        return imax;
    }
}

