/*
 * Decompiled with CFR 0.152.
 */
package javolution.lang;

import java.io.IOException;
import javolution.lang.MathLib;
import javolution.lang.TextFormat;

public final class TypeFormat {
    private static final char[] DIGIT_TO_CHAR;
    private static final int[] CHAR_TO_DIGIT;
    private static final int[] INT_POW_10;
    private static final long[] LONG_POW_10;
    private static final double POSITIVE_INFINITY = Double.POSITIVE_INFINITY;
    private static final double NEGATIVE_INFINITY = Double.NEGATIVE_INFINITY;
    private static final double[] DOUBLE_POW_10;

    private TypeFormat() {
    }

    public static boolean parseBoolean(CharSequence charSequence) {
        if (!(charSequence.length() != 4 || charSequence.charAt(0) != 't' && charSequence.charAt(0) != 'T' || charSequence.charAt(1) != 'r' && charSequence.charAt(1) != 'R' || charSequence.charAt(2) != 'u' && charSequence.charAt(2) != 'U' || charSequence.charAt(3) != 'e' && charSequence.charAt(3) != 'E')) {
            return true;
        }
        if (!(charSequence.length() != 5 || charSequence.charAt(0) != 'f' && charSequence.charAt(0) != 'F' || charSequence.charAt(1) != 'a' && charSequence.charAt(1) != 'A' || charSequence.charAt(2) != 'l' && charSequence.charAt(2) != 'L' || charSequence.charAt(3) != 's' && charSequence.charAt(2) != 'S' || charSequence.charAt(4) != 'e' && charSequence.charAt(3) != 'E')) {
            return false;
        }
        throw new IllegalArgumentException("Cannot parse " + charSequence + " as boolean");
    }

    public static boolean parseBoolean(CharSequence charSequence, TextFormat.Cursor cursor) {
        int n = cursor.getIndex();
        if (!(charSequence.length() <= n + 4 || charSequence.charAt(n) != 't' && charSequence.charAt(n) != 'T' || charSequence.charAt(n + 1) != 'r' && charSequence.charAt(n + 1) != 'R' || charSequence.charAt(n + 2) != 'u' && charSequence.charAt(n + 2) != 'U' || charSequence.charAt(n + 3) != 'e' && charSequence.charAt(n + 3) != 'E')) {
            cursor.increment(4);
            return true;
        }
        if (!(charSequence.length() <= n + 5 || charSequence.charAt(n) != 'f' && charSequence.charAt(n) != 'F' || charSequence.charAt(n + 1) != 'a' && charSequence.charAt(n + 1) != 'A' || charSequence.charAt(n + 2) != 'l' && charSequence.charAt(n + 2) != 'L' || charSequence.charAt(n + 3) != 's' && charSequence.charAt(n + 3) != 'S' || charSequence.charAt(n + 4) != 'e' && charSequence.charAt(n + 4) != 'E')) {
            cursor.increment(5);
            return true;
        }
        throw new IllegalArgumentException("Cannot parse boolean at " + cursor.getIndex());
    }

    public static byte parseByte(CharSequence charSequence) {
        return TypeFormat.parseByte(charSequence, 10);
    }

    public static byte parseByte(CharSequence charSequence, int n) {
        int n2 = TypeFormat.parseInt(charSequence, n);
        if (n2 < -128 || n2 > 127) {
            throw new NumberFormatException("Overflow");
        }
        return (byte)n2;
    }

    public static byte parseByte(CharSequence charSequence, int n, TextFormat.Cursor cursor) {
        int n2 = TypeFormat.parseInt(charSequence, n, cursor);
        if (n2 < -128 || n2 > 127) {
            throw new NumberFormatException("Overflow");
        }
        return (byte)n2;
    }

    public static short parseShort(CharSequence charSequence) {
        return TypeFormat.parseShort(charSequence, 10);
    }

    public static short parseShort(CharSequence charSequence, int n) {
        int n2 = TypeFormat.parseInt(charSequence, n);
        if (n2 < Short.MIN_VALUE || n2 > Short.MAX_VALUE) {
            throw new NumberFormatException("Overflow");
        }
        return (short)n2;
    }

    public static short parseShort(CharSequence charSequence, int n, TextFormat.Cursor cursor) {
        int n2 = TypeFormat.parseInt(charSequence, n, cursor);
        if (n2 < Short.MIN_VALUE || n2 > Short.MAX_VALUE) {
            throw new NumberFormatException("Overflow");
        }
        return (short)n2;
    }

    public static int parseInt(CharSequence charSequence) {
        return TypeFormat.parseInt(charSequence, 10);
    }

    public static int parseInt(CharSequence charSequence, int n) {
        try {
            int n2;
            int n3 = charSequence.length();
            int n4 = 0;
            boolean bl = charSequence.charAt(n4) == '-';
            char c = charSequence.charAt(n4 += bl || charSequence.charAt(n4) == '+' ? 1 : 0);
            int n5 = n2 = c < CHAR_TO_DIGIT.length ? CHAR_TO_DIGIT[c] : -1;
            if (n2 < 0 || n2 >= n) {
                throw new NumberFormatException("Digit expected");
            }
            int n6 = -n2;
            while (++n4 < n3) {
                char c2 = charSequence.charAt(n4);
                int n7 = n2 = c2 < CHAR_TO_DIGIT.length ? CHAR_TO_DIGIT[c2] : -1;
                if (n2 < 0 || n2 >= n) break;
                if (n6 <= -59652323 && n6 < (Integer.MIN_VALUE + n2) / n) {
                    throw new NumberFormatException("Overflow");
                }
                n6 = n6 * n - n2;
            }
            if (!bl && n6 == Integer.MIN_VALUE) {
                throw new NumberFormatException("Overflow");
            }
            return bl ? n6 : -n6;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new NumberFormatException();
        }
    }

    public static int parseInt(CharSequence charSequence, int n, TextFormat.Cursor cursor) {
        try {
            int n2;
            int n3 = charSequence.length();
            int n4 = cursor.getIndex();
            boolean bl = charSequence.charAt(n4) == '-';
            char c = charSequence.charAt(n4 += bl || charSequence.charAt(n4) == '+' ? 1 : 0);
            int n5 = n2 = c < CHAR_TO_DIGIT.length ? CHAR_TO_DIGIT[c] : -1;
            if (n2 < 0 || n2 >= n) {
                throw new NumberFormatException("Digit expected");
            }
            int n6 = -n2;
            while (++n4 < n3) {
                char c2 = charSequence.charAt(n4);
                int n7 = n2 = c2 < CHAR_TO_DIGIT.length ? CHAR_TO_DIGIT[c2] : -1;
                if (n2 < 0 || n2 >= n) break;
                if (n6 <= -59652323 && n6 < (Integer.MIN_VALUE + n2) / n) {
                    throw new NumberFormatException("Overflow");
                }
                n6 = n6 * n - n2;
            }
            if (!bl && n6 == Integer.MIN_VALUE) {
                throw new NumberFormatException("Overflow");
            }
            cursor.setIndex(n4);
            return bl ? n6 : -n6;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new NumberFormatException();
        }
    }

    public static long parseLong(CharSequence charSequence) {
        return TypeFormat.parseLong(charSequence, 10);
    }

    public static long parseLong(CharSequence charSequence, int n) {
        try {
            int n2;
            int n3 = charSequence.length();
            int n4 = 0;
            boolean bl = charSequence.charAt(n4) == '-';
            char c = charSequence.charAt(n4 += bl || charSequence.charAt(n4) == '+' ? 1 : 0);
            int n5 = n2 = c < CHAR_TO_DIGIT.length ? CHAR_TO_DIGIT[c] : -1;
            if (n2 < 0 || n2 >= n) {
                throw new NumberFormatException("Digit expected");
            }
            long l = -n2;
            while (++n4 < n3) {
                char c2 = charSequence.charAt(n4);
                int n6 = n2 = c2 < CHAR_TO_DIGIT.length ? CHAR_TO_DIGIT[c2] : -1;
                if (n2 < 0 || n2 >= n) break;
                if (l <= -256204778801521550L && l < (Long.MIN_VALUE + (long)n2) / (long)n) {
                    throw new NumberFormatException("Overflow");
                }
                l = l * (long)n - (long)n2;
            }
            if (!bl && l == Long.MIN_VALUE) {
                throw new NumberFormatException("Overflow");
            }
            return bl ? l : -l;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new NumberFormatException();
        }
    }

    public static long parseLong(CharSequence charSequence, int n, TextFormat.Cursor cursor) {
        try {
            int n2;
            int n3 = charSequence.length();
            int n4 = cursor.getIndex();
            boolean bl = charSequence.charAt(n4) == '-';
            char c = charSequence.charAt(n4 += bl || charSequence.charAt(n4) == '+' ? 1 : 0);
            int n5 = n2 = c < CHAR_TO_DIGIT.length ? CHAR_TO_DIGIT[c] : -1;
            if (n2 < 0 || n2 >= n) {
                throw new NumberFormatException("Digit expected");
            }
            long l = -n2;
            while (++n4 < n3) {
                char c2 = charSequence.charAt(n4);
                int n6 = n2 = c2 < CHAR_TO_DIGIT.length ? CHAR_TO_DIGIT[c2] : -1;
                if (n2 < 0 || n2 >= n) break;
                if (l <= -256204778801521550L && l < (Long.MIN_VALUE + (long)n2) / (long)n) {
                    throw new NumberFormatException("Overflow");
                }
                l = l * (long)n - (long)n2;
            }
            if (!bl && l == Long.MIN_VALUE) {
                throw new NumberFormatException("Overflow");
            }
            cursor.setIndex(n4);
            return bl ? l : -l;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new NumberFormatException();
        }
    }

    public static float parseFloat(CharSequence charSequence) {
        double d = TypeFormat.parseDouble(charSequence);
        if (d >= -3.4028234663852886E38 && d <= 3.4028234663852886E38) {
            return (float)d;
        }
        throw new NumberFormatException("Overflow");
    }

    public static float parseFloat(CharSequence charSequence, TextFormat.Cursor cursor) {
        double d = TypeFormat.parseDouble(charSequence, cursor);
        if (d >= -3.4028234663852886E38 && d <= 3.4028234663852886E38) {
            return (float)d;
        }
        throw new NumberFormatException("Overflow");
    }

    public static double parseDouble(CharSequence charSequence) throws NumberFormatException {
        TextFormat.Cursor cursor = TextFormat.Cursor.newInstance();
        double d = TypeFormat.parseDouble(charSequence, cursor);
        cursor.recycle();
        return d;
    }

    public static double parseDouble(CharSequence charSequence, TextFormat.Cursor cursor) throws NumberFormatException {
        try {
            int n;
            int n2;
            int n3 = cursor.getIndex();
            if (TypeFormat.startWith(charSequence, n3, "NaN")) {
                cursor.increment(3);
                return Double.NaN;
            }
            if (TypeFormat.startWith(charSequence, n3, "-Infinity")) {
                cursor.increment(9);
                return Double.NEGATIVE_INFINITY;
            }
            if (TypeFormat.startWith(charSequence, n3, "Infinity")) {
                cursor.increment(8);
                return Double.POSITIVE_INFINITY;
            }
            long l = TypeFormat.parseLong(charSequence, 10, cursor);
            long l2 = 0L;
            int n4 = 0;
            if (cursor.getIndex() < charSequence.length() && (n2 = charSequence.charAt(cursor.getIndex())) == 46) {
                cursor.increment();
                n = cursor.getIndex();
                l2 = TypeFormat.parseLong(charSequence, 10, cursor);
                n4 = cursor.getIndex() - n;
            }
            n2 = 0;
            if (cursor.getIndex() < charSequence.length() && ((n = charSequence.charAt(cursor.getIndex())) == 101 || n == 69)) {
                cursor.increment();
                n2 = TypeFormat.parseInt(charSequence, 10, cursor);
            }
            double d = TypeFormat.multE(l, n2);
            double d2 = TypeFormat.multE(l < 0L ? (double)(-l2) : (double)l2, n2 - n4);
            return d + d2;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new NumberFormatException();
        }
    }

    static boolean startWith(CharSequence charSequence, int n, String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (n + i < charSequence.length() && charSequence.charAt(n + i) == string.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static Appendable format(boolean bl, Appendable appendable) throws IOException {
        return bl ? TypeFormat.append(appendable, "true") : TypeFormat.append(appendable, "false");
    }

    public static Appendable format(int n, Appendable appendable) throws IOException {
        int n2;
        if (n <= 0) {
            if (n == Integer.MIN_VALUE) {
                return TypeFormat.append(appendable, "-2147483648");
            }
            if (n == 0) {
                return appendable.append('0');
            }
            n = -n;
            appendable.append('-');
        }
        for (n2 = 1; n2 < 10 && n >= INT_POW_10[n2]; ++n2) {
        }
        --n2;
        while (n2 >= 0) {
            int n3 = INT_POW_10[n2];
            int n4 = n / n3;
            n -= n4 * n3;
            appendable.append(DIGIT_TO_CHAR[n4]);
            --n2;
        }
        return appendable;
    }

    public static Appendable format(int n, int n2, Appendable appendable) throws IOException {
        if (n2 == 10) {
            return TypeFormat.format(n, appendable);
        }
        if (n2 < 2 || n2 > 36) {
            throw new IllegalArgumentException("radix: " + n2);
        }
        if (n < 0) {
            appendable.append('-');
        } else {
            n = -n;
        }
        TypeFormat.format2(n, n2, appendable);
        return appendable;
    }

    private static void format2(int n, int n2, Appendable appendable) throws IOException {
        if (n <= -n2) {
            TypeFormat.format2(n / n2, n2, appendable);
            appendable.append(DIGIT_TO_CHAR[-(n % n2)]);
        } else {
            appendable.append(DIGIT_TO_CHAR[-n]);
        }
    }

    public static Appendable format(long l, Appendable appendable) throws IOException {
        int n;
        if (l <= 0L) {
            if (l == Long.MIN_VALUE) {
                return TypeFormat.append(appendable, "-9223372036854775808");
            }
            if (l == 0L) {
                return appendable.append('0');
            }
            l = -l;
            appendable.append('-');
        }
        for (n = 1; n < 19 && l >= LONG_POW_10[n]; ++n) {
        }
        --n;
        while (n >= 0) {
            long l2 = LONG_POW_10[n];
            int n2 = (int)(l / l2);
            l -= (long)n2 * l2;
            appendable.append(DIGIT_TO_CHAR[n2]);
            --n;
        }
        return appendable;
    }

    public static Appendable format(long l, int n, Appendable appendable) throws IOException {
        if (n == 10) {
            return TypeFormat.format(l, appendable);
        }
        if (n < 2 || n > 36) {
            throw new IllegalArgumentException("radix: " + n);
        }
        if (l < 0L) {
            appendable.append('-');
        } else {
            l = -l;
        }
        TypeFormat.format2(l, n, appendable);
        return appendable;
    }

    private static void format2(long l, int n, Appendable appendable) throws IOException {
        if (l <= (long)(-n)) {
            TypeFormat.format2(l / (long)n, n, appendable);
            appendable.append(DIGIT_TO_CHAR[(int)(-(l % (long)n))]);
        } else {
            appendable.append(DIGIT_TO_CHAR[(int)(-l)]);
        }
    }

    public static Appendable format(float f, Appendable appendable) throws IOException {
        return TypeFormat.format(f, 10, (double)MathLib.abs(f) > 1.0E7, false, appendable);
    }

    public static Appendable format(double d, Appendable appendable) throws IOException {
        return TypeFormat.format(d, 17, MathLib.abs(d) > 1.0E7, false, appendable);
    }

    public static Appendable format(double d, int n, boolean bl, boolean bl2, Appendable appendable) throws IOException {
        if (n > 19 || n <= 0) {
            throw new IllegalArgumentException("digits: " + n);
        }
        if (d != d) {
            return TypeFormat.append(appendable, "NaN");
        }
        if (d == Double.POSITIVE_INFINITY) {
            return TypeFormat.append(appendable, "Infinity");
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return TypeFormat.append(appendable, "-Infinity");
        }
        if (d == 0.0) {
            if (n == 1) {
                return TypeFormat.append(appendable, "0");
            }
            if (!bl2) {
                return TypeFormat.append(appendable, "0.0");
            }
            TypeFormat.append(appendable, "0.0");
            for (int i = 2; i < n; ++i) {
                appendable.append('0');
            }
            return appendable;
        }
        if (d < 0.0) {
            d = -d;
            appendable.append('-');
        }
        int n2 = d >= 1.0 ? 1 + TypeFormat.minPow10(d) : -TypeFormat.minPow10(1.0 / d);
        double d2 = TypeFormat.multE(d, n - n2);
        long l = (long)(d2 + 0.5);
        if (bl || n2 <= 0 || n2 > n) {
            TypeFormat.format(l / LONG_POW_10[n - 1], appendable);
            TypeFormat.formatFraction(l % LONG_POW_10[n - 1], n - 1, bl2, appendable);
            appendable.append('E');
            TypeFormat.format(n2 - 1, appendable);
        } else if (n2 == n) {
            TypeFormat.format(l, appendable);
        } else {
            TypeFormat.format(l / LONG_POW_10[n - n2], appendable);
            TypeFormat.formatFraction(l % LONG_POW_10[n - n2], n - n2, bl2, appendable);
        }
        return appendable;
    }

    private static void formatFraction(long l, int n, boolean bl, Appendable appendable) throws IOException {
        if (n == 0) {
            return;
        }
        appendable.append('.');
        int n2 = n;
        while (n2 > 0) {
            long l2 = LONG_POW_10[--n2];
            int n3 = (int)(l / l2);
            appendable.append(DIGIT_TO_CHAR[n3]);
            if ((l -= (long)n3 * l2) != 0L || bl) continue;
            return;
        }
    }

    private static int minPow10(double d) {
        int n = 0;
        int n2 = DOUBLE_POW_10.length;
        while (n2 - n > 1) {
            int n3 = n + n2 >> 1;
            if (d >= DOUBLE_POW_10[n3]) {
                n = n3;
                continue;
            }
            n2 = n3;
        }
        return n;
    }

    private static Appendable append(Appendable appendable, String string) throws IOException {
        for (int i = 0; i < string.length(); ++i) {
            appendable.append(string.charAt(i));
        }
        return appendable;
    }

    private static double multE(double d, int n) {
        if (n >= 0) {
            if (n <= 308) {
                return d * DOUBLE_POW_10[n];
            }
            n = Math.min(308, n - 308);
            return (d *= 1.0E308) * DOUBLE_POW_10[n];
        }
        if (n >= -308) {
            return d / DOUBLE_POW_10[-n];
        }
        n = Math.max(-308, n + 308);
        return (d /= 1.0E308) / DOUBLE_POW_10[-n];
    }

    static {
        int n;
        DIGIT_TO_CHAR = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
        CHAR_TO_DIGIT = new int[128];
        for (n = 0; n < CHAR_TO_DIGIT.length; ++n) {
            TypeFormat.CHAR_TO_DIGIT[n] = -1;
        }
        for (n = 0; n < DIGIT_TO_CHAR.length; ++n) {
            TypeFormat.CHAR_TO_DIGIT[TypeFormat.DIGIT_TO_CHAR[n]] = n;
            TypeFormat.CHAR_TO_DIGIT[Character.toUpperCase((char)TypeFormat.DIGIT_TO_CHAR[n])] = n;
        }
        INT_POW_10 = new int[10];
        n = 1;
        for (int i = 0; i < 10; ++i) {
            TypeFormat.INT_POW_10[i] = n;
            n *= 10;
        }
        LONG_POW_10 = new long[19];
        long l = 1L;
        for (int i = 0; i < 19; ++i) {
            TypeFormat.LONG_POW_10[i] = l;
            l *= 10L;
        }
        DOUBLE_POW_10 = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9, 1.0E10, 1.0E11, 1.0E12, 1.0E13, 1.0E14, 1.0E15, 1.0E16, 1.0E17, 1.0E18, 1.0E19, 1.0E20, 1.0E21, 1.0E22, 1.0E23, 1.0E24, 1.0E25, 1.0E26, 1.0E27, 1.0E28, 1.0E29, 1.0E30, 1.0E31, 1.0E32, 1.0E33, 1.0E34, 1.0E35, 1.0E36, 1.0E37, 1.0E38, 1.0E39, 1.0E40, 1.0E41, 1.0E42, 1.0E43, 1.0E44, 1.0E45, 1.0E46, 1.0E47, 1.0E48, 1.0E49, 1.0E50, 1.0E51, 1.0E52, 1.0E53, 1.0E54, 1.0E55, 1.0E56, 1.0E57, 1.0E58, 1.0E59, 1.0E60, 1.0E61, 1.0E62, 1.0E63, 1.0E64, 1.0E65, 1.0E66, 1.0E67, 1.0E68, 1.0E69, 1.0E70, 1.0E71, 1.0E72, 1.0E73, 1.0E74, 1.0E75, 1.0E76, 1.0E77, 1.0E78, 1.0E79, 1.0E80, 1.0E81, 1.0E82, 1.0E83, 1.0E84, 1.0E85, 1.0E86, 1.0E87, 1.0E88, 1.0E89, 1.0E90, 1.0E91, 1.0E92, 1.0E93, 1.0E94, 1.0E95, 1.0E96, 1.0E97, 1.0E98, 1.0E99, 1.0E100, 1.0E101, 1.0E102, 1.0E103, 1.0E104, 1.0E105, 1.0E106, 1.0E107, 1.0E108, 1.0E109, 1.0E110, 1.0E111, 1.0E112, 1.0E113, 1.0E114, 1.0E115, 1.0E116, 1.0E117, 1.0E118, 1.0E119, 1.0E120, 1.0E121, 1.0E122, 1.0E123, 1.0E124, 1.0E125, 1.0E126, 1.0E127, 1.0E128, 1.0E129, 1.0E130, 1.0E131, 1.0E132, 1.0E133, 1.0E134, 1.0E135, 1.0E136, 1.0E137, 1.0E138, 1.0E139, 1.0E140, 1.0E141, 1.0E142, 1.0E143, 1.0E144, 1.0E145, 1.0E146, 1.0E147, 1.0E148, 1.0E149, 1.0E150, 1.0E151, 1.0E152, 1.0E153, 1.0E154, 1.0E155, 1.0E156, 1.0E157, 1.0E158, 1.0E159, 1.0E160, 1.0E161, 1.0E162, 1.0E163, 1.0E164, 1.0E165, 1.0E166, 1.0E167, 1.0E168, 1.0E169, 1.0E170, 1.0E171, 1.0E172, 1.0E173, 1.0E174, 1.0E175, 1.0E176, 1.0E177, 1.0E178, 1.0E179, 1.0E180, 1.0E181, 1.0E182, 1.0E183, 1.0E184, 1.0E185, 1.0E186, 1.0E187, 1.0E188, 1.0E189, 1.0E190, 1.0E191, 1.0E192, 1.0E193, 1.0E194, 1.0E195, 1.0E196, 1.0E197, 1.0E198, 1.0E199, 1.0E200, 1.0E201, 1.0E202, 1.0E203, 1.0E204, 1.0E205, 1.0E206, 1.0E207, 1.0E208, 1.0E209, 1.0E210, 1.0E211, 1.0E212, 1.0E213, 1.0E214, 1.0E215, 1.0E216, 1.0E217, 1.0E218, 1.0E219, 1.0E220, 1.0E221, 1.0E222, 1.0E223, 1.0E224, 1.0E225, 1.0E226, 1.0E227, 1.0E228, 1.0E229, 1.0E230, 1.0E231, 1.0E232, 1.0E233, 1.0E234, 1.0E235, 1.0E236, 1.0E237, 1.0E238, 1.0E239, 1.0E240, 1.0E241, 1.0E242, 1.0E243, 1.0E244, 1.0E245, 1.0E246, 1.0E247, 1.0E248, 1.0E249, 1.0E250, 1.0E251, 1.0E252, 1.0E253, 1.0E254, 1.0E255, 1.0E256, 1.0E257, 1.0E258, 1.0E259, 1.0E260, 1.0E261, 1.0E262, 1.0E263, 1.0E264, 1.0E265, 1.0E266, 1.0E267, 1.0E268, 1.0E269, 1.0E270, 1.0E271, 1.0E272, 1.0E273, 1.0E274, 1.0E275, 1.0E276, 1.0E277, 1.0E278, 1.0E279, 1.0E280, 1.0E281, 1.0E282, 1.0E283, 1.0E284, 1.0E285, 1.0E286, 1.0E287, 1.0E288, 1.0E289, 1.0E290, 1.0E291, 1.0E292, 1.0E293, 1.0E294, 1.0E295, 1.0E296, 1.0E297, 1.0E298, 1.0E299, 1.0E300, 1.0E301, 1.0E302, 1.0E303, 1.0E304, 1.0E305, 1.0E306, 1.0E307, 1.0E308};
    }
}

