/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.QAR_CIP_NSGAII;

import java.io.PrintWriter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.QAR_CIP_NSGAII.AssociationRule;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.QAR_CIP_NSGAII.Chromosome;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.QAR_CIP_NSGAII.Gene;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.QAR_CIP_NSGAII.Lists;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.QAR_CIP_NSGAII.Sort;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.QAR_CIP_NSGAII.myDataset;
import org.core.Randomize;

public class QAR_CIP_NSGAIIProcess {
    private static double INF = 1.0E14;
    private String paretos;
    private myDataset dataset;
    private int nTrials;
    private int numObjectives;
    private double minSupport;
    private double pm;
    private double af;
    private int uPopSize;
    private int nAttr;
    private int nTrans;
    private int trials;
    private int updatePop;
    private double percentUpdate;
    private ArrayList<Chromosome> uPop;
    private ArrayList<Chromosome> child_pop;
    private ArrayList<Chromosome> mixed_pop;
    private ArrayList<Chromosome> EP;

    public QAR_CIP_NSGAIIProcess(myDataset dataset, int numObjectives, int nTrials, int popSize, double pm, double af, double percentUpdate) {
        this.dataset = dataset;
        this.nTrials = nTrials;
        this.uPopSize = popSize;
        this.pm = pm;
        this.af = af;
        this.minSupport = 0.0;
        this.percentUpdate = percentUpdate;
        this.numObjectives = numObjectives;
        this.nAttr = this.dataset.getnVars();
        this.nTrans = this.dataset.getnTrans();
        this.trials = 0;
        this.paretos = new String("");
        this.uPop = new ArrayList();
        this.child_pop = new ArrayList();
        this.mixed_pop = new ArrayList();
        this.EP = new ArrayList();
    }

    public void run() {
        int nGn = 0;
        this.trials = 0;
        this.paretos = new String("");
        System.out.println("Initialization");
        this.initializePopulation();
        this.assign_rank_and_crowding_distance(this.uPop);
        do {
            System.out.println("Computing Generation " + (nGn + 1));
            this.updatePop = 0;
            this.selection();
            this.merge();
            this.fill_nondominated_sort();
            this.upadateEP_pop();
            this.verifyRestartPop(this.percentUpdate);
            ++nGn;
        } while (this.trials < this.nTrials);
        this.removeRedundant(this.uPop);
        this.removeRedundant(this.EP);
        this.printPareto();
        System.out.println("done.\n");
    }

    private void initializePopulation() {
        int i;
        this.uPop.clear();
        ArrayList<Integer> tr_not_marked = new ArrayList<Integer>();
        Gene[] rnd_genes = new Gene[this.nAttr];
        int[] sample = new int[this.nAttr];
        this.trials = 0;
        for (i = 0; i < this.nAttr; ++i) {
            rnd_genes[i] = new Gene();
        }
        for (i = 0; i < this.nAttr; ++i) {
            sample[i] = i;
        }
        for (i = 0; i < this.nTrans; ++i) {
            tr_not_marked.add(i);
        }
        while (this.uPop.size() <= this.uPopSize) {
            double ub;
            double lb;
            double value;
            if (tr_not_marked.size() == 0) {
                for (i = 0; i < this.nTrans; ++i) {
                    tr_not_marked.add(i);
                }
            }
            int pos = (Integer)tr_not_marked.get(Randomize.Randint(0, tr_not_marked.size()));
            double[] example = this.dataset.getExample(pos);
            for (i = 0; i < this.nAttr; ++i) {
                int j = Randomize.Randint(0, this.nAttr);
                int tmp = sample[i];
                sample[i] = sample[j];
                sample[j] = tmp;
            }
            int nAnts = Randomize.Randint(1, this.nAttr);
            for (i = 0; i < nAnts; ++i) {
                rnd_genes[sample[i]].setAttr(sample[i]);
                rnd_genes[sample[i]].setActAs(0);
                value = example[sample[i]];
                if (this.dataset.getAttributeType(sample[i]) != 0) {
                    if (this.dataset.getAttributeType(sample[i]) == 2) {
                        lb = Math.max(value - this.dataset.getAmplitude(sample[i]) / (this.af * 4.0), this.dataset.getMin(sample[i]));
                        ub = Math.min(value + this.dataset.getAmplitude(sample[i]) / (this.af * 4.0), this.dataset.getMax(sample[i]));
                    } else {
                        lb = Math.max((double)((int)(value - this.dataset.getAmplitude(sample[i]) / (this.af * 4.0))), this.dataset.getMin(sample[i]));
                        ub = Math.min((double)((int)(value + this.dataset.getAmplitude(sample[i]) / (this.af * 4.0))), this.dataset.getMax(sample[i]));
                    }
                } else {
                    lb = ub = (double)((int)value);
                }
                rnd_genes[sample[i]].setLowerBound(lb);
                rnd_genes[sample[i]].setUpperBound(ub);
                rnd_genes[sample[i]].setIsPositiveInterval(true);
            }
            rnd_genes[sample[i]].setAttr(sample[i]);
            rnd_genes[sample[i]].setActAs(1);
            value = example[sample[i]];
            if (this.dataset.getAttributeType(sample[i]) != 0) {
                if (this.dataset.getAttributeType(sample[i]) == 2) {
                    lb = Math.max(value - this.dataset.getAmplitude(sample[i]) / (this.af * 4.0), this.dataset.getMin(sample[i]));
                    ub = Math.min(value + this.dataset.getAmplitude(sample[i]) / (this.af * 4.0), this.dataset.getMax(sample[i]));
                } else {
                    lb = Math.max((double)((int)(value - this.dataset.getAmplitude(sample[i]) / (this.af * 4.0))), this.dataset.getMin(sample[i]));
                    ub = Math.min((double)((int)(value + this.dataset.getAmplitude(sample[i]) / (this.af * 4.0))), this.dataset.getMax(sample[i]));
                }
            } else {
                lb = ub = (double)((int)value);
            }
            rnd_genes[sample[i]].setLowerBound(lb);
            rnd_genes[sample[i]].setUpperBound(ub);
            rnd_genes[sample[i]].setIsPositiveInterval(true);
            for (i = nAnts + 1; i < this.nAttr; ++i) {
                rnd_genes[sample[i]].setAttr(sample[i]);
                rnd_genes[sample[i]].setActAs(-1);
                if (this.dataset.getAttributeType(sample[i]) != 0) {
                    if (this.dataset.getAttributeType(sample[i]) == 2) {
                        value = Randomize.RanddoubleClosed(this.dataset.getMin(sample[i]), this.dataset.getMax(sample[i]));
                        lb = Math.max(value - this.dataset.getAmplitude(sample[i]) / (this.af * 4.0), this.dataset.getMin(sample[i]));
                        ub = Math.min(value + this.dataset.getAmplitude(sample[i]) / (this.af * 4.0), this.dataset.getMax(sample[i]));
                    } else {
                        value = Randomize.RandintClosed((int)this.dataset.getMin(sample[i]), (int)this.dataset.getMax(sample[i]));
                        lb = (int)Math.max((double)((int)(value - this.dataset.getAmplitude(sample[i]) / (this.af * 4.0))), this.dataset.getMin(sample[i]));
                        ub = (int)Math.min((double)((int)(value + this.dataset.getAmplitude(sample[i]) / (this.af * 4.0))), this.dataset.getMax(sample[i]));
                    }
                } else {
                    value = Randomize.RandintClosed((int)this.dataset.getMin(sample[i]), (int)this.dataset.getMax(sample[i]));
                    lb = ub = (double)((int)value);
                }
                rnd_genes[sample[i]].setLowerBound(lb);
                rnd_genes[sample[i]].setUpperBound(ub);
                rnd_genes[sample[i]].setIsPositiveInterval(true);
            }
            Chromosome chromo = new Chromosome(rnd_genes, this.numObjectives);
            chromo.computeObjetives(this.dataset);
            ++this.trials;
            if (this.equalChromotoPop(chromo, this.uPop) || !(chromo.getSupport() > this.minSupport) || chromo.getSupport() > 1.0 - this.minSupport || !(chromo.getCF() > 0.0)) continue;
            this.uPop.add(chromo);
            this.deleteTransCovered(chromo, tr_not_marked);
        }
        this.EP = this.nonDominateSelection(this.uPop);
    }

    private void deleteTransCovered(Chromosome chromo, ArrayList<Integer> tr_not_marked) {
        for (int i = tr_not_marked.size() - 1; i >= 0; --i) {
            double[] example = this.dataset.getExample(tr_not_marked.get(i));
            if (!chromo.isCovered(example)) continue;
            tr_not_marked.remove(i);
        }
    }

    private void upadateEP_pop() {
        for (int i = 0; i < this.uPop.size(); ++i) {
            this.updateEP(this.uPop.get(i));
        }
    }

    private void verifyRestartPop(double percent) {
        double percentUpdate = (double)this.uPopSize * percent / 100.0;
        if ((double)this.updatePop < percentUpdate) {
            this.restartPop();
        }
    }

    private void restartPop() {
        ArrayList<Integer> tr_not_marked = this.tr_notCovered_NoDominateSolutions();
        this.uPop.clear();
        int k = 0;
        int cont = 0;
        while (k < this.uPopSize) {
            if (tr_not_marked.size() == 0) {
                for (int i = 0; i < this.nTrans; ++i) {
                    tr_not_marked.add(i);
                }
            }
            int random_pos = Randomize.Randint(0, tr_not_marked.size());
            int pos = tr_not_marked.get(random_pos);
            Chromosome chromo = this.generateChromoCovered(pos);
            tr_not_marked.remove(random_pos);
            if (!this.equalChromotoPop(chromo, this.uPop) && chromo.getSupport() > this.minSupport && !(chromo.getSupport() > 1.0 - this.minSupport) && chromo.getCF() > 0.0) {
                this.uPop.add(chromo);
                this.deleteTransCovered(this.uPop.get(k), tr_not_marked);
                this.updateEP(chromo);
                ++k;
                cont = 0;
                continue;
            }
            if (cont > 1000) {
                tr_not_marked.clear();
                cont = 0;
                continue;
            }
            ++cont;
        }
    }

    private Chromosome generateChromoCovered(int pos_example) {
        double ub;
        double lb;
        double value;
        int i;
        double[] example = this.dataset.getExample(pos_example);
        Gene[] rnd_genes = new Gene[this.nAttr];
        int[] sample = new int[this.nAttr];
        for (i = 0; i < this.nAttr; ++i) {
            rnd_genes[i] = new Gene();
        }
        for (i = 0; i < this.nAttr; ++i) {
            sample[i] = i;
        }
        for (i = 0; i < this.nAttr; ++i) {
            int j = Randomize.Randint(0, this.nAttr);
            int tmp = sample[i];
            sample[i] = sample[j];
            sample[j] = tmp;
        }
        int nAnts = Randomize.Randint(1, this.nAttr);
        for (i = 0; i < nAnts; ++i) {
            rnd_genes[sample[i]].setAttr(sample[i]);
            rnd_genes[sample[i]].setActAs(0);
            value = example[sample[i]];
            if (this.dataset.getAttributeType(sample[i]) != 0) {
                if (this.dataset.getAttributeType(sample[i]) == 2) {
                    lb = Math.max(value - this.dataset.getAmplitude(sample[i]) / (this.af * 4.0), this.dataset.getMin(sample[i]));
                    ub = Math.min(value + this.dataset.getAmplitude(sample[i]) / (this.af * 4.0), this.dataset.getMax(sample[i]));
                } else {
                    lb = Math.max((double)((int)(value - this.dataset.getAmplitude(sample[i]) / (this.af * 4.0))), this.dataset.getMin(sample[i]));
                    ub = Math.min((double)((int)(value + this.dataset.getAmplitude(sample[i]) / (this.af * 4.0))), this.dataset.getMax(sample[i]));
                }
            } else {
                lb = ub = (double)((int)value);
            }
            rnd_genes[sample[i]].setLowerBound(lb);
            rnd_genes[sample[i]].setUpperBound(ub);
            rnd_genes[sample[i]].setIsPositiveInterval(true);
        }
        rnd_genes[sample[i]].setAttr(sample[i]);
        rnd_genes[sample[i]].setActAs(1);
        value = example[sample[i]];
        if (this.dataset.getAttributeType(sample[i]) != 0) {
            if (this.dataset.getAttributeType(sample[i]) == 2) {
                lb = Math.max(value - this.dataset.getAmplitude(sample[i]) / (this.af * 4.0), this.dataset.getMin(sample[i]));
                ub = Math.min(value + this.dataset.getAmplitude(sample[i]) / (this.af * 4.0), this.dataset.getMax(sample[i]));
            } else {
                lb = Math.max((double)((int)(value - this.dataset.getAmplitude(sample[i]) / (this.af * 4.0))), this.dataset.getMin(sample[i]));
                ub = Math.min((double)((int)(value + this.dataset.getAmplitude(sample[i]) / (this.af * 4.0))), this.dataset.getMax(sample[i]));
            }
        } else {
            lb = ub = (double)((int)value);
        }
        rnd_genes[sample[i]].setLowerBound(lb);
        rnd_genes[sample[i]].setUpperBound(ub);
        rnd_genes[sample[i]].setIsPositiveInterval(true);
        for (i = nAnts + 1; i < this.nAttr; ++i) {
            rnd_genes[sample[i]].setAttr(sample[i]);
            rnd_genes[sample[i]].setActAs(-1);
            if (this.dataset.getAttributeType(sample[i]) != 0) {
                if (this.dataset.getAttributeType(sample[i]) == 2) {
                    value = Randomize.RanddoubleClosed(this.dataset.getMin(sample[i]), this.dataset.getMax(sample[i]));
                    lb = Math.max(value - this.dataset.getAmplitude(sample[i]) / (this.af * 4.0), this.dataset.getMin(sample[i]));
                    ub = Math.min(value + this.dataset.getAmplitude(sample[i]) / (this.af * 4.0), this.dataset.getMax(sample[i]));
                } else {
                    value = Randomize.RandintClosed((int)this.dataset.getMin(sample[i]), (int)this.dataset.getMax(sample[i]));
                    lb = (int)Math.max((double)((int)(value - this.dataset.getAmplitude(sample[i]) / (this.af * 4.0))), this.dataset.getMin(sample[i]));
                    ub = (int)Math.min((double)((int)(value + this.dataset.getAmplitude(sample[i]) / (this.af * 4.0))), this.dataset.getMax(sample[i]));
                }
            } else {
                value = Randomize.RandintClosed((int)this.dataset.getMin(sample[i]), (int)this.dataset.getMax(sample[i]));
                lb = ub = (double)((int)value);
            }
            rnd_genes[sample[i]].setLowerBound(lb);
            rnd_genes[sample[i]].setUpperBound(ub);
            rnd_genes[sample[i]].setIsPositiveInterval(true);
        }
        Chromosome chromo = new Chromosome(rnd_genes, this.numObjectives);
        chromo.computeObjetives(this.dataset);
        ++this.trials;
        return chromo;
    }

    private ArrayList<Integer> tr_notCovered_NoDominateSolutions() {
        int i;
        ArrayList<Integer> tr_not_marked = new ArrayList<Integer>();
        for (i = 0; i < this.nTrans; ++i) {
            tr_not_marked.add(i);
        }
        for (i = 0; i < this.EP.size(); ++i) {
            this.deleteTransCovered(this.EP.get(i), tr_not_marked);
        }
        return tr_not_marked;
    }

    private void updateEP(Chromosome child) {
        boolean add = true;
        for (int counter = 0; counter < this.EP.size(); ++counter) {
            Chromosome chromosome1 = this.EP.get(counter);
            int dominance = this.check_dominance(child, chromosome1);
            if (dominance == 1) {
                this.EP.remove(counter);
                continue;
            }
            if (dominance != -1) continue;
            add = false;
        }
        if (add && !this.equalChromotoPop(child, this.EP)) {
            this.EP.add(child);
        }
    }

    private ArrayList<Chromosome> nonDominateSelection(ArrayList<Chromosome> collection) {
        int counter = 1;
        ArrayList<Chromosome> result = new ArrayList<Chromosome>();
        result.add(collection.get(0));
        block0: while (counter < collection.size()) {
            Chromosome chromosome2 = collection.get(counter);
            int resultsize = result.size();
            boolean[] remove = new boolean[resultsize];
            for (int jj = 0; jj < resultsize; ++jj) {
                Chromosome chromosome1 = result.get(jj);
                int dominance = this.check_dominance(chromosome2, chromosome1);
                if (dominance == 1) {
                    remove[jj] = true;
                    continue;
                }
                if (dominance != -1) continue;
                ++counter;
                continue block0;
            }
            for (int i = remove.length - 1; i >= 0; --i) {
                if (!remove[i]) continue;
                result.remove(i);
            }
            result.add(chromosome2);
            ++counter;
        }
        return result;
    }

    private boolean equalChromotoPop(Chromosome chromo, ArrayList<Chromosome> pop) {
        boolean value = false;
        for (int i = 0; !value && i < pop.size(); ++i) {
            Chromosome aux = pop.get(i);
            if (!chromo.equals(aux)) continue;
            value = true;
        }
        return value;
    }

    private void selection() {
        this.child_pop.clear();
        while (this.child_pop.size() < this.uPopSize && this.trials < this.nTrials) {
            int dad = this.tournamentSelection();
            int mom = this.tournamentSelection();
            while (dad == mom) {
                mom = this.tournamentSelection();
            }
            this.crossover(this.uPop.get(dad), this.uPop.get(mom));
        }
    }

    private void crowding_fill(int count, int front_size, Lists elite) {
        int j;
        this.assign_crowding_distance_list(this.mixed_pop, elite.child, front_size);
        int[] dist = new int[front_size];
        Lists temp = elite.child;
        for (j = 0; j < front_size; ++j) {
            dist[j] = temp.index;
            temp = temp.child;
        }
        Sort.quicksort_dist(this.mixed_pop, dist, front_size);
        int i = count;
        j = front_size - 1;
        while (i < this.uPopSize) {
            this.uPop.add(this.mixed_pop.get(dist[j]).copy());
            ++i;
            --j;
        }
    }

    private void fill_nondominated_sort() {
        int i;
        int rank = 1;
        Lists pool = new Lists();
        Lists elite = new Lists();
        int front_size = 0;
        int archieve_size = 0;
        Lists temp1 = pool;
        this.uPop.clear();
        for (i = 0; i < this.mixed_pop.size(); ++i) {
            temp1.insert(temp1, i);
            temp1 = temp1.child;
        }
        i = 0;
        do {
            temp1 = pool.child;
            temp1.insert(elite, temp1.index);
            front_size = 1;
            Lists temp2 = elite.child;
            temp1 = temp1.del(temp1);
            temp1 = temp1.child;
            do {
                int flag;
                boolean end;
                temp2 = elite.child;
                if (temp1 == null) break;
                do {
                    end = false;
                    flag = this.check_dominance(this.mixed_pop.get(temp1.index), this.mixed_pop.get(temp2.index));
                    if (flag == 1) {
                        temp2.insert(pool, temp2.index);
                        temp2 = temp2.del(temp2);
                        --front_size;
                        temp2 = temp2.child;
                    }
                    if (flag == 0) {
                        temp2 = temp2.child;
                    }
                    if (flag != -1) continue;
                    end = true;
                } while (!end && temp2 != null);
                if (flag != 0 && flag != 1) continue;
                temp1.insert(elite, temp1.index);
                ++front_size;
                temp1 = temp1.del(temp1);
            } while ((temp1 = temp1.child) != null);
            temp2 = elite.child;
            int j = i;
            if (archieve_size + front_size <= this.uPopSize) {
                do {
                    if (temp2.index >= this.uPopSize) {
                        ++this.updatePop;
                    }
                    this.uPop.add(this.mixed_pop.get(temp2.index).copy());
                    this.uPop.get((int)i).rank = rank++;
                    ++archieve_size;
                    temp2 = temp2.child;
                    ++i;
                } while (temp2 != null);
                this.assign_crowding_distance_indices(this.uPop, j, i - 1);
            } else {
                this.crowding_fill(i, front_size, elite);
                archieve_size = this.uPopSize;
                for (j = i; j < this.uPopSize; ++j) {
                    this.uPop.get((int)j).rank = rank;
                }
            }
            temp2 = elite.child;
            do {
                temp2 = temp2.del(temp2);
                temp2 = temp2.child;
            } while (elite.child != null);
        } while (archieve_size < this.uPopSize);
    }

    private void assign_crowding_distance_indices(ArrayList<Chromosome> pop, int c1, int c2) {
        int front_size = c2 - c1 + 1;
        if (front_size == 1) {
            pop.get((int)c1).crowd_dist = INF;
            return;
        }
        if (front_size == 2) {
            pop.get((int)c1).crowd_dist = INF;
            pop.get((int)c2).crowd_dist = INF;
            return;
        }
        int[][] obj_array = new int[this.numObjectives][front_size];
        int[] dist = new int[front_size];
        for (int j = 0; j < front_size; ++j) {
            dist[j] = c1++;
        }
        this.assign_crowding_distance(pop, dist, obj_array, front_size);
    }

    private void crossover(Chromosome dad, Chromosome mom) {
        int i;
        Gene[] genesSon1 = new Gene[this.nAttr];
        Gene[] genesSon2 = new Gene[this.nAttr];
        for (i = 0; i < this.nAttr; ++i) {
            if (dad.getGene(i).getActAs() != 1 && mom.getGene(i).getActAs() != 1) continue;
            genesSon1[i] = dad.getGene(i).copy();
            genesSon2[i] = mom.getGene(i).copy();
        }
        for (i = 0; i < this.nAttr; ++i) {
            if (dad.getGene(i).getActAs() == 1 || mom.getGene(i).getActAs() == 1) continue;
            if (Randomize.Rand() < 0.5) {
                genesSon1[i] = dad.getGene(i).copy();
                genesSon2[i] = mom.getGene(i).copy();
                continue;
            }
            genesSon1[i] = mom.getGene(i).copy();
            genesSon2[i] = dad.getGene(i).copy();
        }
        Chromosome son1 = new Chromosome(genesSon1, this.numObjectives);
        Chromosome son2 = new Chromosome(genesSon2, this.numObjectives);
        if (Randomize.Rand() < this.pm) {
            this.mutate(son1);
        }
        if (Randomize.Rand() < this.pm) {
            this.mutate(son2);
        }
        son1.forceConsistency();
        son2.forceConsistency();
        son1.computeObjetives(this.dataset);
        son2.computeObjetives(this.dataset);
        this.trials += 2;
        if (!this.equalChromotoPop(son1, this.child_pop) && son1.getSupport() > this.minSupport && !(son1.getSupport() > 1.0 - this.minSupport) && son1.getCF() > 0.0) {
            this.child_pop.add(son1);
        }
        if (!this.equalChromotoPop(son2, this.child_pop) && son2.getSupport() > this.minSupport && !(son2.getSupport() > 1.0 - this.minSupport) && son2.getCF() > 0.0) {
            this.child_pop.add(son2);
        }
    }

    private void mutate(Chromosome chr) {
        int i = Randomize.Randint(0, this.nAttr);
        Gene gene = chr.getGene(i);
        double type_attr = this.dataset.getAttributeType(i);
        double min_attr = this.dataset.getMin(i);
        double max_attr = this.dataset.getMax(i);
        if (type_attr != 0.0) {
            if (type_attr == 2.0) {
                if (Randomize.Rand() < 0.5) {
                    if (Randomize.Rand() < 0.5) {
                        double top = Math.max(gene.getUpperBound() - this.dataset.getAmplitude(i) / this.af, min_attr);
                        gene.setLowerBound(Randomize.RanddoubleClosed(top, gene.getLowerBound()));
                    } else {
                        gene.setLowerBound(Randomize.Randdouble(gene.getLowerBound(), gene.getUpperBound()));
                    }
                } else if (Randomize.Rand() < 0.5) {
                    double top = Math.min(gene.getLowerBound() + this.dataset.getAmplitude(i) / this.af, max_attr);
                    gene.setUpperBound(Randomize.RanddoubleClosed(gene.getUpperBound(), top));
                } else {
                    gene.setUpperBound(Randomize.RanddoubleClosed(gene.getLowerBound() + 1.0E-4, gene.getUpperBound()));
                }
            } else if (Randomize.Rand() < 0.5) {
                if (Randomize.Rand() < 0.5) {
                    double top = Math.max(gene.getUpperBound() - this.dataset.getAmplitude(i) / this.af, min_attr);
                    gene.setLowerBound(Randomize.RandintClosed((int)top, (int)gene.getLowerBound()));
                } else {
                    gene.setLowerBound(Randomize.Randint((int)gene.getLowerBound(), (int)gene.getUpperBound()));
                }
            } else if (Randomize.Rand() < 0.5) {
                double top = Math.min(gene.getLowerBound() + this.dataset.getAmplitude(i) / this.af, max_attr);
                gene.setUpperBound(Randomize.RandintClosed((int)gene.getUpperBound(), (int)top));
            } else {
                gene.setUpperBound(Randomize.RandintClosed((int)gene.getLowerBound() + 1, (int)gene.getUpperBound()));
            }
        } else {
            double top = Randomize.RandintClosed((int)min_attr, (int)max_attr);
            gene.setLowerBound(top);
            gene.setUpperBound(top);
        }
        gene.setActAs(gene.randAct());
    }

    private int tournamentSelection() {
        int chromo1 = Randomize.Randint(0, this.uPop.size());
        int chromo2 = Randomize.Randint(0, this.uPop.size());
        while (chromo1 == chromo2) {
            chromo2 = Randomize.Randint(0, this.uPop.size());
        }
        if (this.uPop.get(chromo1).isBetter(this.uPop.get(chromo2)) >= 0) {
            return chromo1;
        }
        return chromo2;
    }

    private void merge() {
        int i;
        this.mixed_pop.clear();
        for (i = 0; i < this.uPop.size(); ++i) {
            if (this.equalChromotoPop(this.uPop.get(i), this.mixed_pop)) continue;
            this.mixed_pop.add(this.uPop.get(i).copy());
        }
        for (i = 0; i < this.child_pop.size(); ++i) {
            if (this.equalChromotoPop(this.child_pop.get(i), this.mixed_pop)) continue;
            this.mixed_pop.add(this.child_pop.get(i).copy());
        }
    }

    private int check_dominance(Chromosome a, Chromosome b) {
        boolean flag1 = false;
        boolean flag2 = false;
        for (int i = 0; i < this.numObjectives; ++i) {
            if (a.getObjective(i) > b.getObjective(i)) {
                flag1 = true;
                continue;
            }
            if (!(a.getObjective(i) < b.getObjective(i))) continue;
            flag2 = true;
        }
        if (flag1 && !flag2) {
            return 1;
        }
        if (!flag1 && flag2) {
            return -1;
        }
        return 0;
    }

    private void assign_rank_and_crowding_distance(ArrayList<Chromosome> new_pop) {
        int rank = 1;
        Lists orig = new Lists();
        Lists cur = new Lists();
        int front_size = 0;
        System.err.println("Tama\u00c3\u00b1a de new_pop = " + new_pop.size() + "   Tama\u00c3\u00b1o que deberia tener = " + this.uPopSize);
        Lists temp1 = orig;
        for (int i = 0; i < this.uPopSize; ++i) {
            temp1.insert(temp1, i);
            temp1 = temp1.child;
        }
        do {
            if (orig.child.child == null) {
                new_pop.get((int)orig.child.index).rank = rank;
                new_pop.get((int)orig.child.index).crowd_dist = INF;
                break;
            }
            temp1 = orig.child;
            temp1.insert(cur, temp1.index);
            front_size = 1;
            Lists temp2 = cur.child;
            temp1 = temp1.del(temp1);
            temp1 = temp1.child;
            do {
                int flag;
                boolean end;
                temp2 = cur.child;
                do {
                    end = false;
                    flag = this.check_dominance(new_pop.get(temp1.index), new_pop.get(temp2.index));
                    if (flag == 1) {
                        temp1.insert(orig, temp2.index);
                        temp2 = temp2.del(temp2);
                        --front_size;
                        temp2 = temp2.child;
                    }
                    if (flag == 0) {
                        temp2 = temp2.child;
                    }
                    if (flag != -1) continue;
                    end = true;
                } while (!end && temp2 != null);
                if (flag != 0 && flag != 1) continue;
                temp1.insert(cur, temp1.index);
                ++front_size;
                temp1 = temp1.del(temp1);
            } while ((temp1 = temp1.child) != null);
            temp2 = cur.child;
            do {
                new_pop.get((int)temp2.index).rank = rank;
            } while ((temp2 = temp2.child) != null);
            this.assign_crowding_distance_list(new_pop, cur.child, front_size);
            temp2 = cur.child;
            do {
                temp2 = temp2.del(temp2);
                temp2 = temp2.child;
            } while (cur.child != null);
            ++rank;
        } while (orig.child != null);
    }

    private void assign_crowding_distance(ArrayList<Chromosome> pop, int[] dist, int[][] obj_array, int front_size) {
        int j;
        int i;
        for (i = 0; i < this.numObjectives; ++i) {
            for (j = 0; j < front_size; ++j) {
                obj_array[i][j] = dist[j];
            }
            Sort.quicksort_front_obj(pop, i, obj_array[i], front_size);
        }
        for (j = 0; j < front_size; ++j) {
            pop.get((int)dist[j]).crowd_dist = 0.0;
        }
        for (i = 0; i < this.numObjectives; ++i) {
            pop.get((int)obj_array[i][0]).crowd_dist = INF;
            pop.get((int)obj_array[i][front_size - 1]).crowd_dist = INF;
        }
        for (i = 0; i < this.numObjectives; ++i) {
            for (j = 1; j < front_size - 1; ++j) {
                if (pop.get((int)obj_array[i][j]).crowd_dist == INF) continue;
                if (pop.get(obj_array[i][front_size - 1]).getObjective(i) == pop.get(obj_array[i][0]).getObjective(i)) {
                    pop.get((int)obj_array[i][j]).crowd_dist += 0.0;
                    continue;
                }
                pop.get((int)obj_array[i][j]).crowd_dist += (pop.get(obj_array[i][j + 1]).getObjective(i) - pop.get(obj_array[i][j - 1]).getObjective(i)) / (pop.get(obj_array[i][front_size - 1]).getObjective(i) - pop.get(obj_array[i][0]).getObjective(i));
            }
        }
        for (j = 0; j < front_size; ++j) {
            if (pop.get((int)dist[j]).crowd_dist == INF) continue;
            pop.get((int)dist[j]).crowd_dist /= (double)this.numObjectives;
        }
    }

    private void assign_crowding_distance_list(ArrayList<Chromosome> pop, Lists lst, int front_size) {
        Lists temp = lst;
        if (front_size == 1) {
            pop.get((int)lst.index).crowd_dist = INF;
            return;
        }
        if (front_size == 2) {
            pop.get((int)lst.index).crowd_dist = INF;
            pop.get((int)lst.child.index).crowd_dist = INF;
            return;
        }
        int[][] obj_array = new int[this.numObjectives][front_size];
        int[] dist = new int[front_size];
        for (int j = 0; j < front_size; ++j) {
            dist[j] = temp.index;
            temp = temp.child;
        }
        this.assign_crowding_distance(pop, dist, obj_array, front_size);
    }

    static double roundDouble(double number, int decimalPlace) {
        if (!Double.isInfinite(number) && !Double.isNaN(number)) {
            BigDecimal bd = new BigDecimal(number);
            bd = bd.setScale(decimalPlace, 0);
            double numberRound = bd.doubleValue();
            return numberRound;
        }
        return number;
    }

    public void saveReport(ArrayList<AssociationRule> rules, PrintWriter w) {
        int i;
        double avg_yulesQ = 0.0;
        double avg_sup = 0.0;
        double avg_conf = 0.0;
        double avg_ant_length = 0.0;
        double avg_lift = 0.0;
        double avg_conv = 0.0;
        double avg_CF = 0.0;
        double avg_netConf = 0.0;
        int[] covered = new int[this.nTrans];
        for (i = 0; i < this.nTrans; ++i) {
            covered[i] = 0;
        }
        for (int r = 0; r < rules.size(); ++r) {
            AssociationRule rule = rules.get(r);
            avg_sup += rule.getSupport();
            avg_conf += rule.getConfidence();
            avg_lift += rule.getLift();
            avg_ant_length += (double)(rule.getnAnts() + 1);
            avg_conv += rule.getConv();
            avg_CF += rule.getCF();
            avg_netConf += rule.getNetConf();
            avg_yulesQ += rule.getYulesQ();
            for (int j = 0; j < this.nTrans; ++j) {
                if (covered[j] >= 1 || !rule.isCovered(this.dataset.getExample(j))) continue;
                covered[j] = 1;
            }
        }
        int cnt_cov_rec = 0;
        for (i = 0; i < this.nTrans; ++i) {
            cnt_cov_rec += covered[i];
        }
        w.println("\nNumber of Frequent Itemsets found: -");
        System.out.println("\nNumber of Frequent Itemsets found: -");
        w.println("\nNumber of Association Rules generated: " + rules.size());
        System.out.println("Number of Association Rules generated: " + rules.size());
        if (!rules.isEmpty()) {
            w.println("Average Support: " + QAR_CIP_NSGAIIProcess.roundDouble(avg_sup / (double)rules.size(), 2));
            System.out.println("Average Support: " + QAR_CIP_NSGAIIProcess.roundDouble(avg_sup / (double)rules.size(), 2));
            w.println("Average Confidence: " + QAR_CIP_NSGAIIProcess.roundDouble(avg_conf / (double)rules.size(), 2));
            System.out.println("Average Confidence: " + QAR_CIP_NSGAIIProcess.roundDouble(avg_conf / (double)rules.size(), 2));
            w.println("Average Lift: " + QAR_CIP_NSGAIIProcess.roundDouble(avg_lift / (double)rules.size(), 2));
            System.out.println("Average Lift: " + QAR_CIP_NSGAIIProcess.roundDouble(avg_lift / (double)rules.size(), 2));
            w.println("Average Conviction: " + QAR_CIP_NSGAIIProcess.roundDouble(avg_conv / (double)rules.size(), 2));
            System.out.println("Average Conviction: " + QAR_CIP_NSGAIIProcess.roundDouble(avg_conv / (double)rules.size(), 2));
            w.println("Average Certain Factor: " + QAR_CIP_NSGAIIProcess.roundDouble(avg_CF / (double)rules.size(), 2));
            System.out.println("Average Certain Factor: " + QAR_CIP_NSGAIIProcess.roundDouble(avg_CF / (double)rules.size(), 2));
            w.println("Average Netconf: " + QAR_CIP_NSGAIIProcess.roundDouble(avg_netConf / (double)rules.size(), 2));
            System.out.println("Average Netconf: " + QAR_CIP_NSGAIIProcess.roundDouble(avg_netConf / (double)rules.size(), 2));
            w.println("Average yulesQ: " + QAR_CIP_NSGAIIProcess.roundDouble(avg_yulesQ / (double)rules.size(), 2));
            System.out.println("Average yulesQ: " + QAR_CIP_NSGAIIProcess.roundDouble(avg_yulesQ / (double)rules.size(), 2));
            w.println("Average Number of Antecedents: " + QAR_CIP_NSGAIIProcess.roundDouble(avg_ant_length / (double)rules.size(), 2));
            System.out.println("Average Number of Antecedents: " + QAR_CIP_NSGAIIProcess.roundDouble(avg_ant_length / (double)rules.size(), 2));
            w.println("Number of Covered Records (%): " + QAR_CIP_NSGAIIProcess.roundDouble(100.0 * (double)cnt_cov_rec / (double)this.nTrans, 2));
            System.out.println("Number of Covered Records (%): " + QAR_CIP_NSGAIIProcess.roundDouble(100.0 * (double)cnt_cov_rec / (double)this.nTrans, 2));
        }
    }

    public void removeRedundant(ArrayList<Chromosome> upop) {
        Collections.sort(upop);
        for (int i = 0; i < upop.size(); ++i) {
            boolean stop = false;
            for (int j = upop.size() - 1; j >= 0 && !stop; --j) {
                if (j == i) continue;
                Chromosome chromo1 = upop.get(i);
                Chromosome chromo2 = upop.get(j);
                if (chromo1.getnAnts() == chromo2.getnAnts()) {
                    if (!chromo1.isSubChromo(chromo2)) continue;
                    if (chromo1.getCF() >= chromo2.getCF()) {
                        upop.remove(j);
                        if (j >= i) continue;
                        --i;
                        continue;
                    }
                    upop.remove(i);
                    --i;
                    stop = true;
                    continue;
                }
                if (chromo1.getnAnts() <= chromo2.getnAnts()) continue;
                stop = true;
            }
        }
    }

    public void printPareto() {
        boolean stop = false;
        this.paretos = this.paretos + "Support\tantecedent_support\tconsequent_support\tConfidence\tLift\tConv\tCF\tNetConf\tYulesQ\tnAttributes\n";
        for (int i = 0; i < this.EP.size() && !stop; ++i) {
            Chromosome chromo = this.EP.get(i);
            this.paretos = this.paretos + "" + QAR_CIP_NSGAIIProcess.roundDouble(chromo.getSupport(), 2) + "\t" + QAR_CIP_NSGAIIProcess.roundDouble(chromo.getAntsSupport(), 2) + "\t" + QAR_CIP_NSGAIIProcess.roundDouble(chromo.getConsSupport(), 2) + "\t" + QAR_CIP_NSGAIIProcess.roundDouble(chromo.getConfidence(), 2) + "\t" + QAR_CIP_NSGAIIProcess.roundDouble(chromo.getObjective(0), 2) + "\t" + QAR_CIP_NSGAIIProcess.roundDouble(chromo.getConv(), 2) + "\t" + QAR_CIP_NSGAIIProcess.roundDouble(chromo.getCF(), 2) + "\t" + QAR_CIP_NSGAIIProcess.roundDouble(chromo.getNetConf(), 2) + "\t" + QAR_CIP_NSGAIIProcess.roundDouble(chromo.getYulesQ(), 2) + "\t" + (chromo.getnAnts() + 1) + "\n";
        }
    }

    public ArrayList<AssociationRule> generateRulesPareto() {
        ArrayList<AssociationRule> rulesPareto = new ArrayList<AssociationRule>();
        boolean stop = false;
        for (int i = 0; i < this.EP.size() && !stop; ++i) {
            Chromosome chromo = this.EP.get(i);
            rulesPareto.add(new AssociationRule(chromo));
        }
        return rulesPareto;
    }

    public String getParetos() {
        return this.paretos;
    }
}

