/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jclec;

import java.util.ArrayList;
import net.sf.jclec.AlgorithmEvent;
import net.sf.jclec.IAlgorithm;
import net.sf.jclec.IAlgorithmListener;
import net.sf.jclec.IConfigure;
import net.sf.jclec.JCLEC;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationRuntimeException;
import org.apache.commons.lang.builder.EqualsBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AlgorithmRunner<A extends IAlgorithm>
implements JCLEC,
IConfigure,
Runnable {
    private static final long serialVersionUID = -7172908869875803766L;
    protected A algorithm;
    protected ArrayList<IAlgorithmListener<A>> listeners = new ArrayList();

    @Override
    public void run() {
        this.algorithm.doInit();
        this.fireAlgorithmStarted();
        while (!this.algorithm.isFinished()) {
            this.algorithm.doIterate();
            this.fireIterationCompleted();
        }
        this.fireAlgorithmFinished();
    }

    public final A getAlgorithm() {
        return this.algorithm;
    }

    public final void setAlgorithm(A algorithm) {
        this.algorithm = algorithm;
    }

    public void addListener(IAlgorithmListener<A> listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IAlgorithmListener<A> listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void configure(Configuration settings) {
        try {
            String algorithmClassname = settings.getString("algorithm[@type]");
            Class<?> algorithmClass = Class.forName(algorithmClassname);
            IAlgorithm algorithm = (IAlgorithm)algorithmClass.newInstance();
            if (algorithm instanceof IConfigure) {
                ((IConfigure)((Object)algorithm)).configure(settings.subset("algorithm"));
            }
            this.setAlgorithm(algorithm);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationRuntimeException("Illegal algorithm classname");
        }
        catch (InstantiationException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of algorithm", e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of algorithm", e);
        }
        int numberOfListeners = settings.getList("listeners.listener[@type]").size();
        int i = 0;
        while (i < numberOfListeners) {
            String header = "listeners.listener(" + i + ")";
            try {
                String listenerClassname = settings.getString(String.valueOf(header) + "[@type]");
                Class<?> listenerClass = Class.forName(listenerClassname);
                IAlgorithmListener listener = (IAlgorithmListener)listenerClass.newInstance();
                if (listener instanceof IConfigure) {
                    ((IConfigure)((Object)listener)).configure(settings.subset(header));
                }
                this.addListener(listener);
            }
            catch (ClassNotFoundException e) {
                throw new ConfigurationRuntimeException("Illegal listener classname");
            }
            catch (InstantiationException e) {
                throw new ConfigurationRuntimeException("Problems creating an instance of listener", e);
            }
            catch (IllegalAccessException e) {
                throw new ConfigurationRuntimeException("Problems creating an instance of listeners", e);
            }
            ++i;
        }
    }

    public boolean equals(Object other) {
        if (other instanceof AlgorithmRunner) {
            AlgorithmRunner cother = (AlgorithmRunner)other;
            EqualsBuilder eb = new EqualsBuilder();
            eb.append(this.algorithm, cother.algorithm);
            ArrayList<IAlgorithmListener<A>> co_listeners = cother.listeners;
            int nofListeners = co_listeners.size();
            if (this.listeners.size() == nofListeners) {
                int i = 0;
                while (i < nofListeners) {
                    eb.append(this.listeners.get(i), co_listeners.get(i));
                    ++i;
                }
                return eb.isEquals();
            }
            return false;
        }
        return false;
    }

    private final void fireAlgorithmStarted() {
        AlgorithmEvent<A> event = new AlgorithmEvent<A>(this.algorithm);
        for (IAlgorithmListener<A> listener : this.listeners) {
            listener.algorithmStarted(event);
        }
    }

    private final void fireIterationCompleted() {
        AlgorithmEvent<A> event = new AlgorithmEvent<A>(this.algorithm);
        for (IAlgorithmListener<A> listener : this.listeners) {
            listener.iterationCompleted(event);
        }
    }

    private final void fireAlgorithmFinished() {
        AlgorithmEvent<A> event = new AlgorithmEvent<A>(this.algorithm);
        for (IAlgorithmListener<A> listener : this.listeners) {
            listener.algorithmFinished(event);
        }
    }
}

