/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.intarray.rec;

import net.sourceforge.jclec.intarray.IntArrayIndividual;
import net.sourceforge.jclec.intarray.IntArrayRecombinator;

public class TwoPointsCrossover
extends IntArrayRecombinator {
    private static final long serialVersionUID = 3835150645048325173L;

    public boolean equals(Object other) {
        return other instanceof TwoPointsCrossover;
    }

    @Override
    protected void recombineNext() {
        int gl = this.species.getGenotypeLength();
        int[] p0_genome = (int[])((IntArrayIndividual)this.parentsBuffer.get(this.parentsCounter)).getGenotype();
        int[] p1_genome = (int[])((IntArrayIndividual)this.parentsBuffer.get(this.parentsCounter + 1)).getGenotype();
        int[] s0_genome = new int[gl];
        int[] s1_genome = new int[gl];
        int cp1 = this.randgen.choose(0, gl - 1);
        int cp2 = this.randgen.choose(cp1, gl);
        System.arraycopy(p0_genome, 0, s0_genome, 0, cp1);
        System.arraycopy(p1_genome, cp1, s0_genome, cp1, cp2 - cp1);
        System.arraycopy(p0_genome, cp2, s0_genome, cp2, gl - cp2);
        System.arraycopy(p1_genome, 0, s1_genome, 0, cp1);
        System.arraycopy(p0_genome, cp1, s1_genome, cp1, cp2 - cp1);
        System.arraycopy(p1_genome, cp2, s1_genome, cp2, gl - cp2);
        this.sonsBuffer.add(this.species.createIndividual(s0_genome));
        this.sonsBuffer.add(this.species.createIndividual(s1_genome));
    }
}

