/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.problem.classification.stefano;

import java.util.List;
import net.sourceforge.jclec.problem.classification.Classifier;
import net.sourceforge.jclec.problem.classification.IClassificationRule;
import net.sourceforge.jclec.util.dataset.DatasetException;
import net.sourceforge.jclec.util.dataset.IDataset;

public class StefanoClassifier
extends Classifier {
    private static final long serialVersionUID = -6792167360656990171L;

    public StefanoClassifier(List<IClassificationRule> list, double defaultC) {
        super(list, defaultC);
    }

    @Override
    public double[] classify(IDataset data) {
        try {
            data.reset();
            int numInstances = data.numberOfInstances();
            int numRules = this.getClassificationRules().size();
            double[] result = new double[numInstances];
            boolean covered = false;
            IDataset.IInstance[] instances = new IDataset.IInstance[numInstances];
            data.reset();
            int i = 0;
            while (i < numInstances) {
                data.next();
                instances[i] = data.read().copy();
                ++i;
            }
            i = 0;
            while (i < numInstances) {
                int j = 0;
                while (j < numRules) {
                    if (this.getClassificationRule(j).covers(instances[i])) {
                        int k = 0;
                        while (k < this.getClassificationRule(j).getConsequents().length) {
                            if (this.getClassificationRule(j).getConsequents()[k] == instances[i].getValue(data.getMetadata().getClassIndex())) {
                                result[i] = this.getClassificationRule(j).getConsequents()[k];
                                covered = true;
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
                if (!covered) {
                    result[i] = this.getDefaultClass();
                }
                covered = false;
                ++i;
            }
            return result;
        }
        catch (DatasetException e) {
            e.printStackTrace();
            return null;
        }
    }
}

