/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.syntaxtree.mut;

import net.sourceforge.jclec.syntaxtree.IMutateSyntaxTree;
import net.sourceforge.jclec.syntaxtree.NonTerminalNode;
import net.sourceforge.jclec.syntaxtree.SyntaxTree;
import net.sourceforge.jclec.syntaxtree.SyntaxTreeSchema;
import net.sourceforge.jclec.util.random.IRandGen;

public class ReduceNTMutator
implements IMutateSyntaxTree {
    private static final long serialVersionUID = -2706522794304044852L;

    public boolean equals(Object other) {
        return other instanceof ReduceNTMutator;
    }

    @Override
    public SyntaxTree mutateSyntaxTree(SyntaxTree parent, SyntaxTreeSchema schema, IRandGen randgen) {
        SyntaxTree son = new SyntaxTree();
        int p0_branchStart = this.selectSymbol(parent, schema, randgen);
        if (p0_branchStart == -1) {
            int i = 0;
            while (i < parent.size()) {
                son.addNode(parent.getNode(i).copy());
                ++i;
            }
            return son;
        }
        NonTerminalNode selectedSymbol = (NonTerminalNode)parent.getNode(p0_branchStart);
        int p0_branchEnd = parent.subTree(p0_branchStart);
        int i = 0;
        while (i < p0_branchStart) {
            son.addNode(parent.getNode(i).copy());
            ++i;
        }
        schema.fillSyntaxBranch(son, selectedSymbol.getSymbol(), randgen);
        int j = p0_branchEnd;
        while (j < parent.size()) {
            son.addNode(parent.getNode(j).copy());
            ++j;
        }
        if (son.derivSize() > schema.getMaxDerivSize()) {
            son.clear();
            i = 0;
            while (i < parent.size()) {
                son.addNode(parent.getNode(i).copy());
                ++i;
            }
        }
        return son;
    }

    private final int selectSymbol(SyntaxTree tree, SyntaxTreeSchema schema, IRandGen randgen) {
        int startPos;
        int treeLength = tree.size();
        int actPos = startPos = randgen.choose(0, treeLength);
        int i = 0;
        while (i < treeLength) {
            actPos = (startPos + i) % treeLength;
            if (!schema.isTerminal(tree.getNode(actPos).getSymbol())) {
                return actPos;
            }
            ++i;
        }
        return -1;
    }
}

