/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.FPgrowth;

import java.util.ArrayList;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.FPgrowth.AssociationRule;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.FPgrowth.LUCS_KDD.FPtree;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.FPgrowth.myDataset;

public class FPgrowthProcess {
    private double minSupport;
    private double minConfidence;
    private myDataset dataset;
    private FPtree newFPtree;

    public FPgrowthProcess(myDataset dataset, double minSupport, double minConfidence) {
        this.minSupport = minSupport;
        this.minConfidence = minConfidence;
        this.dataset = dataset;
    }

    public void run() {
        this.newFPtree = new FPtree(this.dataset, this.minSupport, this.minConfidence);
        this.newFPtree.idInputDataOrdering();
        this.newFPtree.recastInputDataAndPruneUnsupportedAtts();
        this.newFPtree.setNumOneItemSets();
        this.newFPtree.createFPtree();
        this.newFPtree.startMining();
    }

    public ArrayList<AssociationRule> generateRulesSet() {
        return this.newFPtree.getRulesSet();
    }

    public void printReport(ArrayList<AssociationRule> rules) {
        double avg_sup = 0.0;
        double avg_conf = 0.0;
        double avg_ant_length = 0.0;
        for (int r = 0; r < rules.size(); ++r) {
            AssociationRule ar = rules.get(r);
            avg_sup += ar.getRuleSupport();
            avg_conf += ar.getConfidence();
            avg_ant_length += (double)ar.getAntecedent().length;
        }
        System.out.println("\nNumber of Frequent Itemsets found: " + this.newFPtree.getNumFreqSets());
        System.out.println("Number of Association Rules generated: " + rules.size());
        if (!rules.isEmpty()) {
            System.out.println("Average Support: " + avg_sup / (double)rules.size());
            System.out.println("Average Confidence: " + avg_conf / (double)rules.size());
            System.out.println("Average Antecedents Length: " + avg_ant_length / (double)rules.size());
            System.out.println("Number of Covered Records (%): " + 100.0 * (double)this.newFPtree.getCoveredRecords().size() / (double)this.dataset.getnTrans());
        }
    }
}

