/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.integer;

import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.integer.AbstractLargeIntSConstraint;
import choco.kernel.solver.propagation.event.ConstraintEvent;
import choco.kernel.solver.variables.integer.IntDomainVar;

public final class InverseChanneling
extends AbstractLargeIntSConstraint {
    protected int n;
    private int min = Integer.MAX_VALUE;

    public InverseChanneling(IntDomainVar[] allVars, int n) {
        super(ConstraintEvent.LINEAR, allVars);
        for (IntDomainVar var : allVars) {
            this.min = Math.min(var.getInf(), this.min);
        }
        this.n = n;
    }

    @Override
    public int getFilteredEventMask(int idx) {
        if (((IntDomainVar[])this.vars)[idx].hasEnumeratedDomain()) {
            return 12;
        }
        return 11;
    }

    @Override
    public void propagate() throws ContradictionException {
        int j;
        int i;
        int idx;
        for (idx = 0; idx < this.n; ++idx) {
            ((IntDomainVar[])this.vars)[idx].updateInf(this.min, this, false);
            ((IntDomainVar[])this.vars)[idx].updateSup(this.n + this.min - 1, this, false);
            if (((IntDomainVar[])this.vars)[idx].hasEnumeratedDomain()) {
                for (i = 0; i < this.n; ++i) {
                    if (((IntDomainVar[])this.vars)[idx].canBeInstantiatedTo(i + this.min)) continue;
                    ((IntDomainVar[])this.vars)[i + this.n].removeVal(idx + this.min, this, false);
                }
                continue;
            }
            for (i = 0; !(i >= this.n || ((IntDomainVar[])this.vars)[idx].canBeInstantiatedTo(i + this.min) || ((IntDomainVar[])this.vars)[i + this.n].canBeInstantiatedTo(idx + this.min) && !((IntDomainVar[])this.vars)[i + this.n].removeVal(idx + this.min, this, false)); ++i) {
            }
            for (j = this.n - 1; !(j <= 0 || ((IntDomainVar[])this.vars)[idx].canBeInstantiatedTo(j + this.min) || ((IntDomainVar[])this.vars)[j + this.n].canBeInstantiatedTo(idx + this.min) && !((IntDomainVar[])this.vars)[j + this.n].removeVal(idx + this.min, this, false)); --j) {
            }
        }
        for (idx = this.n; idx < ((IntDomainVar[])this.vars).length; ++idx) {
            ((IntDomainVar[])this.vars)[idx].updateInf(this.min, this, false);
            ((IntDomainVar[])this.vars)[idx].updateSup(this.n + this.min - 1, this, false);
            if (((IntDomainVar[])this.vars)[idx].hasEnumeratedDomain()) {
                for (i = 0; i < this.n; ++i) {
                    if (((IntDomainVar[])this.vars)[idx].canBeInstantiatedTo(i + this.min)) continue;
                    ((IntDomainVar[])this.vars)[i].removeVal(idx - this.n + this.min, this, false);
                }
                continue;
            }
            for (i = 0; !(i >= this.n || ((IntDomainVar[])this.vars)[idx].canBeInstantiatedTo(i + this.min) || ((IntDomainVar[])this.vars)[i].canBeInstantiatedTo(idx + this.min) && !((IntDomainVar[])this.vars)[i].removeVal(idx - this.n + this.min, this, false)); ++i) {
            }
            for (j = this.n - 1; !(j <= 0 || ((IntDomainVar[])this.vars)[idx].canBeInstantiatedTo(j + this.min) || ((IntDomainVar[])this.vars)[j].canBeInstantiatedTo(idx + this.min) && !((IntDomainVar[])this.vars)[j].removeVal(idx - this.n + this.min, this, false)); --j) {
            }
        }
    }

    @Override
    public void awakeOnInf(int idx) throws ContradictionException {
        int val = ((IntDomainVar[])this.vars)[idx].getInf() - this.min;
        if (idx < this.n) {
            for (int i = 0; i < val; ++i) {
                ((IntDomainVar[])this.vars)[i + this.n].removeVal(idx + this.min, this, false);
            }
        } else {
            for (int i = 0; i < val; ++i) {
                ((IntDomainVar[])this.vars)[i].removeVal(idx - this.n + this.min, this, false);
            }
        }
    }

    @Override
    public void awakeOnSup(int idx) throws ContradictionException {
        int val = ((IntDomainVar[])this.vars)[idx].getSup() + 1 - this.min;
        if (idx < this.n) {
            for (int i = val; i < this.n; ++i) {
                ((IntDomainVar[])this.vars)[i + this.n].removeVal(idx + this.min, this, false);
            }
        } else {
            for (int i = val; i < this.n; ++i) {
                ((IntDomainVar[])this.vars)[i].removeVal(idx - this.n + this.min, this, false);
            }
        }
    }

    @Override
    public void awakeOnInst(int idx) throws ContradictionException {
        int val = ((IntDomainVar[])this.vars)[idx].getVal() - this.min;
        if (idx < this.n) {
            ((IntDomainVar[])this.vars)[val + this.n].instantiate(idx + this.min, this, false);
            for (int i = 0; i < this.n; ++i) {
                if (i == idx) continue;
                ((IntDomainVar[])this.vars)[i].removeVal(val + this.min, this, false);
            }
        } else {
            ((IntDomainVar[])this.vars)[val].instantiate(idx - this.n + this.min, this, false);
            for (int i = this.n; i < 2 * this.n; ++i) {
                if (i == idx) continue;
                ((IntDomainVar[])this.vars)[i].removeVal(val + this.min, this, false);
            }
        }
    }

    @Override
    public void awakeOnRem(int idx, int x) throws ContradictionException {
        if (idx < this.n) {
            if (x - this.min < this.n) {
                ((IntDomainVar[])this.vars)[x - this.min + this.n].removeVal(idx + this.min, this, false);
            }
        } else {
            ((IntDomainVar[])this.vars)[x - this.min].removeVal(idx - this.n + this.min, this, false);
        }
    }

    @Override
    public boolean isSatisfied(int[] tuple) {
        for (int i = 0; i < this.n; ++i) {
            int x = tuple[i];
            if (tuple[x - this.min + this.n] == i + this.min) continue;
            return false;
        }
        return true;
    }

    @Override
    public String pretty() {
        IntDomainVar var;
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("InverseChanneling({");
        for (i = 0; i < this.n; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            var = ((IntDomainVar[])this.vars)[i];
            sb.append(var.pretty());
        }
        sb.append("}, {");
        for (i = 0; i < this.n; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            var = ((IntDomainVar[])this.vars)[this.n + i];
            sb.append(var.pretty());
        }
        sb.append("})");
        return sb.toString();
    }
}

