/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml.neural_network;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Version;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.RealNumberAdapter;
import org.dmg.pmml.neural_network.Connection;
import org.dmg.pmml.neural_network.NeuralEntity;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.Property;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name="Neuron", namespace="http://www.dmg.org/PMML-4_4")
@XmlType(name="", propOrder={"extensions", "connections"})
@JsonRootName(value="Neuron")
@JsonPropertyOrder(value={"id", "bias", "width", "altitude", "extensions", "connections"})
public class Neuron
extends NeuralEntity
implements HasExtensions<Neuron> {
    @XmlAttribute(name="id", required=true)
    @JsonProperty(value="id")
    private String id;
    @XmlAttribute(name="bias")
    @XmlJavaTypeAdapter(value=RealNumberAdapter.class)
    @JsonProperty(value="bias")
    private Number bias;
    @XmlAttribute(name="width")
    @XmlJavaTypeAdapter(value=RealNumberAdapter.class)
    @JsonProperty(value="width")
    private Number width;
    @XmlAttribute(name="altitude")
    @XmlJavaTypeAdapter(value=RealNumberAdapter.class)
    @Added(value=Version.PMML_3_2)
    @JsonProperty(value="altitude")
    private Number altitude;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Extension")
    private List<Extension> extensions;
    @XmlElement(name="Con", namespace="http://www.dmg.org/PMML-4_4", required=true)
    @JsonProperty(value="Con")
    private List<Connection> connections;
    private static final long serialVersionUID = 67371266L;

    public Neuron() {
    }

    @ValueConstructor
    public Neuron(@Property(value="id") String id, @Property(value="connections") List<Connection> connections) {
        this.id = id;
        this.connections = connections;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Neuron setId(@Property(value="id") String id) {
        this.id = id;
        return this;
    }

    public Number getBias() {
        return this.bias;
    }

    public Neuron setBias(@Property(value="bias") Number bias) {
        this.bias = bias;
        return this;
    }

    public Number getWidth() {
        return this.width;
    }

    public Neuron setWidth(@Property(value="width") Number width) {
        this.width = width;
        return this;
    }

    public Number getAltitude() {
        return this.altitude;
    }

    public Neuron setAltitude(@Property(value="altitude") Number altitude) {
        this.altitude = altitude;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public Neuron addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasConnections() {
        return this.connections != null && this.connections.size() > 0;
    }

    public List<Connection> getConnections() {
        if (this.connections == null) {
            this.connections = new ArrayList<Connection>();
        }
        return this.connections;
    }

    public Neuron addConnections(Connection ... connections) {
        this.getConnections().addAll(Arrays.asList(connections));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE && this.hasConnections()) {
                status = PMMLObject.traverse(visitor, this.getConnections());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

