/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter;

import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import java.util.List;
import org.dmg.pmml.Array;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.SimplePredicate;
import org.dmg.pmml.SimpleSetPredicate;
import org.jpmml.converter.Feature;
import org.jpmml.converter.InternableSimplePredicate;
import org.jpmml.converter.InternableSimpleSetPredicate;
import org.jpmml.converter.PMMLUtil;

public class PredicateManager {
    private Interner<Predicate> interner = Interners.newStrongInterner();

    public Predicate createPredicate(Feature feature, List<?> values) {
        if (values.size() == 1) {
            Object value = values.get(0);
            return this.createSimplePredicate(feature, SimplePredicate.Operator.EQUAL, value);
        }
        return this.createSimpleSetPredicate(feature, SimpleSetPredicate.BooleanOperator.IS_IN, values);
    }

    public Predicate createSimplePredicate(Feature feature, SimplePredicate.Operator operator, Object value) {
        InternableSimplePredicate predicate = new InternableSimplePredicate(feature.getName(), operator, value);
        return this.intern((Predicate)predicate);
    }

    public Predicate createSimpleSetPredicate(Feature feature, SimpleSetPredicate.BooleanOperator booleanOperator, List<?> values) {
        Array array = PredicateManager.createArray(feature.getDataType(), values);
        InternableSimpleSetPredicate predicate = new InternableSimpleSetPredicate(feature.getName(), booleanOperator, array);
        return this.intern((Predicate)predicate);
    }

    public Predicate intern(Predicate predicate) {
        return (Predicate)this.interner.intern((Object)predicate);
    }

    private static Array createArray(DataType dataType, List<?> values) {
        switch (dataType) {
            case STRING: {
                return PMMLUtil.createStringArray(values);
            }
            case INTEGER: {
                return PMMLUtil.createIntArray(values);
            }
            case DOUBLE: 
            case FLOAT: {
                return PMMLUtil.createRealArray(values);
            }
        }
        throw new IllegalArgumentException();
    }
}

