/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.subgroup.search;

import org.vikamine.kernel.subgroup.search.BSD;
import org.vikamine.kernel.subgroup.search.SDBeamSearch;
import org.vikamine.kernel.subgroup.search.SDMap;
import org.vikamine.kernel.subgroup.search.SDMethod;

public final class SDMethodFactory {
    private SDMethodFactory() {
    }

    public static SDBeamSearch createSDBeamSearch() {
        return new SDBeamSearch();
    }

    public static SDMethod createSDMap() {
        return new SDMap();
    }

    public static SDMethod createBSD() {
        return new BSD();
    }

    public static final SDMethod createSDMethod(CommonSDMethodType name) {
        switch (name) {
            case SDMAP: {
                return SDMethodFactory.createSDMap();
            }
            case BSD: {
                return SDMethodFactory.createBSD();
            }
            case BEAM_SEARCH: {
                return SDMethodFactory.createSDBeamSearch();
            }
        }
        throw new IllegalArgumentException("Impossible to reach: not a common SD_METHOD");
    }

    public static enum CommonSDMethodType {
        BEAM_SEARCH,
        SDMAP,
        BSD;

    }
}

