/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel._examples;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.vikamine.kernel.data.Attribute;
import org.vikamine.kernel.data.Ontology;
import org.vikamine.kernel.data.creators.DataFactory;
import org.vikamine.kernel.subgroup.SG;
import org.vikamine.kernel.subgroup.SGSet;
import org.vikamine.kernel.subgroup.quality.functions.PiatetskyShapiroQF;
import org.vikamine.kernel.subgroup.search.SDMap;
import org.vikamine.kernel.subgroup.search.SDSimpleTask;
import org.vikamine.kernel.subgroup.target.NumericTarget;

public class SDSimpleTaskRunnerExampleNumericSelectorTest {
    private SDSimpleTaskRunnerExampleNumericSelectorTest() {
    }

    public static void main(String[] args) throws IOException {
        Ontology onto = DataFactory.createOntology(new File("/Users/mat/Downloads/ResilientAthletes-Analysis/postHolidayModels-20200121/output_2021/data_with_predictions/predictions_with_xcols_lag_00.csv"));
        System.out.println("Attributes in dataset: " + onto.getNumAttributes());
        System.out.println("Instances in dataset: " + onto.getNumInstances());
        SDSimpleTask task = new SDSimpleTask(onto);
        task.setTarget(new NumericTarget(onto, "PREDICTED_prob_lag_00_RF_optimized_class2"));
        ArrayList<String> attributeIDList = new ArrayList<String>();
        int i = 0;
        for (Attribute a : onto.getAttributes()) {
            attributeIDList.add(a.getId());
            if (++i > 20) break;
        }
        String[] attributeIDS = new String[]{};
        task.setIgnoreDefaultValues(false);
        task.setAttributes(attributeIDList.toArray(attributeIDS), true, 3);
        task.setQualityFunction(new PiatetskyShapiroQF());
        task.setMethodType(SDMap.class);
        task.setMaxSGDSize(2);
        task.setMaxSGCount(20);
        SGSet result = task.performSubgroupDiscovery();
        for (SG sg : result.toSortedList(false)) {
            System.out.println(sg.getSGDescription() + " - " + sg.getStatistics().getSubgroupSize() + "(" + sg.getStatistics().getDeviation() + ")");
        }
    }
}

