/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.data.discretization;

import org.vikamine.kernel.data.DataRecord;
import org.vikamine.kernel.data.discretization.AbstractDiscretizationMethod;
import org.vikamine.kernel.subgroup.search.InvalidTargetException;
import org.vikamine.kernel.subgroup.target.BooleanTarget;
import org.vikamine.kernel.subgroup.target.SGTarget;

public abstract class AbstractSupervisedDiscretizationMethod
extends AbstractDiscretizationMethod {
    protected SGTarget target;

    public AbstractSupervisedDiscretizationMethod(SGTarget target) {
        this.target = target;
    }

    public AbstractSupervisedDiscretizationMethod() {
    }

    @Override
    public void setTarget(SGTarget target) {
        this.target = target;
    }

    boolean check() {
        if (this.target == null || !this.target.isBoolean()) {
            throw new InvalidTargetException(this.target, String.valueOf(this.getName()) + " can only use Boolean target!");
        }
        return this.population != null && this.attribute != null && this.population.dataset().getIndex(this.attribute) >= 0 && this.population.size() >= 2;
    }

    abstract class Initializer {
        private final BooleanTarget target;
        private int index;
        private DataRecord currentRecord;
        private DataRecord prevRecord;
        private int saveIndex;
        int sumNegatives;
        int sumPositives;
        private int saveSumPositives;
        private int saveSumNegatives;
        private boolean biClassBlock;
        private int count;

        Initializer(BooleanTarget target) {
            this.target = target;
            this.index = 0;
            this.saveIndex = -1;
            this.nextRecord();
            this.updateSum();
            this.count = 1;
        }

        void initialize() {
            while (this.hasNext()) {
                this.nextRecord();
                if (this.valueGrown()) {
                    if (this.classStayed() && !this.biClassBlock) {
                        this.savePrevRecord();
                    } else {
                        this.createNewBlock();
                        this.reset();
                    }
                } else if (!this.classStayed()) {
                    if (this.hasSavedRecord()) {
                        this.restoreSavedRecord();
                        this.createNewBlock();
                        this.reset();
                    } else {
                        this.biClassBlock = true;
                    }
                }
                this.updateSum();
            }
            this.finish();
        }

        int getCount() {
            return this.count;
        }

        private void reset() {
            this.biClassBlock = false;
            this.saveIndex = -1;
            ++this.count;
        }

        abstract void finish();

        abstract void createNewBlock();

        private boolean hasNext() {
            return this.index < AbstractSupervisedDiscretizationMethod.this.sortedSample.size();
        }

        private void nextRecord() {
            this.prevRecord = this.currentRecord;
            this.currentRecord = (DataRecord)AbstractSupervisedDiscretizationMethod.this.sortedSample.get(this.index++);
        }

        double getValue() {
            return this.currentRecord.getValue(AbstractSupervisedDiscretizationMethod.this.attribute);
        }

        double getPrevValue() {
            return this.prevRecord.getValue(AbstractSupervisedDiscretizationMethod.this.attribute);
        }

        private boolean valueGrown() {
            return this.currentRecord.getValue(AbstractSupervisedDiscretizationMethod.this.attribute) > this.prevRecord.getValue(AbstractSupervisedDiscretizationMethod.this.attribute);
        }

        private boolean classStayed() {
            return this.target.isPositive(this.currentRecord) == this.target.isPositive(this.prevRecord);
        }

        private void savePrevRecord() {
            this.saveIndex = this.index - 2;
            this.saveSumNegatives = this.sumNegatives;
            this.saveSumPositives = this.sumPositives;
        }

        private boolean hasSavedRecord() {
            return this.saveIndex >= 0;
        }

        private void restoreSavedRecord() {
            this.index = this.saveIndex;
            this.sumNegatives = this.saveSumNegatives;
            this.sumPositives = this.saveSumPositives;
            this.currentRecord = (DataRecord)AbstractSupervisedDiscretizationMethod.this.sortedSample.get(this.index++);
            this.nextRecord();
        }

        private void updateSum() {
            if (this.target.isPositive(this.currentRecord)) {
                ++this.sumPositives;
            } else {
                ++this.sumNegatives;
            }
        }

        void resetSum() {
            this.sumPositives = 0;
            this.sumNegatives = 0;
        }
    }
}

