/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.subgroup.quality.functions;

import org.vikamine.kernel.subgroup.SG;
import org.vikamine.kernel.subgroup.quality.AbstractQFSimpleStatisticBased;

public class VarianceReductionQF
extends AbstractQFSimpleStatisticBased {
    private static final String ID = "VarianceReductionQF";

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public String getName() {
        return this.getID();
    }

    @Override
    public boolean isApplicable(SG subgroup) {
        return subgroup.getTarget().isNumeric();
    }

    @Override
    public double evaluateNum(double subgroupSize, double sgMean, double definedPopulationCount, double populationMean) {
        if (subgroupSize == 0.0 || subgroupSize == definedPopulationCount) {
            return 0.0;
        }
        double diff = sgMean - populationMean;
        double complementSize = definedPopulationCount - subgroupSize;
        return diff * diff * subgroupSize / complementSize;
    }

    @Override
    public VarianceReductionQF clone() {
        return new VarianceReductionQF();
    }

    @Override
    public double evaluateBin(double subgroupSize, double subgroupPositives, double definedPopulationCount, double populationPositives) {
        return Double.NaN;
    }
}

