/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.continuous;

import dr.evolution.tree.MutableTreeModel;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.TreeUtils;
import dr.evomodel.branchratemodel.BranchRateModel;
import dr.evomodel.continuous.GibbsSampleFromTreeInterface;
import dr.evomodel.continuous.IntegratedMultivariateTraitLikelihood;
import dr.evomodel.continuous.MultivariateDiffusionModel;
import dr.evomodel.continuous.RestrictedPartials;
import dr.inference.model.CompoundParameter;
import dr.inference.model.MatrixParameterInterface;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.math.KroneckerOperation;
import dr.math.distributions.MultivariateNormalDistribution;
import dr.math.distributions.WishartSufficientStatistics;
import dr.math.interfaces.ConjugateWishartStatisticsProvider;
import dr.math.matrixAlgebra.IllegalDimension;
import dr.math.matrixAlgebra.Matrix;
import dr.math.matrixAlgebra.Vector;
import dr.xml.Reportable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class FullyConjugateMultivariateTraitLikelihood
extends IntegratedMultivariateTraitLikelihood
implements ConjugateWishartStatisticsProvider,
GibbsSampleFromTreeInterface,
Reportable {
    double[] rootPriorMean;
    double rootPriorSampleSize;
    private double[] preP;
    private double[][] preMeans;
    private double[] storedPreP;
    private double[][] storedPreMeans;
    private Boolean PostPreKnown = false;
    private Boolean storedPostPreKnown = false;
    private boolean priorInformationKnown;
    private double zBz;
    private boolean dimKnown = false;
    private boolean storedDimKnown = false;
    private int storedDim;
    private int storedNumData;
    boolean computeWishartStatistics = false;
    private double[] ascertainedData = null;
    private static final boolean DEBUG_ASCERTAINMENT = false;
    private static final boolean DO_CLAMP = true;

    public FullyConjugateMultivariateTraitLikelihood(String string, MutableTreeModel mutableTreeModel, MultivariateDiffusionModel multivariateDiffusionModel, CompoundParameter compoundParameter, Parameter parameter, List<Integer> list, boolean bl, boolean bl2, boolean bl3, BranchRateModel branchRateModel, List<BranchRateModel> list2, List<BranchRateModel> list3, BranchRateModel branchRateModel2, Model model, boolean bl4, double[] dArray, List<RestrictedPartials> list4, double d, boolean bl5) {
        super(string, mutableTreeModel, multivariateDiffusionModel, compoundParameter, parameter, list, bl, bl2, bl3, branchRateModel, list2, list3, branchRateModel2, model, list4, bl4, bl5);
        this.rootPriorMean = dArray;
        this.rootPriorSampleSize = d;
        this.priorInformationKnown = false;
    }

    double getRescaledLengthToRoot(NodeRef nodeRef) {
        double d = 0.0;
        if (!this.treeModel.isRoot(nodeRef)) {
            NodeRef nodeRef2 = this.treeModel.getParent(nodeRef);
            d += this.getRescaledBranchLengthForPrecision(nodeRef) + this.getRescaledLengthToRoot(nodeRef2);
        }
        return d;
    }

    @Override
    protected double calculateAscertainmentCorrection(int n) {
        NodeRef nodeRef = this.treeModel.getNode(n);
        int n2 = this.treeModel.getNode(n).getNumber();
        if (this.ascertainedData == null) {
            this.ascertainedData = new double[this.dimTrait];
        }
        double[][] dArray = this.diffusionModel.getPrecisionmatrix();
        double d = Math.log(this.diffusionModel.getDeterminantPrecisionMatrix());
        double d2 = this.getRescaledLengthToRoot(nodeRef);
        double d3 = 1.0 / d2 + this.rootPriorSampleSize;
        double d4 = 0.0;
        for (int i = 0; i < this.numData; ++i) {
            System.arraycopy(this.meanCache, n2 * this.dim + i * this.dimTrait, this.ascertainedData, 0, this.dimTrait);
            if (this.dimTrait > 1) {
                throw new RuntimeException("Still need to implement multivariate ascertainment correction");
            }
            double d5 = dArray[0][0] * d3;
            double d6 = this.ascertainedData[0] * d5 * this.ascertainedData[0];
            d5 = -LOG_SQRT_2_PI * (double)this.dimTrait + 0.5 * (d + (double)this.dimTrait * Math.log(d3) - d6);
            d4 += d5;
        }
        return d4;
    }

    @Override
    public WishartSufficientStatistics getWishartStatistics() {
        this.computeWishartStatistics = true;
        this.calculateLogLikelihood();
        this.computeWishartStatistics = false;
        return this.wishartStatistics;
    }

    @Override
    public MatrixParameterInterface getPrecisionParameter() {
        return this.diffusionModel.getPrecisionParameter();
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        if (model == this.diffusionModel) {
            this.priorInformationKnown = false;
        }
        super.handleModelChangedEvent(model, object, n);
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        if (variable == this.traitParameter && (Variable.ChangeType.ADDED == changeType || Variable.ChangeType.REMOVED == changeType)) {
            this.dimKnown = false;
            this.dim = this.traitParameter.getParameter(0).getDimension();
            this.numData = this.dim / this.getDimTrait();
            this.meanCache = new double[this.dim * this.treeModel.getNodeCount()];
            this.drawnStates = new double[this.dim * this.treeModel.getNodeCount()];
        }
        this.PostPreKnown = false;
        super.handleVariableChangedEvent(variable, n, changeType);
    }

    @Override
    public void storeState() {
        this.storedNumData = this.numData;
        this.storedDim = this.dim;
        super.storeState();
        this.storedPostPreKnown = this.PostPreKnown;
        this.storedDimKnown = this.dimKnown;
        if (this.preP != null) {
            System.arraycopy(this.preP, 0, this.storedPreP, 0, this.preP.length);
        }
        if (this.preMeans != null) {
            for (int i = 0; i < this.preMeans.length; ++i) {
                this.storedPreMeans[i] = (double[])this.preMeans[i].clone();
            }
        }
    }

    @Override
    public void restoreState() {
        this.dim = this.storedDim;
        this.numData = this.storedNumData;
        this.drawnStates = new double[this.dim * this.treeModel.getNodeCount()];
        super.restoreState();
        this.PostPreKnown = this.storedPostPreKnown;
        this.priorInformationKnown = false;
        double[] dArray = this.storedPreP;
        this.storedPreP = this.preP;
        this.preP = dArray;
        double[][] dArray2 = this.preMeans = this.storedPreMeans;
        this.preMeans = this.storedPreMeans;
        this.storedPreMeans = dArray2;
        this.dimKnown = this.storedDimKnown;
    }

    @Override
    public void makeDirty() {
        super.makeDirty();
        this.priorInformationKnown = false;
    }

    public double getPriorSampleSize() {
        return this.rootPriorSampleSize;
    }

    public double[] getPriorMean() {
        return this.rootPriorMean;
    }

    @Override
    public boolean getComputeWishartSufficientStatistics() {
        return this.computeWishartStatistics;
    }

    private void doPreOrderTraversal(NodeRef nodeRef) {
        if (this.preP == null) {
            this.preP = new double[this.treeModel.getNodeCount()];
            this.storedPreP = new double[this.treeModel.getNodeCount()];
        }
        if (!this.dimKnown) {
            this.preMeans = new double[this.treeModel.getNodeCount()][this.dim];
            this.storedPreMeans = new double[this.treeModel.getNodeCount()][this.dim];
            this.dimKnown = true;
        }
        int n = nodeRef.getNumber();
        if (this.treeModel.isRoot(nodeRef)) {
            this.preP[n] = this.rootPriorSampleSize;
            for (int i = 0; i < this.dim; ++i) {
                this.preMeans[n][i] = this.rootPriorMean[i % this.dimTrait];
            }
        } else {
            NodeRef nodeRef2 = this.treeModel.getParent(nodeRef);
            NodeRef nodeRef3 = this.getSisterNode(nodeRef);
            int n2 = nodeRef2.getNumber();
            int n3 = nodeRef3.getNumber();
            double d = this.preP[n2];
            double d2 = this.upperPrecisionCache[n3];
            double d3 = 1.0 / this.getRescaledBranchLengthForPrecision(nodeRef);
            double d4 = d + d2;
            this.preP[n] = d4 * d3 / (d4 + d3);
            for (int i = 0; i < this.dim; ++i) {
                this.preMeans[n][i] = (d * this.preMeans[n2][i] + d2 * this.cacheHelper.getMeanCache()[n3 * this.dim + i]) / (d + d2);
            }
        }
        if (!this.treeModel.isExternal(nodeRef)) {
            this.doPreOrderTraversal(this.treeModel.getChild(nodeRef, 0));
            this.doPreOrderTraversal(this.treeModel.getChild(nodeRef, 1));
        }
    }

    private NodeRef getSisterNode(NodeRef nodeRef) {
        NodeRef nodeRef2 = this.treeModel.getChild(this.treeModel.getParent(nodeRef), 0);
        NodeRef nodeRef3 = this.treeModel.getChild(this.treeModel.getParent(nodeRef), 1);
        if (nodeRef2 == nodeRef) {
            return nodeRef3;
        }
        return nodeRef2;
    }

    @Override
    public double[] getConditionalMean(int n) {
        this.setup();
        double[] dArray = new double[this.dim];
        System.arraycopy(this.preMeans[n], 0, dArray, 0, this.dim);
        return dArray;
    }

    public double[][] getConditionalMeans() {
        this.setup();
        return this.preMeans;
    }

    @Override
    public double getPrecisionFactor(int n) {
        this.setup();
        return this.preP[n];
    }

    public double[] getPrecisionFactors() {
        this.setup();
        return this.preP;
    }

    @Override
    public double[][] getConditionalPrecision(int n) {
        this.setup();
        double[][] dArray = this.diffusionModel.getPrecisionmatrix();
        double d = this.getPrecisionFactor(n);
        double[][] dArray2 = new double[this.dim][this.dim];
        for (int i = 0; i < this.getNumData(); ++i) {
            for (int j = 0; j < this.getDimTrait(); ++j) {
                for (int k = 0; k < this.getDimTrait(); ++k) {
                    dArray2[i * this.getDimTrait() + j][i * this.getDimTrait() + k] = d * dArray[j][k];
                }
            }
        }
        return dArray2;
    }

    private void setup() {
        if (!this.PostPreKnown.booleanValue()) {
            double[][] dArray = this.diffusionModel.getPrecisionmatrix();
            double d = Math.log(this.diffusionModel.getDeterminantPrecisionMatrix());
            boolean bl = this.getComputeWishartSufficientStatistics();
            if (bl) {
                this.wishartStatistics = new WishartSufficientStatistics(this.dimTrait);
            }
            this.postOrderTraverse(this.treeModel, this.treeModel.getRoot(), dArray, d, bl);
            this.doPreOrderTraversal(this.treeModel.getRoot());
        }
        this.PostPreKnown = true;
    }

    @Override
    protected void checkLogLikelihood(double d, double d2, double[] dArray, double d3, double[][] dArray2) {
        double d4 = d3 * this.rootPriorSampleSize / (d3 + this.rootPriorSampleSize);
        double[][] dArray3 = new double[dArray2.length][dArray2.length];
        for (int i = 0; i < dArray2.length; ++i) {
            for (int j = 0; j < dArray2.length; ++j) {
                dArray3[i][j] = dArray2[i][j] * d4;
            }
        }
        MultivariateNormalDistribution multivariateNormalDistribution = new MultivariateNormalDistribution(this.rootPriorMean, dArray3);
        double d5 = multivariateNormalDistribution.logPdf(dArray);
        if (Math.abs(d - d2 - d5) > 0.001) {
            System.err.println("Got here subclass: " + d);
            System.err.println("logValue         : " + (d2 + d5));
            System.err.println("logRemainder = " + d2);
            System.err.println("");
        }
    }

    @Override
    protected double integrateLogLikelihoodAtRoot(double[] dArray, double[] dArray2, double[][] dArray3, double[][] dArray4, double d) {
        double d2;
        double d3 = d + this.rootPriorSampleSize;
        double d4 = 1.0 / d3;
        if (this.dimTrait > 1) {
            FullyConjugateMultivariateTraitLikelihood.computeWeightedAverage(dArray, 0, d, this.rootPriorMean, 0, this.rootPriorSampleSize, dArray2, 0, this.dimTrait);
            d2 = FullyConjugateMultivariateTraitLikelihood.computeQuadraticProduct(dArray2, dArray4, dArray2, this.dimTrait) * d3;
            if (this.computeWishartStatistics) {
                double[] dArray5 = this.wishartStatistics.getScaleMatrix();
                double d5 = d * this.rootPriorSampleSize * d4;
                for (int i = 0; i < this.dimTrait; ++i) {
                    double d6 = dArray[i] - this.rootPriorMean[i];
                    for (int j = 0; j < this.dimTrait; ++j) {
                        int n = i * this.dimTrait + j;
                        dArray5[n] = dArray5[n] + d6 * d5 * (dArray[j] - this.rootPriorMean[j]);
                    }
                }
                this.wishartStatistics.incrementDf(1);
            }
        } else {
            double d7 = dArray[0] * d + this.rootPriorMean[0] * this.rootPriorSampleSize;
            d2 = d7 * d7 * dArray4[0][0] * d4;
            if (this.computeWishartStatistics) {
                double[] dArray6 = this.wishartStatistics.getScaleMatrix();
                double d8 = dArray[0] - this.rootPriorMean[0];
                dArray6[0] = dArray6[0] + d8 * d8 * d * this.rootPriorSampleSize * d4;
                this.wishartStatistics.incrementDf(1);
            }
        }
        if (!this.priorInformationKnown) {
            this.setRootPriorSumOfSquares(dArray4);
        }
        double d9 = 0.5 * ((double)this.dimTrait * Math.log(this.rootPriorSampleSize * d4) - this.zBz + d2);
        if (DEBUG) {
            System.err.println("(Ay+Bz)(A+B)^{-1}(Ay+Bz) = " + d2);
            System.err.println("density = " + d9);
            System.err.println("zBz = " + this.zBz);
        }
        return d9;
    }

    private void setRootPriorSumOfSquares(double[][] dArray) {
        this.zBz = FullyConjugateMultivariateTraitLikelihood.computeQuadraticProduct(this.rootPriorMean, dArray, this.rootPriorMean, this.dimTrait) * this.rootPriorSampleSize;
        this.priorInformationKnown = true;
    }

    @Override
    protected double[][] computeMarginalRootMeanAndVariance(double[] dArray, double[][] dArray2, double[][] dArray3, double d) {
        double[][] dArray4 = this.tmpM;
        FullyConjugateMultivariateTraitLikelihood.computeWeightedAverage(dArray, 0, d, this.rootPriorMean, 0, this.rootPriorSampleSize, dArray, 0, this.dimTrait);
        double d2 = 1.0 / (d + this.rootPriorSampleSize);
        for (int i = 0; i < this.dimTrait; ++i) {
            for (int j = 0; j < this.dimTrait; ++j) {
                dArray4[i][j] = dArray3[i][j] * d2;
            }
        }
        return dArray4;
    }

    private double vectorMin(double[] dArray) {
        double d = Double.MAX_VALUE;
        for (double d2 : dArray) {
            d = Math.min(d, d2);
        }
        return d;
    }

    private double matrixMin(double[][] dArray) {
        double d = Double.MAX_VALUE;
        for (double[] dArray2 : dArray) {
            d = Math.min(d, this.vectorMin(dArray2));
        }
        return d;
    }

    private double vectorMax(double[] dArray) {
        double d = -1.7976931348623157E308;
        for (double d2 : dArray) {
            d = Math.max(d, d2);
        }
        return d;
    }

    private double matrixMax(double[][] dArray) {
        double d = -1.7976931348623157E308;
        for (double[] dArray2 : dArray) {
            d = Math.max(d, this.vectorMax(dArray2));
        }
        return d;
    }

    private double vectorSum(double[] dArray) {
        double d = 0.0;
        for (double d2 : dArray) {
            d += d2;
        }
        return d;
    }

    private double matrixSum(double[][] dArray) {
        double d = 0.0;
        for (double[] dArray2 : dArray) {
            d += this.vectorSum(dArray2);
        }
        return d;
    }

    @Override
    public String getReport() {
        int n;
        double[] dArray;
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Tree:\n");
        stringBuilder.append(this.getId()).append("\t");
        stringBuilder.append(this.treeModel.toString());
        stringBuilder.append("\n\n");
        double[][] dArray2 = this.computeTreeVariance();
        double[][] dArray3 = this.getDiffusionModel().getPrecisionmatrix();
        Matrix matrix = new Matrix(dArray3).inverse();
        double[][] dArray4 = KroneckerOperation.product(dArray2, matrix.toComponents());
        stringBuilder.append("Tree variance:\n");
        stringBuilder.append(new Matrix(dArray2));
        stringBuilder.append(this.matrixMin(dArray2)).append("\t").append(this.matrixMax(dArray2)).append("\t").append(this.matrixSum(dArray2));
        stringBuilder.append("\n\n");
        stringBuilder.append("Trait variance:\n");
        stringBuilder.append(matrix);
        stringBuilder.append("\n\n");
        stringBuilder.append("Tree dim: ").append(dArray2.length).append("\n");
        stringBuilder.append("data dim: ").append(dArray4.length);
        stringBuilder.append("\n\n");
        double[] dArray5 = new double[dArray4.length];
        System.arraycopy(this.meanCache, 0, dArray5, 0, dArray4.length);
        if (this.nodeToClampMap != null) {
            int n2 = this.treeModel.getExternalNodeCount() * this.getDimTrait();
            for (Map.Entry entry : this.nodeToClampMap.entrySet()) {
                object = ((RestrictedPartials)entry.getValue()).getPartials();
                dArray = object;
                int n3 = dArray.length;
                for (n = 0; n < n3; ++n) {
                    double d;
                    dArray5[n2] = d = dArray[n];
                    ++n2;
                }
            }
        }
        stringBuilder.append("Data:\n");
        stringBuilder.append(new Vector(dArray5)).append("\n");
        stringBuilder.append(dArray5.length).append("\t").append(this.vectorMin(dArray5)).append("\t").append(this.vectorMax(dArray5)).append("\t").append(this.vectorSum(dArray5));
        stringBuilder.append(this.treeModel.getNodeTaxon(this.treeModel.getExternalNode(0)).getId());
        stringBuilder.append("\n\n");
        MultivariateNormalDistribution multivariateNormalDistribution = new MultivariateNormalDistribution(new double[dArray5.length], new Matrix(dArray4).inverse().toComponents());
        double d = multivariateNormalDistribution.logPdf(dArray5);
        stringBuilder.append("logLikelihood: ").append(this.getLogLikelihood()).append(" == ").append(d).append("\n\n");
        object = this.getWishartStatistics();
        dArray = ((WishartSufficientStatistics)object).getScaleMatrix();
        stringBuilder.append("Outer-products (DP):\n");
        stringBuilder.append(new Vector(dArray));
        stringBuilder.append(((WishartSufficientStatistics)object).getDf()).append("\n");
        Matrix matrix2 = new Matrix(dArray2).inverse();
        n = dArray5.length / dArray3.length;
        int n4 = dArray3.length;
        double[][] dArray6 = new double[n][n4];
        for (int i = 0; i < n; ++i) {
            System.arraycopy(dArray5, i * n4, dArray6[i], 0, n4);
        }
        Matrix matrix3 = new Matrix(dArray6);
        Matrix matrix4 = null;
        try {
            matrix4 = matrix3.transpose().product(matrix2).product(matrix3);
        }
        catch (IllegalDimension illegalDimension) {
            illegalDimension.printStackTrace();
        }
        stringBuilder.append("Outer-products (from tree variance:\n");
        stringBuilder.append(matrix4);
        stringBuilder.append("\n\n");
        return stringBuilder.toString();
    }

    private void addNodeToList(NodeRef nodeRef, NodeToRootDistanceList nodeToRootDistanceList, NodeToRootDistanceList[] nodeToRootDistanceListArray) {
        if (!this.treeModel.isRoot(nodeRef)) {
            double d = this.getRescaledBranchLengthForPrecision(nodeRef);
            if (nodeToRootDistanceList.size() > 0) {
                d += ((NodeToRootDistance)nodeToRootDistanceList.get((int)(nodeToRootDistanceList.size() - 1))).distance;
            }
            nodeToRootDistanceList.add(new NodeToRootDistance(nodeRef, d));
        }
        if (this.treeModel.isExternal(nodeRef)) {
            nodeToRootDistanceListArray[nodeRef.getNumber()] = nodeToRootDistanceList;
        } else {
            NodeToRootDistanceList nodeToRootDistanceList2 = new NodeToRootDistanceList(nodeToRootDistanceList);
            this.addNodeToList(this.treeModel.getChild(nodeRef, 0), nodeToRootDistanceList2, nodeToRootDistanceListArray);
            this.addNodeToList(this.treeModel.getChild(nodeRef, 1), nodeToRootDistanceList, nodeToRootDistanceListArray);
        }
    }

    private double getTimeBetweenNodeToRootLists(List<NodeToRootDistance> list, List<NodeToRootDistance> list2) {
        if (list.get(0) != list2.get(0)) {
            return 0.0;
        }
        int n = 1;
        while (list.get(n) == list2.get(n)) {
            ++n;
        }
        return list.get((int)(n - 1)).distance;
    }

    double[][] computeTreeVariance2(boolean bl) {
        int n;
        int n2 = this.treeModel.getExternalNodeCount();
        double[][] dArray = new double[n2][n2];
        NodeToRootDistanceList[] nodeToRootDistanceListArray = new NodeToRootDistanceList[n2];
        this.addNodeToList(this.treeModel.getRoot(), new NodeToRootDistanceList(), nodeToRootDistanceListArray);
        for (n = 0; n < n2; ++n) {
            double d;
            NodeToRootDistanceList nodeToRootDistanceList = nodeToRootDistanceListArray[n];
            dArray[n][n] = d = ((NodeToRootDistance)nodeToRootDistanceList.get((int)(nodeToRootDistanceList.size() - 1))).distance;
            for (int i = n + 1; i < n2; ++i) {
                double d2;
                NodeToRootDistanceList nodeToRootDistanceList2 = nodeToRootDistanceListArray[i];
                double d3 = d2 = this.getTimeBetweenNodeToRootLists(nodeToRootDistanceList, nodeToRootDistanceList2);
                dArray[n][i] = d3;
                dArray[i][n] = d3;
            }
        }
        dArray = this.removeMissingTipsInTreeVariance(dArray);
        if (DEBUG) {
            System.err.println("");
            System.err.println("New tree (trimmed) conditional variance:\n" + new Matrix(dArray));
        }
        if (bl) {
            for (n = 0; n < dArray.length; ++n) {
                int n3 = 0;
                while (n3 < dArray[n].length) {
                    double[] dArray2 = dArray[n];
                    int n4 = n3++;
                    dArray2[n4] = dArray2[n4] + 1.0 / this.getPriorSampleSize();
                }
            }
        }
        return dArray;
    }

    private double[][] computeTreeVariance() {
        int n;
        int n2;
        int n3 = n2 = this.treeModel.getExternalNodeCount();
        if (this.nodeToClampMap != null) {
            n3 += this.nodeToClampMap.size();
        }
        double[][] dArray = new double[n3][n3];
        for (n = 0; n < n2; ++n) {
            double d;
            dArray[n][n] = d = this.getRescaledLengthToRoot(this.treeModel.getExternalNode(n));
            for (int i = n + 1; i < n2; ++i) {
                NodeRef nodeRef = this.findMRCA(n, i);
                dArray[n][i] = this.getRescaledLengthToRoot(nodeRef);
            }
        }
        if (this.nodeToClampMap != null) {
            ArrayList<RestrictedPartials> arrayList = new ArrayList<RestrictedPartials>();
            for (Map.Entry object : this.nodeToClampMap.entrySet()) {
                arrayList.add((RestrictedPartials)object.getValue());
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                NodeRef nodeRef;
                NodeRef nodeRef2;
                int n4;
                RestrictedPartials restrictedPartials = (RestrictedPartials)arrayList.get(i);
                NodeRef nodeRef3 = restrictedPartials.getNode();
                dArray[n2 + i][n2 + i] = this.getRescaledLengthToRoot(nodeRef3) + 1.0 / restrictedPartials.getPriorSampleSize();
                for (n4 = 0; n4 < n2; ++n4) {
                    nodeRef2 = this.treeModel.getExternalNode(n4);
                    nodeRef = TreeUtils.getCommonAncestor(this.treeModel, nodeRef3, nodeRef2);
                    dArray[n4][n2 + i] = this.getRescaledLengthToRoot(nodeRef);
                }
                for (n4 = 0; n4 < i; ++n4) {
                    nodeRef2 = ((RestrictedPartials)arrayList.get(n4)).getNode();
                    nodeRef = TreeUtils.getCommonAncestor(this.treeModel, nodeRef3, nodeRef2);
                    dArray[n2 + n4][n2 + i] = this.getRescaledLengthToRoot(nodeRef);
                }
            }
        }
        for (n = 0; n < n3; ++n) {
            for (int i = n + 1; i < n3; ++i) {
                dArray[i][n] = dArray[n][i];
            }
        }
        for (n = 0; n < dArray.length; ++n) {
            int n5 = 0;
            while (n5 < dArray[n].length) {
                double[] dArray2 = dArray[n];
                int n4 = n5++;
                dArray2[n4] = dArray2[n4] + 1.0 / this.getPriorSampleSize();
            }
        }
        return dArray;
    }

    private NodeRef findMRCA(int n, int n2) {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(this.treeModel.getTaxonId(n));
        hashSet.add(this.treeModel.getTaxonId(n2));
        return TreeUtils.getCommonAncestorNode(this.treeModel, hashSet);
    }

    private double[][] removeMissingTipsInTreeVariance(double[][] dArray) {
        int n = this.treeModel.getExternalNodeCount();
        int n2 = this.countNonMissingTips();
        if (n2 == n) {
            return dArray;
        }
        double[][] dArray2 = new double[n2][n2];
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            if (this.missingTraits.isCompletelyMissing(i)) continue;
            int n4 = 0;
            for (int j = 0; j < n; ++j) {
                if (this.missingTraits.isCompletelyMissing(i)) continue;
                dArray2[n3][n4] = dArray[i][j];
                ++n4;
            }
            ++n3;
        }
        return dArray2;
    }

    private int countNonMissingTips() {
        int n = this.treeModel.getExternalNodeCount();
        for (int i = 0; i < n; ++i) {
            if (!this.missingTraits.isCompletelyMissing(i)) continue;
            --n;
        }
        return n;
    }

    class NodeToRootDistanceList
    extends ArrayList<NodeToRootDistance> {
        NodeToRootDistanceList(NodeToRootDistanceList nodeToRootDistanceList) {
            super(nodeToRootDistanceList);
        }

        NodeToRootDistanceList() {
        }
    }

    class NodeToRootDistance {
        NodeRef node;
        double distance;

        NodeToRootDistance(NodeRef nodeRef, double d) {
            this.node = nodeRef;
            this.distance = d;
        }
    }
}

