/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.tree;

import dr.evolution.tree.BranchRates;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeAttributeProvider;
import dr.evolution.tree.TreeTraitProvider;
import dr.evolution.tree.TreeUtils;
import dr.inference.loggers.LogFormatter;
import dr.inference.loggers.MCLogger;
import dr.util.Keywordable;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TreeLogger
extends MCLogger {
    private Tree tree;
    private BranchRates branchRates = null;
    private TreeAttributeProvider[] treeAttributeProviders;
    private TreeTraitProvider[] treeTraitProviders;
    private boolean nexusFormat = false;
    public boolean usingRates = false;
    public boolean substitutions = false;
    private final Map<String, Integer> idMap = new HashMap<String, Integer>();
    private final List<String> taxaIds = new ArrayList<String>();
    private boolean mapNames = true;
    private NumberFormat format;
    private LogUpon condition = null;

    public TreeLogger(Tree tree, LogFormatter logFormatter, int n, boolean bl, boolean bl2, boolean bl3) {
        this(tree, null, null, null, logFormatter, n, bl, bl2, bl3, null, null);
    }

    public TreeLogger(Tree tree, LogFormatter logFormatter, int n, boolean bl, boolean bl2, boolean bl3, NumberFormat numberFormat) {
        this(tree, null, null, null, logFormatter, n, bl, bl2, bl3, numberFormat, null);
    }

    public TreeLogger(Tree tree, BranchRates branchRates, TreeAttributeProvider[] treeAttributeProviderArray, TreeTraitProvider[] treeTraitProviderArray, LogFormatter logFormatter, int n, boolean bl, boolean bl2, boolean bl3, NumberFormat numberFormat, LogUpon logUpon) {
        super(logFormatter, n, false);
        int n2;
        this.condition = logUpon;
        this.nexusFormat = bl;
        this.mapNames = bl3 && bl;
        this.branchRates = branchRates;
        this.treeAttributeProviders = treeAttributeProviderArray;
        this.treeTraitProviders = treeTraitProviderArray;
        if (this.branchRates != null) {
            this.substitutions = true;
        }
        this.tree = tree;
        for (n2 = 0; n2 < tree.getTaxonCount(); ++n2) {
            this.taxaIds.add(tree.getTaxon(n2).getId());
        }
        if (bl2) {
            Collections.sort(this.taxaIds);
        }
        n2 = 1;
        for (String string : this.taxaIds) {
            this.idMap.put(string, n2);
            ++n2;
        }
        this.format = numberFormat;
    }

    @Override
    public void startLogging() {
        if (this.nexusFormat) {
            Object object;
            int n = this.tree.getTaxonCount();
            this.logLine("#NEXUS");
            this.logLine("");
            this.logLine("Begin taxa;");
            this.logLine("\tDimensions ntax=" + n + ";");
            this.logLine("\tTaxlabels");
            Object object2 = this.taxaIds.iterator();
            while (object2.hasNext()) {
                object = object2.next();
                this.logLine("\t\t" + this.cleanTaxonName((String)object));
            }
            this.logLine("\t\t;");
            this.logLine("End;");
            this.logLine("");
            this.logLine("Begin trees;");
            if (this.tree instanceof Keywordable && (object2 = ((Keywordable)((Object)this.tree)).getKeywords()).size() > 0) {
                object = new StringBuffer("[keywords:");
                Iterator object3 = object2.iterator();
                while (object3.hasNext()) {
                    String string = (String)object3.next();
                    ((StringBuffer)object).append(" ");
                    ((StringBuffer)object).append(string);
                }
                ((StringBuffer)object).append("]");
                this.logLine(((StringBuffer)object).toString());
            }
            if (this.mapNames) {
                this.logLine("\tTranslate");
                int n2 = 1;
                for (String string : this.taxaIds) {
                    if (n2 < n) {
                        this.logLine("\t\t" + n2 + " " + this.cleanTaxonName(string) + ",");
                    } else {
                        this.logLine("\t\t" + n2 + " " + this.cleanTaxonName(string));
                    }
                    ++n2;
                }
                this.logLine("\t\t;");
            }
        }
    }

    private String cleanTaxonName(String string) {
        if (string.matches(".*[\\s\\.;,\"'].*")) {
            if (string.contains("'")) {
                if (string.contains("\"")) {
                    throw new RuntimeException("Illegal taxon name - contains both single and double quotes");
                }
                return "\"" + string + "\"";
            }
            return "'" + string + "'";
        }
        return string;
    }

    @Override
    public void log(long l) {
        boolean bl;
        boolean bl2 = this.condition != null ? this.condition.logNow(l) : (bl = this.logEvery < 0L || l % this.logEvery == 0L);
        if (bl) {
            StringBuffer stringBuffer = new StringBuffer("tree STATE_");
            stringBuffer.append(l);
            if (this.treeAttributeProviders != null) {
                boolean bl3 = false;
                for (TreeAttributeProvider treeAttributeProvider : this.treeAttributeProviders) {
                    String[] stringArray = treeAttributeProvider.getTreeAttributeLabel();
                    String[] stringArray2 = treeAttributeProvider.getAttributeForTree(this.tree);
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (!bl3) {
                            stringBuffer.append(" [&");
                            bl3 = true;
                        } else {
                            stringBuffer.append(",");
                        }
                        stringBuffer.append(stringArray[i]);
                        stringBuffer.append("=");
                        stringBuffer.append(stringArray2[i]);
                    }
                }
                if (bl3) {
                    stringBuffer.append("]");
                }
            }
            stringBuffer.append(" = [&R] ");
            if (this.substitutions) {
                TreeUtils.newick(this.tree, this.tree.getRoot(), false, TreeUtils.BranchLengthType.LENGTHS_AS_SUBSTITUTIONS, this.format, this.branchRates, this.treeTraitProviders, this.idMap, stringBuffer);
            } else {
                TreeUtils.newick(this.tree, this.tree.getRoot(), !this.mapNames, TreeUtils.BranchLengthType.LENGTHS_AS_TIME, this.format, null, this.treeTraitProviders, this.idMap, stringBuffer);
            }
            stringBuffer.append(";");
            this.logLine(stringBuffer.toString());
        }
    }

    @Override
    public void stopLogging() {
        this.logLine("End;");
        super.stopLogging();
    }

    public Tree getTree() {
        return this.tree;
    }

    public void setTree(Tree tree) {
        this.tree = tree;
    }

    public TreeAttributeProvider[] getTreeAttributeProviders() {
        return this.treeAttributeProviders;
    }

    public TreeTraitProvider[] getTreeTraitProviders() {
        return this.treeTraitProviders;
    }

    public BranchRates getBranchRates() {
        return this.branchRates;
    }

    public static interface LogUpon {
        public boolean logNow(long var1);
    }
}

