/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treelikelihood.utilities;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeTrait;
import dr.evolution.util.Taxon;
import dr.evomodel.treedatalikelihood.TreeDataLikelihood;
import dr.evomodel.treedatalikelihood.continuous.ContinuousDataLikelihoodDelegate;
import dr.evomodel.treedatalikelihood.preorder.ContinuousExtensionDelegate;
import dr.evomodel.treedatalikelihood.preorder.ModelExtensionProvider;
import dr.inference.loggers.LogColumn;
import dr.inference.loggers.Loggable;
import dr.math.matrixAlgebra.Matrix;
import dr.math.matrixAlgebra.Vector;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.Reportable;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.ArrayList;
import java.util.List;

public class ModelExtensionTraitLogger
implements Loggable,
Reportable {
    private final ContinuousExtensionDelegate extensionDelegate;
    private final int traitDim;
    private final List<Integer> logDims;
    private double[] traits;
    public static final String MODEL_EXTENSION_LOGGER = "modelExtensionTraitLogger";
    public static final String DIMENSIONS = "dimensions";
    public static AbstractXMLObjectParser PARSER = new AbstractXMLObjectParser(){
        XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule(TreeDataLikelihood.class), new ElementRule(ModelExtensionProvider.class), AttributeRule.newStringRule("traitName"), AttributeRule.newStringRule("dimensions", true)};

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            List<Integer> list;
            TreeDataLikelihood treeDataLikelihood = (TreeDataLikelihood)xMLObject.getChild(TreeDataLikelihood.class);
            ModelExtensionProvider modelExtensionProvider = (ModelExtensionProvider)xMLObject.getChild(ModelExtensionProvider.class);
            Tree tree = treeDataLikelihood.getTree();
            String string = xMLObject.getStringAttribute("traitName");
            int n = treeDataLikelihood.getDataLikelihoodDelegate().getTraitDim();
            TreeTrait treeTrait = treeDataLikelihood.getTreeTrait("tip." + string);
            ContinuousExtensionDelegate continuousExtensionDelegate = modelExtensionProvider.getExtensionDelegate((ContinuousDataLikelihoodDelegate)treeDataLikelihood.getDataLikelihoodDelegate(), treeTrait, tree);
            String string2 = xMLObject.getAttribute(ModelExtensionTraitLogger.DIMENSIONS, IndicesProvider.ALL.getName());
            if (string2.equalsIgnoreCase(IndicesProvider.ALL.getName())) {
                list = IndicesProvider.ALL.getLoggableIndices(modelExtensionProvider);
            } else if (string2.equalsIgnoreCase(IndicesProvider.MISSING.getName())) {
                list = IndicesProvider.MISSING.getLoggableIndices(modelExtensionProvider);
            } else {
                throw new XMLParseException("The attribte \"dimensions\" must have the value \"" + IndicesProvider.ALL.getName() + "\" or \"" + IndicesProvider.MISSING.getName() + "\". You supplied the value \"" + string2 + "\".");
            }
            return new ModelExtensionTraitLogger(continuousExtensionDelegate, list, n);
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public String getParserDescription() {
            return null;
        }

        @Override
        public Class getReturnType() {
            return ModelExtensionTraitLogger.class;
        }

        @Override
        public String getParserName() {
            return ModelExtensionTraitLogger.MODEL_EXTENSION_LOGGER;
        }
    };

    ModelExtensionTraitLogger(ContinuousExtensionDelegate continuousExtensionDelegate, List<Integer> list, int n) {
        this.extensionDelegate = continuousExtensionDelegate;
        this.traitDim = n;
        this.logDims = list;
    }

    @Override
    public LogColumn[] getColumns() {
        Tree tree = this.extensionDelegate.getTree();
        String string = this.extensionDelegate.getTreeTrait().getTraitName();
        LogColumn[] logColumnArray = new LogColumn[this.logDims.size()];
        int n = 0;
        for (final int n2 : this.logDims) {
            final int n3 = n;
            int n4 = n2 / this.traitDim;
            int n5 = n2 - n4 * this.traitDim;
            NodeRef nodeRef = tree.getExternalNode(n4);
            Taxon taxon = tree.getNodeTaxon(nodeRef);
            String string2 = taxon != null ? taxon.getId() : "taxon_" + n4;
            logColumnArray[n] = new LogColumn.Abstract(string + "." + string2 + "." + (n5 + 1)){

                @Override
                protected String getFormattedValue() {
                    if (n3 == 0) {
                        ModelExtensionTraitLogger.access$002(ModelExtensionTraitLogger.this, ModelExtensionTraitLogger.this.extensionDelegate.getExtendedValues());
                    }
                    return Double.toString(ModelExtensionTraitLogger.this.traits[n2]);
                }
            };
            ++n;
        }
        return logColumnArray;
    }

    @Override
    public String getReport() {
        int n;
        int n2;
        int n3;
        int[] nArray = new int[this.traitDim];
        for (n3 = 0; n3 < this.traitDim; ++n3) {
            nArray[n3] = n3;
        }
        n3 = 1000000;
        double[] dArray = new double[nArray.length];
        double[][] dArray2 = new double[nArray.length][nArray.length];
        for (n2 = 0; n2 < n3; ++n2) {
            this.traits = this.extensionDelegate.getExtendedValues();
            for (n = 0; n < nArray.length; ++n) {
                double d = this.traits[nArray[n]];
                int n4 = n;
                dArray[n4] = dArray[n4] + d;
                double[] dArray3 = dArray2[n];
                int n5 = n;
                dArray3[n5] = dArray3[n5] + d * d;
                int n6 = n + 1;
                while (n6 < nArray.length) {
                    double d2 = this.traits[nArray[n6]];
                    double[] dArray4 = dArray2[n];
                    int n7 = n6++;
                    dArray4[n7] = dArray4[n7] + d * d2;
                }
            }
        }
        for (n2 = 0; n2 < nArray.length; ++n2) {
            dArray[n2] = dArray[n2] / (double)n3;
        }
        for (n2 = 0; n2 < nArray.length; ++n2) {
            dArray2[n2][n2] = dArray2[n2][n2] / (double)n3 - dArray[n2] * dArray[n2];
            for (n = n2 + 1; n < nArray.length; ++n) {
                dArray2[n2][n] = dArray2[n2][n] / (double)n3 - dArray[n2] * dArray[n];
                dArray2[n][n2] = dArray2[n2][n];
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(new Vector(dArray));
        stringBuilder.append("\n\n");
        stringBuilder.append(new Matrix(dArray2));
        return stringBuilder.toString();
    }

    static /* synthetic */ double[] access$002(ModelExtensionTraitLogger modelExtensionTraitLogger, double[] dArray) {
        modelExtensionTraitLogger.traits = dArray;
        return dArray;
    }

    private static enum IndicesProvider {
        ALL{

            @Override
            List<Integer> getLoggableIndices(ModelExtensionProvider modelExtensionProvider) {
                int n = modelExtensionProvider.getParameter().getDimension();
                ArrayList<Integer> arrayList = new ArrayList<Integer>(n);
                for (int i = 0; i < n; ++i) {
                    arrayList.set(i, i);
                }
                return arrayList;
            }

            @Override
            String getName() {
                return "all";
            }
        }
        ,
        MISSING{

            @Override
            List<Integer> getLoggableIndices(ModelExtensionProvider modelExtensionProvider) {
                boolean[] blArray = modelExtensionProvider.getDataMissingIndicators();
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                for (int i = 0; i < blArray.length; ++i) {
                    if (!blArray[i]) continue;
                    arrayList.add(i);
                }
                return arrayList;
            }

            @Override
            String getName() {
                return "missing";
            }
        };


        abstract List<Integer> getLoggableIndices(ModelExtensionProvider var1);

        abstract String getName();
    }
}

