/*
 * Decompiled with CFR 0.152.
 */
package dr.geo;

import dr.evolution.util.Taxa;
import dr.evolution.util.Taxon;
import dr.evoxml.DateParser;
import dr.evoxml.TaxaParser;
import dr.evoxml.TaxonParser;
import dr.geo.math.SphericalPolarCoordinates;
import dr.inference.model.Statistic;
import dr.xml.AttributeParser;
import dr.xml.XMLParseException;
import dr.xml.XMLParser;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class GreatCircleDistances {
    double[][] distances;

    public GreatCircleDistances(Taxa taxa, String string) {
        this.distances = new double[taxa.getTaxonCount()][taxa.getTaxonCount()];
        for (int i = 0; i < taxa.getTaxonCount(); ++i) {
            Taxon taxon = taxa.getTaxon(i);
            String string2 = (String)taxon.getAttribute(string);
            String[] stringArray = string2.split(" ");
            double d = Double.parseDouble(stringArray[0]);
            double d2 = Double.parseDouble(stringArray[1]);
            SphericalPolarCoordinates sphericalPolarCoordinates = new SphericalPolarCoordinates(d, d2);
            for (int j = i + 1; j < taxa.getTaxonCount(); ++j) {
                Taxon taxon2 = taxa.getTaxon(j);
                string2 = (String)taxon2.getAttribute(string);
                String[] stringArray2 = string2.split(" ");
                d = Double.parseDouble(stringArray2[0]);
                d2 = Double.parseDouble(stringArray2[1]);
                SphericalPolarCoordinates sphericalPolarCoordinates2 = new SphericalPolarCoordinates(d, d2);
                double d3 = sphericalPolarCoordinates.distance(sphericalPolarCoordinates2);
                this.distances[j][i] = d3;
                this.distances[i][j] = d3;
            }
        }
    }

    public Statistic getDistanceStatistic(boolean bl) {
        return new DistancesStatistic(bl);
    }

    public static void main(String[] stringArray) throws ParserConfigurationException, IOException, SAXException, XMLParseException {
        XMLParser xMLParser = new XMLParser(false, true, true, null);
        xMLParser.addXMLObjectParser(new TaxonParser());
        xMLParser.addXMLObjectParser(new TaxaParser());
        xMLParser.addXMLObjectParser(new AttributeParser());
        xMLParser.addXMLObjectParser(new DateParser());
        xMLParser.parse((Reader)new FileReader(new File(stringArray[0])), true);
        Taxa taxa = (Taxa)xMLParser.getRoot().getChild(0);
        System.out.println("Found " + taxa.getTaxonCount() + " taxa");
        GreatCircleDistances greatCircleDistances = new GreatCircleDistances(taxa, "location");
        Statistic statistic = greatCircleDistances.getDistanceStatistic(true);
        for (int i = 0; i < statistic.getDimension(); ++i) {
            System.out.println(statistic.getStatisticValue(i));
        }
    }

    class DistancesStatistic
    extends Statistic.Abstract {
        double[] dists;

        public DistancesStatistic(boolean bl) {
            this.dists = new double[GreatCircleDistances.this.distances.length * GreatCircleDistances.this.distances.length];
            int n = 0;
            for (double[] dArray : GreatCircleDistances.this.distances) {
                for (int i = 0; i < GreatCircleDistances.this.distances.length; ++i) {
                    this.dists[n] = dArray[i];
                    if (bl) {
                        this.dists[n] = Math.log(this.dists[n]);
                    }
                    ++n;
                }
            }
        }

        @Override
        public int getDimension() {
            return this.dists.length;
        }

        @Override
        public double getStatisticValue(int n) {
            return this.dists[n];
        }
    }
}

