/*
 * Decompiled with CFR 0.152.
 */
package dr.math.distributions;

import dr.math.Poisson;
import dr.math.UnivariateFunction;
import dr.math.distributions.Distribution;
import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.PoissonDistributionImpl;

public class PoissonDistribution
implements Distribution {
    org.apache.commons.math.distribution.PoissonDistribution distribution;

    public PoissonDistribution(double d) {
        this.distribution = new PoissonDistributionImpl(d);
    }

    @Override
    public double pdf(double d) {
        return this.distribution.probability(d);
    }

    @Override
    public double logPdf(double d) {
        double d2 = this.distribution.probability(d);
        if (d2 == 0.0 || Double.isNaN(d2)) {
            double d3 = this.mean();
            return d * Math.log(d3) - Poisson.gammln(d + 1.0) - d3;
        }
        return Math.log(d2);
    }

    @Override
    public double cdf(double d) {
        try {
            return this.distribution.cumulativeProbability(d);
        }
        catch (MathException mathException) {
            throw new RuntimeException(mathException);
        }
    }

    @Override
    public double quantile(double d) {
        try {
            return this.distribution.inverseCumulativeProbability(d);
        }
        catch (MathException mathException) {
            throw new RuntimeException(mathException);
        }
    }

    @Override
    public double mean() {
        return this.distribution.getMean();
    }

    @Override
    public double variance() {
        return this.distribution.getMean();
    }

    @Override
    public UnivariateFunction getProbabilityDensityFunction() {
        throw new RuntimeException();
    }

    public double truncatedMean(int n) {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i <= n; ++i) {
            double d3 = this.distribution.probability(i);
            d2 += (double)i * d3;
            d += d3;
        }
        return d2 / d;
    }

    public static double pdf(double d, double d2) {
        PoissonDistributionImpl poissonDistributionImpl = new PoissonDistributionImpl(d2);
        return poissonDistributionImpl.probability(d);
    }

    public static double logPdf(double d, double d2) {
        PoissonDistributionImpl poissonDistributionImpl = new PoissonDistributionImpl(d2);
        double d3 = poissonDistributionImpl.probability(d);
        if (d3 == 0.0 || Double.isNaN(d3)) {
            return d * Math.log(d2) - Poisson.gammln(d + 1.0) - d2;
        }
        return Math.log(d3);
    }

    public static double cdf(double d, double d2) {
        try {
            PoissonDistributionImpl poissonDistributionImpl = new PoissonDistributionImpl(d2);
            return poissonDistributionImpl.cumulativeProbability(d);
        }
        catch (MathException mathException) {
            throw new RuntimeException(mathException);
        }
    }

    public static double quantile(double d, double d2) {
        try {
            PoissonDistributionImpl poissonDistributionImpl = new PoissonDistributionImpl(d2);
            return poissonDistributionImpl.inverseCumulativeProbability(d);
        }
        catch (MathException mathException) {
            throw new RuntimeException(mathException);
        }
    }
}

