/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import no.uib.cipr.matrix.Interface;
import no.uib.cipr.matrix.LAPACKkernel;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.NotConvergedException;
import no.uib.cipr.matrix.SymmEVD;
import no.uib.cipr.matrix.SymmTridiagMatrix;

public class SymmTridiagEVD
extends SymmEVD {
    private final double[] work;
    private final int[] iwork;
    private final LAPACKkernel.JobEigRange range;
    private final int[] isuppz;
    private final double abstol;

    public SymmTridiagEVD(int n) {
        this(n, true);
    }

    public SymmTridiagEVD(int n, double abstol) {
        this(n, true, abstol);
    }

    public SymmTridiagEVD(int n, boolean vectors) {
        this(n, vectors, Interface.lapack().lamch("Safe minimum"));
    }

    public SymmTridiagEVD(int n, boolean vectors, double abstol) {
        super(n, vectors);
        this.abstol = abstol;
        this.range = LAPACKkernel.JobEigRange.All;
        this.isuppz = new int[2 * Math.max(1, n)];
        double[] worksize = new double[1];
        int[] iworksize = new int[1];
        int info = Interface.lapack().stevr(this.job, this.range, n, new double[0], new double[0], 0.0, 0.0, 0, 0, abstol, new int[1], new double[0], new double[0], this.isuppz, worksize, -1, iworksize, -1);
        int lwork = 0;
        int liwork = 0;
        if (info != 0) {
            lwork = 20 * n;
            liwork = 10 * n;
        } else {
            lwork = (int)worksize[0];
            liwork = iworksize[0];
        }
        lwork = Math.max(1, lwork);
        liwork = Math.max(1, liwork);
        this.work = new double[lwork];
        this.iwork = new int[liwork];
    }

    public static SymmTridiagEVD factorize(Matrix A) throws NotConvergedException {
        return new SymmTridiagEVD(A.numRows()).factor(new SymmTridiagMatrix(A));
    }

    public SymmTridiagEVD factor(SymmTridiagMatrix A) throws NotConvergedException {
        if (A.numRows() != this.n) {
            throw new IllegalArgumentException("A.numRows() != n");
        }
        int info = Interface.lapack().stevr(this.job, this.range, this.n, A.getDiagonal(), A.getOffDiagonal(), 0.0, 0.0, 0, 0, this.abstol, new int[1], this.w, this.job == LAPACKkernel.JobEig.All ? this.Z.getData() : new double[]{}, this.isuppz, this.work, this.work.length, this.iwork, this.iwork.length);
        if (info > 0) {
            throw new NotConvergedException(NotConvergedException.Reason.Iterations);
        }
        if (info < 0) {
            throw new IllegalArgumentException();
        }
        return this;
    }
}

