/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.graph.channeling.edges;

import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.GraphVar;
import org.chocosolver.solver.variables.IncidentSet;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.delta.ISetDeltaMonitor;
import org.chocosolver.solver.variables.events.GraphEventType;
import org.chocosolver.solver.variables.events.SetEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.procedure.IntProcedure;

public class PropNeighSetChannel
extends Propagator<Variable> {
    private final SetVar set;
    private final GraphVar<?> g;
    private final int vertex;
    private final IncidentSet inc;
    private final ISetDeltaMonitor sdm;
    private final IntProcedure forceS;
    private final IntProcedure remS;

    public PropNeighSetChannel(SetVar neigh, int vertex, GraphVar<?> gV, IncidentSet incSet) {
        super(new Variable[]{neigh, gV}, (Priority)PropagatorPriority.LINEAR, true);
        this.vertex = vertex;
        this.set = neigh;
        this.g = gV;
        this.inc = incSet;
        this.sdm = this.set.monitorDelta(this);
        this.forceS = element -> this.inc.enforce(this.g, vertex, element, this);
        this.remS = element -> this.inc.remove(this.g, vertex, element, this);
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        if (vIdx == 0) {
            return SetEventType.ADD_TO_KER.getMask() + SetEventType.REMOVE_FROM_ENVELOPE.getMask();
        }
        return GraphEventType.ADD_EDGE.getMask() + GraphEventType.REMOVE_EDGE.getMask();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        int i;
        ISetIterator iSetIterator = this.inc.getPotentialSet(this.g, this.vertex).iterator();
        while (iSetIterator.hasNext()) {
            i = (Integer)iSetIterator.next();
            if (!this.set.getUB().contains(i)) {
                this.inc.remove(this.g, this.vertex, i, this);
                continue;
            }
            if (!this.set.getLB().contains(i)) continue;
            this.inc.enforce(this.g, this.vertex, i, this);
        }
        iSetIterator = this.set.getUB().iterator();
        while (iSetIterator.hasNext()) {
            i = (Integer)iSetIterator.next();
            if (!this.inc.getPotentialSet(this.g, this.vertex).contains(i)) {
                this.set.remove(i, this);
                continue;
            }
            if (!this.inc.getMandatorySet(this.g, this.vertex).contains(i)) continue;
            this.set.force(i, this);
        }
        this.sdm.startMonitoring();
    }

    @Override
    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        if (idxVarInProp == 0) {
            this.sdm.forEach(this.forceS, SetEventType.ADD_TO_KER);
            this.sdm.forEach(this.remS, SetEventType.REMOVE_FROM_ENVELOPE);
        } else {
            ISetIterator iSetIterator = this.set.getUB().iterator();
            while (iSetIterator.hasNext()) {
                int i = (Integer)iSetIterator.next();
                if (!this.inc.getPotentialSet(this.g, this.vertex).contains(i)) {
                    this.set.remove(i, this);
                    continue;
                }
                if (!this.inc.getMandatorySet(this.g, this.vertex).contains(i)) continue;
                this.set.force(i, this);
            }
        }
    }

    @Override
    public ESat isEntailed() {
        int i;
        ISetIterator iSetIterator = this.set.getLB().iterator();
        while (iSetIterator.hasNext()) {
            i = (Integer)iSetIterator.next();
            if (this.inc.getPotentialSet(this.g, this.vertex).contains(i)) continue;
            return ESat.FALSE;
        }
        iSetIterator = this.inc.getMandatorySet(this.g, this.vertex).iterator();
        while (iSetIterator.hasNext()) {
            i = (Integer)iSetIterator.next();
            if (this.set.getUB().contains(i)) continue;
            return ESat.FALSE;
        }
        if (this.isCompletelyInstantiated()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }
}

