/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.io;

import dr.evolution.alignment.Alignment;
import dr.evolution.alignment.SimpleAlignment;
import dr.evolution.datatype.DataType;
import dr.evolution.io.Importer;
import dr.evolution.io.SequenceImporter;
import dr.evolution.sequence.Sequence;
import dr.evolution.sequence.SequenceList;
import dr.evolution.util.Taxon;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;

public class PhylipSequentialImporter
extends Importer
implements SequenceImporter {
    private DataType dataType;
    private int maxNameLength = 10;

    public PhylipSequentialImporter(Reader reader, DataType dataType, int n) {
        super(reader);
        this.setCommentDelimiters('\u0000', '\u0000', '\u0000');
        this.dataType = dataType;
        this.maxNameLength = n;
    }

    public PhylipSequentialImporter(Reader reader, Writer writer, DataType dataType, int n) {
        super(reader, writer);
        this.setCommentDelimiters('\u0000', '\u0000', '\u0000');
        this.dataType = dataType;
        this.maxNameLength = n;
    }

    @Override
    public Alignment importAlignment() throws IOException, Importer.ImportException {
        SimpleAlignment simpleAlignment = null;
        try {
            int n = this.readInteger();
            int n2 = this.readInteger();
            String string = null;
            for (int i = 0; i < n; ++i) {
                StringBuffer stringBuffer = new StringBuffer();
                char c = this.read();
                for (int j = 0; !(Character.isWhitespace(c) || this.maxNameLength >= 1 && j >= this.maxNameLength); ++j) {
                    stringBuffer.append(c);
                    c = this.read();
                }
                StringBuffer stringBuffer2 = new StringBuffer(n2);
                this.readSequence(stringBuffer2, this.dataType, "", n2, "-", "?", ".", string);
                if (string == null) {
                    string = stringBuffer2.toString();
                }
                if (simpleAlignment == null) {
                    simpleAlignment = new SimpleAlignment();
                }
                simpleAlignment.addSequence(new Sequence(new Taxon(stringBuffer.toString()), stringBuffer2.toString()));
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return simpleAlignment;
    }

    @Override
    public SequenceList importSequences() throws IOException, Importer.ImportException {
        return this.importAlignment();
    }
}

