/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.wrightfisher;

import dr.evolution.wrightfisher.FitnessFunction;
import dr.math.MathUtils;

public class EmpiricalFitnessFunction
extends FitnessFunction {
    double[][] fitness;
    double[][] logFitness;

    public EmpiricalFitnessFunction(int n, double[] dArray, int n2, boolean bl) {
        int n3;
        int n4;
        this.fitness = new double[n][n2];
        this.logFitness = new double[n][n2];
        int n5 = 0;
        for (n4 = 0; n4 < n; ++n4) {
            this.fitness[n4][0] = 1.0;
            for (n3 = 1; n3 < n2; ++n3) {
                if (bl) {
                    this.fitness[n4][n3] = dArray[MathUtils.nextInt(dArray.length)];
                    continue;
                }
                this.fitness[n4][n3] = dArray[n5];
                n5 = (n5 + 1) % dArray.length;
            }
        }
        for (n4 = 0; n4 < n2; ++n4) {
            for (n3 = 0; n3 < n; ++n3) {
                this.logFitness[n3][n4] = Math.log(this.fitness[n3][n4]);
            }
        }
    }

    @Override
    public final double getFitness(byte[] byArray) {
        double d = 1.0;
        for (int i = 0; i < byArray.length; ++i) {
            d *= this.fitness[i][byArray[i]];
        }
        return d;
    }

    @Override
    public double getFitnessFactor(int n, byte by, byte by2) {
        return this.fitness[n][by] / this.fitness[n][by2];
    }

    @Override
    public final double[][] getFitnessTable() {
        return this.fitness;
    }

    @Override
    public void initializeToFittest(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = 0;
        }
    }
}

