/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.antigenic.phyloclustering.misc.obsolete;

import dr.evomodel.antigenic.phyloclustering.operators.serumDriftActiveScaledMu1Operator;
import dr.inference.model.MatrixParameter;
import dr.inference.model.Parameter;
import dr.inference.operators.AbstractAdaptableOperator;
import dr.inference.operators.AdaptationMode;
import dr.math.MathUtils;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class serumDriftScalingMuOperator
extends AbstractAdaptableOperator {
    private Parameter serumDrift = null;
    private MatrixParameter mu = null;
    private Parameter muMean = null;
    private Parameter muPrec = null;
    private double scaleFactor;
    public static final String SERUMDRIFTSCALINGMUOperator = "serumDriftScalingMuOperator";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        public static final String SCALE = "scaleFactor";
        public static final String MU = "mu";
        public static final String SERUMDRIFT = "serumDrift";
        public static final String MUMEAN = "muMean";
        public static final String MUPREC = "muPrec";
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newDoubleRule("weight"), AttributeRule.newDoubleRule("scaleFactor"), new ElementRule("mu", Parameter.class), new ElementRule("muMean", Parameter.class), new ElementRule("muPrec", Parameter.class), new ElementRule("serumDrift", Parameter.class)};

        @Override
        public String getParserName() {
            return serumDriftScalingMuOperator.SERUMDRIFTSCALINGMUOperator;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            double d = xMLObject.getDoubleAttribute("weight");
            double d2 = xMLObject.getDoubleAttribute(SCALE);
            XMLObject xMLObject2 = xMLObject.getChild(MU);
            MatrixParameter matrixParameter = (MatrixParameter)xMLObject2.getChild(MatrixParameter.class);
            xMLObject2 = xMLObject.getChild(SERUMDRIFT);
            Parameter parameter = (Parameter)xMLObject2.getChild(Parameter.class);
            xMLObject2 = xMLObject.getChild(MUMEAN);
            Parameter parameter2 = (Parameter)xMLObject2.getChild(Parameter.class);
            xMLObject2 = xMLObject.getChild(MUPREC);
            Parameter parameter3 = (Parameter)xMLObject2.getChild(Parameter.class);
            return new serumDriftScalingMuOperator(d, matrixParameter, parameter2, parameter3, parameter, d2);
        }

        @Override
        public String getParserDescription() {
            return "changes serum drift and make sure the first dimension of the active drifted mus stay the same";
        }

        @Override
        public Class getReturnType() {
            return serumDriftActiveScaledMu1Operator.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };

    public serumDriftScalingMuOperator(double d, MatrixParameter matrixParameter, Parameter parameter, Parameter parameter2, Parameter parameter3, double d2) {
        super(AdaptationMode.ADAPTATION_ON);
        this.setWeight(d);
        this.mu = matrixParameter;
        this.muMean = parameter;
        this.muPrec = parameter2;
        this.serumDrift = parameter3;
        this.scaleFactor = d2;
    }

    @Override
    public double doOperation() {
        double d = this.scaleFactor + MathUtils.nextDouble() * (1.0 / this.scaleFactor - this.scaleFactor);
        this.serumDrift.setParameterValue(0, d * this.serumDrift.getParameterValue(0));
        for (int i = 0; i < this.mu.getColumnDimension(); ++i) {
            Parameter parameter = this.mu.getParameter(i);
            parameter.setParameterValue(0, d * parameter.getParameterValue(0));
        }
        this.muMean.setParameterValue(0, d * this.muMean.getParameterValue(0));
        this.muPrec.setParameterValue(0, d * d * this.muPrec.getParameterValue(0));
        double d2 = -Math.log(d);
        return d2;
    }

    @Override
    protected double getAdaptableParameterValue() {
        return Math.log(1.0 / this.scaleFactor - 1.0);
    }

    @Override
    public void setAdaptableParameterValue(double d) {
        this.scaleFactor = 1.0 / (Math.exp(d) + 1.0);
    }

    @Override
    public double getRawParameter() {
        return this.scaleFactor;
    }

    @Override
    public String getAdaptableParameterName() {
        return "scaleFactor";
    }

    @Override
    public final String getOperatorName() {
        return SERUMDRIFTSCALINGMUOperator;
    }

    public int getStepCount() {
        return 1;
    }
}

