/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.operators;

import dr.evolution.tree.NodeRef;
import dr.evomodel.operators.AbstractTreeOperator;
import dr.evomodel.tree.TreeModel;
import dr.math.MathUtils;

public class ExchangeOperator
extends AbstractTreeOperator {
    public static final int NARROW = 0;
    public static final int WIDE = 1;
    private static final int MAX_TRIES = 100;
    private int mode = 0;
    private final TreeModel tree;
    private double[] distances;

    public ExchangeOperator(int n, TreeModel treeModel, double d) {
        this.mode = n;
        this.tree = treeModel;
        this.setWeight(d);
    }

    @Override
    public double doOperation() {
        double d;
        int n = this.tree.getExternalNodeCount();
        switch (this.mode) {
            case 0: {
                d = this.narrow() ? 0.0 : Double.NEGATIVE_INFINITY;
                break;
            }
            case 1: {
                d = this.wide() ? 0.0 : Double.NEGATIVE_INFINITY;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknow Exchange Mode");
            }
        }
        assert (this.tree.getExternalNodeCount() == n) : "Lost some tips in " + (this.mode == 0 ? "NARROW mode." : "WIDE mode.");
        return d;
    }

    public boolean narrow() {
        NodeRef nodeRef;
        int n = this.tree.getNodeCount();
        NodeRef nodeRef2 = nodeRef = this.tree.getRoot();
        while (nodeRef == nodeRef2 || this.tree.getParent(nodeRef2) == nodeRef) {
            nodeRef2 = this.tree.getNode(MathUtils.nextInt(n));
        }
        NodeRef nodeRef3 = this.tree.getParent(nodeRef2);
        NodeRef nodeRef4 = this.tree.getParent(nodeRef3);
        NodeRef nodeRef5 = this.tree.getChild(nodeRef4, 0);
        if (nodeRef5 == nodeRef3) {
            nodeRef5 = this.tree.getChild(nodeRef4, 1);
        }
        assert (nodeRef5 == this.getOtherChild(this.tree, nodeRef4, nodeRef3));
        assert (this.tree.getNodeHeight(nodeRef2) <= this.tree.getNodeHeight(nodeRef4));
        if (this.tree.getNodeHeight(nodeRef5) < this.tree.getNodeHeight(nodeRef3)) {
            this.exchangeNodes(this.tree, nodeRef2, nodeRef5, nodeRef3, nodeRef4);
            return true;
        }
        return false;
    }

    public boolean wide() {
        NodeRef nodeRef;
        NodeRef nodeRef2;
        int n = this.tree.getNodeCount();
        NodeRef nodeRef3 = nodeRef2 = this.tree.getRoot();
        while (nodeRef2 == nodeRef3) {
            nodeRef3 = this.tree.getNode(MathUtils.nextInt(n));
        }
        NodeRef nodeRef4 = nodeRef3;
        while (nodeRef4 == nodeRef3 || nodeRef4 == nodeRef2) {
            nodeRef4 = this.tree.getNode(MathUtils.nextInt(n));
        }
        NodeRef nodeRef5 = this.tree.getParent(nodeRef3);
        if (nodeRef5 != (nodeRef = this.tree.getParent(nodeRef4)) && nodeRef3 != nodeRef && nodeRef4 != nodeRef5 && this.tree.getNodeHeight(nodeRef4) < this.tree.getNodeHeight(nodeRef5) && this.tree.getNodeHeight(nodeRef3) < this.tree.getNodeHeight(nodeRef)) {
            this.exchangeNodes(this.tree, nodeRef3, nodeRef4, nodeRef5, nodeRef);
            return true;
        }
        return false;
    }

    private int indexOf(NodeRef[] nodeRefArray, NodeRef nodeRef) {
        for (int i = 0; i < nodeRefArray.length; ++i) {
            if (nodeRefArray[i] != nodeRef) continue;
            return i;
        }
        return -1;
    }

    private double getWinningChance(int n) {
        double d = 0.0;
        for (double d2 : this.distances) {
            d += 1.0 / d2;
        }
        return 1.0 / this.distances[n] / d;
    }

    private void calcDistances(NodeRef[] nodeRefArray, NodeRef nodeRef) {
        this.distances = new double[nodeRefArray.length];
        for (int i = 0; i < nodeRefArray.length; ++i) {
            this.distances[i] = this.getNodeDistance(nodeRef, nodeRefArray[i]) + 1;
        }
    }

    private NodeRef getRandomNode(NodeRef[] nodeRefArray, NodeRef nodeRef) {
        this.calcDistances(nodeRefArray, nodeRef);
        double d = 0.0;
        for (double d2 : this.distances) {
            d += 1.0 / d2;
        }
        double d3 = MathUtils.nextDouble() * d;
        NodeRef nodeRef2 = null;
        for (int i = 0; i < this.distances.length; ++i) {
            if (!((d3 -= 1.0 / this.distances[i]) <= 0.0)) continue;
            nodeRef2 = nodeRefArray[i];
            break;
        }
        return nodeRef2;
    }

    private int getNodeDistance(NodeRef nodeRef, NodeRef nodeRef2) {
        int n = 0;
        while (nodeRef != nodeRef2) {
            ++n;
            if (this.tree.getNodeHeight(nodeRef) < this.tree.getNodeHeight(nodeRef2)) {
                nodeRef = this.tree.getParent(nodeRef);
                continue;
            }
            nodeRef2 = this.tree.getParent(nodeRef2);
        }
        return n;
    }

    public int getMode() {
        return this.mode;
    }

    @Override
    public String getOperatorName() {
        return (this.mode == 0 ? "Narrow" : "Wide") + " Exchange(" + this.tree.getId() + ")";
    }

    public double getMinimumAcceptanceLevel() {
        if (this.mode == 0) {
            return 0.05;
        }
        return 0.01;
    }

    public double getMinimumGoodAcceptanceLevel() {
        if (this.mode == 0) {
            return 0.05;
        }
        return 0.01;
    }

    public String getPerformanceSuggestion() {
        return "";
    }
}

