/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treedatalikelihood.continuous.cdi;

import dr.evomodel.treedatalikelihood.continuous.cdi.ResourceDetails;

public class CDIJNIWrapper {
    public static final String LIBRARY_NAME = CDIJNIWrapper.getPlatformSpecificLibraryName();
    public static CDIJNIWrapper INSTANCE;

    private CDIJNIWrapper() {
    }

    public native String getVersion();

    public native String getCitation();

    public native ResourceDetails[] getResourceList();

    private static String getPlatformSpecificLibraryName() {
        String string = System.getProperty("os.name").toLowerCase();
        String string2 = System.getProperty("os.arch").toLowerCase();
        if (string.startsWith("windows")) {
            if (string2.equals("x86") || string2.equals("i386")) {
                return "cdi32";
            }
            if (string2.startsWith("amd64") || string2.startsWith("x86_64")) {
                return "cdi64";
            }
        }
        return "cdi-jni";
    }

    public static void loadCDILibrary() throws UnsatisfiedLinkError {
        String string = "";
        if (System.getProperty("cdi.library.path") != null && (string = System.getProperty("cdi.library.path")).length() > 0 && !string.endsWith("/")) {
            string = string + "/";
        }
        System.loadLibrary(string + LIBRARY_NAME);
        INSTANCE = new CDIJNIWrapper();
    }
}

