/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.DistanceFunction;
import weka.core.EuclideanDistance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Utils;

public abstract class NearestNeighbourSearch
implements Serializable {
    protected Instances m_Instances;
    protected int m_kNN;
    protected DistanceFunction m_DistanceFunction = new EuclideanDistance();

    public NearestNeighbourSearch() {
    }

    public NearestNeighbourSearch(Instances instances) {
        this.m_Instances = instances;
    }

    public abstract Instance nearestNeighbour(Instance var1) throws Exception;

    public abstract Instances kNearestNeighbours(Instance var1, int var2) throws Exception;

    public abstract double[] getDistances() throws Exception;

    public abstract void update(Instance var1) throws Exception;

    public void addInstanceInfo(Instance instance) {
    }

    public void setInstances(Instances instances) throws Exception {
        this.m_Instances = instances;
    }

    public Instances getInstances() {
        return this.m_Instances;
    }

    public String distanceFunctionTipText() {
        return "The distance function to use for finding neighbours (default: weka.core.EuclideanDistance). ";
    }

    public DistanceFunction getDistanceFunction() {
        return this.m_DistanceFunction;
    }

    public void setDistanceFunction(DistanceFunction distanceFunction) throws Exception {
        this.m_DistanceFunction = distanceFunction;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        vector.add(new Option("\tDistance function to use.\n", "A", 1, "-A"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('A', stringArray);
        if (string.length() != 0) {
            String[] stringArray2 = Utils.splitOptions(string);
            if (stringArray2.length == 0) {
                throw new Exception("Invalid DistanceFunction specification string.");
            }
            String string2 = stringArray2[0];
            stringArray2[0] = "";
            this.setDistanceFunction((DistanceFunction)Utils.forName(DistanceFunction.class, string2, stringArray2));
        } else {
            this.setDistanceFunction(new EuclideanDistance());
        }
    }

    public String[] getOptions() {
        String[] stringArray = new String[]{"-A", this.m_DistanceFunction.getClass().getName() + new String(" " + Utils.joinOptions(this.m_DistanceFunction.getOptions())).trim()};
        return stringArray;
    }

    public static void combSort11(double[] dArray, int[] nArray) {
        int n;
        int n2 = dArray.length;
        do {
            n2 = (int)((double)n2 / 1.3);
            switch (n2) {
                case 0: {
                    n2 = 1;
                    break;
                }
                case 9: 
                case 10: {
                    n2 = 11;
                    break;
                }
            }
            n = 0;
            int n3 = dArray.length - n2;
            for (int i = 0; i < n3; ++i) {
                int n4 = i + n2;
                if (!(dArray[i] > dArray[n4])) continue;
                double d = dArray[i];
                int n5 = nArray[i];
                dArray[i] = dArray[n4];
                nArray[i] = nArray[n4];
                dArray[n4] = d;
                nArray[n4] = n5;
                ++n;
            }
        } while (n > 0 || n2 > 1);
    }
}

